/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.io.OutboundBindAddressResourceDefinition;
import org.wildfly.extension.io.WorkerAdd;
import org.wildfly.extension.io.WorkerServerDefinition;
import org.wildfly.extension.io.logging.IOLogger;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.management.XnioWorkerMXBean;

class WorkerResourceDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> IO_WORKER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.io.worker", (boolean)true, XnioWorker.class).build();
    static final OptionAttributeDefinition WORKER_TASK_MAX_THREADS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("task-max-threads", Options.WORKER_TASK_MAX_THREADS).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new IntRangeValidator(0))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition WORKER_TASK_KEEPALIVE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("task-keepalive", Options.WORKER_TASK_KEEPALIVE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(60000))).setValidator((ParameterValidator)new IntRangeValidator(0))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition STACK_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("stack-size", Options.STACK_SIZE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(0L))).setValidator((ParameterValidator)new LongRangeValidator(0L))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition WORKER_IO_THREADS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("io-threads", Options.WORKER_IO_THREADS).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new IntRangeValidator(0))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition[] ATTRIBUTES = new OptionAttributeDefinition[]{WORKER_IO_THREADS, WORKER_TASK_KEEPALIVE, WORKER_TASK_MAX_THREADS, STACK_SIZE};
    private static final AttributeDefinition SHUTDOWN_REQUESTED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("shutdown-requested", ModelType.BOOLEAN).setStorageRuntime()).setUndefinedMetricValue(new ModelNode(false))).build();
    private static final AttributeDefinition CORE_WORKER_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("core-pool-size", ModelType.INT).setStorageRuntime()).setUndefinedMetricValue(new ModelNode(0))).build();
    private static final AttributeDefinition MAX_WORKER_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-pool-size", ModelType.INT).setStorageRuntime()).setUndefinedMetricValue(new ModelNode(0))).build();
    private static final AttributeDefinition IO_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("io-thread-count", ModelType.INT).setStorageRuntime()).setUndefinedMetricValue(new ModelNode(0))).build();
    private static final AttributeDefinition QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("queue-size", ModelType.INT).setStorageRuntime()).setUndefinedMetricValue(new ModelNode(0))).build();
    static final Map<String, OptionAttributeDefinition> ATTRIBUTES_BY_XMLNAME;
    static final WorkerResourceDefinition INSTANCE;

    private WorkerResourceDefinition() {
        super(IOExtension.WORKER_PATH, (ResourceDescriptionResolver)IOExtension.getResolver("worker"), (OperationStepHandler)WorkerAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_BY_XMLNAME.values();
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(IO_WORKER_RUNTIME_CAPABILITY);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)WORKER_TASK_MAX_THREADS, (OperationStepHandler)new WorkerReadAttributeHandler(WORKER_TASK_MAX_THREADS.getOption()), (OperationStepHandler)new WorkerWriteAttributeHandler(new AttributeDefinition[]{WORKER_TASK_MAX_THREADS}){

            @Override
            boolean setValue(XnioWorker worker, ModelNode value) throws IOException {
                return worker.setOption(Options.WORKER_TASK_MAX_THREADS, (Object)value.asInt()) == null;
            }
        });
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)WORKER_TASK_KEEPALIVE, (OperationStepHandler)new WorkerReadAttributeHandler(WORKER_TASK_KEEPALIVE.getOption()), (OperationStepHandler)new WorkerWriteAttributeHandler(new AttributeDefinition[]{WORKER_TASK_KEEPALIVE}){

            @Override
            boolean setValue(XnioWorker worker, ModelNode value) throws IOException {
                return worker.setOption(Options.WORKER_TASK_KEEPALIVE, (Object)value.asInt()) == null;
            }
        });
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)STACK_SIZE, (OperationStepHandler)new WorkerReadAttributeHandler(STACK_SIZE.getOption()), (OperationStepHandler)new WorkerWriteAttributeHandler(new AttributeDefinition[]{STACK_SIZE}){

            @Override
            boolean setValue(XnioWorker worker, ModelNode value) throws IOException {
                return worker.setOption(Options.STACK_SIZE, (Object)value.asLong()) == null;
            }
        });
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)WORKER_IO_THREADS, (OperationStepHandler)new WorkerReadAttributeHandler(WORKER_IO_THREADS.getOption()), (OperationStepHandler)new WorkerWriteAttributeHandler(new AttributeDefinition[]{WORKER_IO_THREADS}){

            @Override
            boolean setValue(XnioWorker worker, ModelNode value) throws IOException {
                return worker.setOption(Options.WORKER_IO_THREADS, (Object)value.asInt()) == null;
            }
        });
        WorkerMetricsHandler metricsHandler = new WorkerMetricsHandler();
        resourceRegistration.registerMetric(SHUTDOWN_REQUESTED, (OperationStepHandler)metricsHandler);
        resourceRegistration.registerMetric(CORE_WORKER_POOL_SIZE, (OperationStepHandler)metricsHandler);
        resourceRegistration.registerMetric(MAX_WORKER_POOL_SIZE, (OperationStepHandler)metricsHandler);
        resourceRegistration.registerMetric(IO_THREAD_COUNT, (OperationStepHandler)metricsHandler);
        resourceRegistration.registerMetric(QUEUE_SIZE, (OperationStepHandler)metricsHandler);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new WorkerServerDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)OutboundBindAddressResourceDefinition.getInstance());
    }

    static XnioWorker getXnioWorker(OperationContext context) {
        String name = context.getCurrentAddressValue();
        if (!context.getCurrentAddress().getLastElement().getKey().equals(IOExtension.WORKER_PATH.getKey())) {
            for (PathElement pe : context.getCurrentAddress()) {
                if (!pe.getKey().equals(IOExtension.WORKER_PATH.getKey())) continue;
                name = pe.getValue();
                break;
            }
        }
        return WorkerResourceDefinition.getXnioWorker(context.getServiceRegistry(false), name);
    }

    static XnioWorker getXnioWorker(ServiceRegistry serviceRegistry, String name) {
        ServiceName serviceName = IO_WORKER_RUNTIME_CAPABILITY.getCapabilityServiceName(name, XnioWorker.class);
        ServiceController controller = serviceRegistry.getService(serviceName);
        if (controller == null || controller.getState() != ServiceController.State.UP) {
            return null;
        }
        return (XnioWorker)controller.getValue();
    }

    private static XnioWorkerMXBean getMetrics(ServiceRegistry serviceRegistry, String name) {
        XnioWorker worker = WorkerResourceDefinition.getXnioWorker(serviceRegistry, name);
        if (worker != null && worker.getMXBean() != null) {
            return worker.getMXBean();
        }
        return null;
    }

    private static ModelNode getMetricValue(String attributeName, XnioWorkerMXBean metric) throws OperationFailedException {
        if (SHUTDOWN_REQUESTED.getName().equals(attributeName)) {
            return new ModelNode(metric.isShutdownRequested());
        }
        if (CORE_WORKER_POOL_SIZE.getName().equals(attributeName)) {
            return new ModelNode(metric.getCoreWorkerPoolSize());
        }
        if (MAX_WORKER_POOL_SIZE.getName().equals(attributeName)) {
            return new ModelNode(metric.getMaxWorkerPoolSize());
        }
        if (IO_THREAD_COUNT.getName().equals(attributeName)) {
            return new ModelNode(metric.getIoThreadCount());
        }
        if (QUEUE_SIZE.getName().equals(attributeName)) {
            return new ModelNode(metric.getWorkerQueueSize());
        }
        throw new OperationFailedException(IOLogger.ROOT_LOGGER.noMetrics());
    }

    static {
        HashMap<String, OptionAttributeDefinition> attrs = new HashMap<String, OptionAttributeDefinition>();
        for (OptionAttributeDefinition attr : ATTRIBUTES) {
            attrs.put(attr.getXmlName(), attr);
        }
        ATTRIBUTES_BY_XMLNAME = Collections.unmodifiableMap(attrs);
        INSTANCE = new WorkerResourceDefinition();
    }

    static class WorkerResource
    extends DelegatingResource {
        private final ServiceRegistry serviceRegistry;
        private final PathAddress pathAddress;

        public WorkerResource(OperationContext context) {
            super(Resource.Factory.create());
            this.serviceRegistry = context.getServiceRegistry(false);
            this.pathAddress = context.getCurrentAddress();
            super.registerResourceProvider("server", new ResourceProvider(){

                public boolean has(String name) {
                    return this.children().contains(name);
                }

                public Resource get(String name) {
                    return PlaceholderResource.INSTANCE;
                }

                public boolean hasChildren() {
                    return false;
                }

                public Set<String> children() {
                    XnioWorkerMXBean metrics = WorkerResourceDefinition.getMetrics(serviceRegistry, pathAddress.getLastElement().getValue());
                    if (metrics == null) {
                        return Collections.emptySet();
                    }
                    LinkedHashSet<String> res = new LinkedHashSet<String>();
                    metrics.getServerMXBeans().forEach(serverMXBean -> res.add(serverMXBean.getBindAddress()));
                    return res;
                }

                public void register(String name, Resource resource) {
                    throw new UnsupportedOperationException();
                }

                public void register(String value, int index, Resource resource) {
                    throw new UnsupportedOperationException();
                }

                public Resource remove(String name) {
                    return null;
                }

                public ResourceProvider clone() {
                    return this;
                }
            });
        }

        public Set<String> getChildTypes() {
            LinkedHashSet<String> result = new LinkedHashSet<String>(super.getChildTypes());
            result.add("server");
            return result;
        }
    }

    private static class WorkerMetricsHandler
    extends AbstractWorkerAttributeHandler {
        private WorkerMetricsHandler() {
        }

        @Override
        void executeWithWorker(OperationContext context, ModelNode operation, XnioWorker worker) throws OperationFailedException {
            XnioWorkerMXBean metrics = worker.getMXBean();
            String name = operation.require("name").asString();
            context.getResult().set(WorkerResourceDefinition.getMetricValue(name, metrics));
        }
    }

    private static class WorkerReadAttributeHandler
    extends AbstractWorkerAttributeHandler {
        final Option<?> option;

        public WorkerReadAttributeHandler(Option<?> option) {
            this.option = option;
        }

        @Override
        void executeWithWorker(OperationContext context, ModelNode operation, XnioWorker worker) throws OperationFailedException {
            try {
                Object result = worker.getOption(this.option);
                if (result != null) {
                    context.getResult().set(new ModelNode(result.toString()));
                }
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    private static abstract class WorkerWriteAttributeHandler
    extends AbstractWriteAttributeHandler {
        WorkerWriteAttributeHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode value, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder handbackHolder) throws OperationFailedException {
            XnioWorker worker = WorkerResourceDefinition.getXnioWorker(context);
            if (worker == null) {
                return true;
            }
            try {
                return this.setValue(worker, value);
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Object handback) throws OperationFailedException {
            XnioWorker worker = WorkerResourceDefinition.getXnioWorker(context);
            if (worker == null) {
                return;
            }
            try {
                this.setValue(worker, valueToRestore);
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }

        abstract boolean setValue(XnioWorker var1, ModelNode var2) throws IOException;
    }

    private static abstract class AbstractWorkerAttributeHandler
    implements OperationStepHandler {
        private AbstractWorkerAttributeHandler() {
        }

        private static void populateValueFromModel(OperationContext context, ModelNode operation) {
            ModelNode subModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode result = subModel.get(operation.require("name").asString());
            context.getResult().set(result);
        }

        public void execute(OperationContext outContext, ModelNode operation) throws OperationFailedException {
            AbstractWorkerAttributeHandler.populateValueFromModel(outContext, operation);
            if (!"profile".equals(outContext.getCurrentAddress().getElement(0).getKey())) {
                outContext.addStep((context, op) -> {
                    XnioWorker worker = WorkerResourceDefinition.getXnioWorker(context);
                    if (worker != null) {
                        this.executeWithWorker(context, op, worker);
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        abstract void executeWithWorker(OperationContext var1, ModelNode var2, XnioWorker var3) throws OperationFailedException;
    }
}

