/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.protocol.SocketDiscoveryProtocol;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.SocketDiscoveryProtocolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class SocketDiscoveryProtocolConfigurationBuilder<P extends Protocol>
extends ProtocolConfigurationBuilder<P> {
    private volatile List<ValueDependency<OutboundSocketBinding>> bindings;

    public SocketDiscoveryProtocolConfigurationBuilder(PathAddress address) {
        super(address);
    }

    @Override
    public Builder<ProtocolConfiguration<P>> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.bindings = StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)SocketDiscoveryProtocolResourceDefinition.Attribute.OUTBOUND_SOCKET_BINDINGS.resolveModelAttribute((ExpressionResolver)context, model)).stream().map(binding -> new InjectedValueDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, binding), OutboundSocketBinding.class)).collect(Collectors.toList());
        return super.configure(context, model);
    }

    @Override
    public ServiceBuilder<ProtocolConfiguration<P>> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        this.bindings.forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public void accept(P protocol) {
        if (!this.bindings.isEmpty()) {
            ((SocketDiscoveryProtocol)protocol).setSocketAddresses(this.bindings.stream().map(Value::getValue).map(binding -> {
                try {
                    return new InetSocketAddress(binding.getResolvedDestinationAddress(), binding.getDestinationPort());
                }
                catch (UnknownHostException e) {
                    throw JGroupsLogger.ROOT_LOGGER.failedToResolveSocketBinding(e, (OutboundSocketBinding)binding);
                }
            }).collect(Collectors.toList()));
        }
    }
}

