/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.jms;

import java.util.Collections;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerDestination;
import org.apache.activemq.artemis.reader.MessageUtil;

public class ServerJMSMessage
implements Message {
    protected final MessageInternal message;
    protected int deliveryCount;
    private ActiveMQBuffer readBodyBuffer;

    public MessageInternal getInnerMessage() {
        return this.message;
    }

    public ServerJMSMessage(MessageInternal message, int deliveryCount) {
        this.message = message;
        this.deliveryCount = deliveryCount;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    protected ActiveMQBuffer getReadBodyBuffer() {
        if (this.readBodyBuffer == null) {
            this.readBodyBuffer = this.message.getBodyBufferDuplicate();
        }
        return this.readBodyBuffer;
    }

    protected ActiveMQBuffer getWriteBodyBuffer() {
        this.readBodyBuffer = null;
        return this.message.getBodyBuffer();
    }

    public final String getJMSMessageID() throws JMSException {
        if (this.message.containsProperty("NATIVE_MESSAGE_ID")) {
            return this.getStringProperty("NATIVE_MESSAGE_ID");
        }
        return null;
    }

    public final void setJMSMessageID(String id) throws JMSException {
        if (id != null) {
            this.message.putStringProperty("NATIVE_MESSAGE_ID", id);
        }
    }

    public final long getJMSTimestamp() throws JMSException {
        return this.message.getTimestamp();
    }

    public final void setJMSTimestamp(long timestamp) throws JMSException {
        this.message.setTimestamp(timestamp);
    }

    public final byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return MessageUtil.getJMSCorrelationIDAsBytes((org.apache.activemq.artemis.api.core.Message)this.message);
    }

    public final void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        try {
            MessageUtil.setJMSCorrelationIDAsBytes((org.apache.activemq.artemis.api.core.Message)this.message, (byte[])correlationID);
        }
        catch (ActiveMQException e) {
            throw new JMSException(e.getMessage());
        }
    }

    public final void setJMSCorrelationID(String correlationID) throws JMSException {
        MessageUtil.setJMSCorrelationID((org.apache.activemq.artemis.api.core.Message)this.message, (String)correlationID);
    }

    public final String getJMSCorrelationID() throws JMSException {
        return MessageUtil.getJMSCorrelationID((org.apache.activemq.artemis.api.core.Message)this.message);
    }

    public final Destination getJMSReplyTo() throws JMSException {
        SimpleString reply = MessageUtil.getJMSReplyTo((org.apache.activemq.artemis.api.core.Message)this.message);
        if (reply != null) {
            return new ServerDestination(reply.toString());
        }
        return null;
    }

    public final void setJMSReplyTo(Destination replyTo) throws JMSException {
        MessageUtil.setJMSReplyTo((org.apache.activemq.artemis.api.core.Message)this.message, replyTo == null ? null : ((ActiveMQDestination)replyTo).getSimpleAddress());
    }

    public final Destination getJMSDestination() throws JMSException {
        SimpleString sdest = this.message.getAddress();
        if (sdest == null) {
            return null;
        }
        return new ServerDestination(sdest.toString());
    }

    public final void setJMSDestination(Destination destination) throws JMSException {
        if (destination == null) {
            this.message.setAddress(null);
        } else {
            this.message.setAddress(((ActiveMQDestination)destination).getSimpleAddress());
        }
    }

    public final int getJMSDeliveryMode() throws JMSException {
        return this.message.isDurable() ? 2 : 1;
    }

    public final void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            this.message.setDurable(true);
        } else if (deliveryMode == 1) {
            this.message.setDurable(false);
        } else {
            throw new JMSException("Invalid mode " + deliveryMode);
        }
    }

    public final boolean getJMSRedelivered() throws JMSException {
        return false;
    }

    public final void setJMSRedelivered(boolean redelivered) throws JMSException {
    }

    public final String getJMSType() throws JMSException {
        return MessageUtil.getJMSType((org.apache.activemq.artemis.api.core.Message)this.message);
    }

    public final void setJMSType(String type) throws JMSException {
        MessageUtil.setJMSType((org.apache.activemq.artemis.api.core.Message)this.message, (String)type);
    }

    public final long getJMSExpiration() throws JMSException {
        return this.message.getExpiration();
    }

    public final void setJMSExpiration(long expiration) throws JMSException {
        this.message.setExpiration(expiration);
    }

    public final long getJMSDeliveryTime() throws JMSException {
        return 0L;
    }

    public final void setJMSDeliveryTime(long deliveryTime) throws JMSException {
    }

    public final int getJMSPriority() throws JMSException {
        return this.message.getPriority();
    }

    public final void setJMSPriority(int priority) throws JMSException {
        this.message.setPriority((byte)priority);
    }

    public final void clearProperties() throws JMSException {
        MessageUtil.clearProperties((org.apache.activemq.artemis.api.core.Message)this.message);
    }

    public final boolean propertyExists(String name) throws JMSException {
        return MessageUtil.propertyExists((org.apache.activemq.artemis.api.core.Message)this.message, (String)name);
    }

    public final boolean getBooleanProperty(String name) throws JMSException {
        return this.message.getBooleanProperty(name);
    }

    public final byte getByteProperty(String name) throws JMSException {
        return this.message.getByteProperty(name);
    }

    public final short getShortProperty(String name) throws JMSException {
        return this.message.getShortProperty(name);
    }

    public final int getIntProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return this.deliveryCount;
        }
        return this.message.getIntProperty(name);
    }

    public final long getLongProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return this.deliveryCount;
        }
        return this.message.getLongProperty(name);
    }

    public final float getFloatProperty(String name) throws JMSException {
        return this.message.getFloatProperty(name).floatValue();
    }

    public final double getDoubleProperty(String name) throws JMSException {
        return this.message.getDoubleProperty(name);
    }

    public final String getStringProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return String.valueOf(this.deliveryCount);
        }
        return this.message.getStringProperty(name);
    }

    public final Object getObjectProperty(String name) throws JMSException {
        Object val = this.message.getObjectProperty(name);
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    public final Enumeration getPropertyNames() throws JMSException {
        return Collections.enumeration(MessageUtil.getPropertyNames((org.apache.activemq.artemis.api.core.Message)this.message));
    }

    public final void setBooleanProperty(String name, boolean value) throws JMSException {
        this.message.putBooleanProperty(name, value);
    }

    public final void setByteProperty(String name, byte value) throws JMSException {
        this.message.putByteProperty(name, value);
    }

    public final void setShortProperty(String name, short value) throws JMSException {
        this.message.putShortProperty(name, value);
    }

    public final void setIntProperty(String name, int value) throws JMSException {
        this.message.putIntProperty(name, value);
    }

    public final void setLongProperty(String name, long value) throws JMSException {
        this.message.putLongProperty(name, value);
    }

    public final void setFloatProperty(String name, float value) throws JMSException {
        this.message.putFloatProperty(name, value);
    }

    public final void setDoubleProperty(String name, double value) throws JMSException {
        this.message.putDoubleProperty(name, value);
    }

    public final void setStringProperty(String name, String value) throws JMSException {
        this.message.putStringProperty(name, value);
    }

    public final void setObjectProperty(String name, Object value) throws JMSException {
        this.message.putObjectProperty(name, value);
    }

    public final void acknowledge() throws JMSException {
    }

    public void clearBody() throws JMSException {
        this.message.getBodyBuffer().clear();
    }

    public final <T> T getBody(Class<T> c) throws JMSException {
        return null;
    }

    public void encode() throws Exception {
        this.message.getBodyBuffer().resetReaderIndex();
    }

    public void decode() throws Exception {
        this.message.getBodyBuffer().resetReaderIndex();
    }

    public final boolean isBodyAssignableTo(Class c) throws JMSException {
        return false;
    }
}

