/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.util.Arrays;
import org.jboss.aesh.console.Prompt;

public class Buffer {
    private int cursor = 0;
    private StringBuilder line;
    private Prompt prompt;
    private int delta;
    private boolean disablePrompt = false;
    private boolean multiLine = false;
    private StringBuilder multiLineBuffer;
    private static boolean ansi = true;
    private boolean echo = true;
    private static final int TAB = 4;

    protected Buffer(boolean ansi) {
        this(ansi, null);
    }

    protected Buffer(boolean ansi, Prompt prompt) {
        Buffer.ansi = ansi;
        this.prompt = prompt != null ? prompt : new Prompt("");
        this.line = new StringBuilder();
        this.delta = 0;
    }

    protected Buffer(Prompt prompt) {
        this(true, prompt);
    }

    protected void reset(Prompt prompt) {
        this.prompt = prompt != null ? prompt : new Prompt("");
        this.cursor = 0;
        this.line = new StringBuilder();
        this.delta = 0;
        this.multiLine = false;
        this.multiLineBuffer = null;
    }

    protected void reset() {
        if (this.prompt == null) {
            this.prompt = new Prompt("");
        }
        this.cursor = 0;
        this.line = new StringBuilder();
        this.delta = 0;
        this.multiLine = false;
        this.multiLineBuffer = null;
    }

    protected void updatePrompt(Prompt prompt) {
        if (this.line.length() > 0) {
            this.prompt = prompt;
        } else {
            this.reset(prompt);
        }
    }

    protected int length() {
        if (this.prompt.isMasking() && this.prompt.getMask().charValue() == '\u0000' || !this.echo) {
            return 1;
        }
        return this.line.length();
    }

    protected int totalLength() {
        if (this.prompt.isMasking() && this.prompt.getMask().charValue() == '\u0000' || !this.echo) {
            return this.disablePrompt ? 1 : this.getPrompt().getLength() + 1;
        }
        return this.disablePrompt ? this.line.length() + 1 : this.line.length() + this.getPrompt().getLength() + 1;
    }

    protected int getCursor() {
        return this.prompt.isMasking() && this.prompt.getMask().charValue() == '\u0000' || !this.echo ? 0 : this.cursor;
    }

    protected int getCursorWithPrompt() {
        if (this.disablePrompt) {
            return this.getCursor() + 1;
        }
        return this.getCursor() + this.getPrompt().getLength() + 1;
    }

    protected Prompt getPrompt() {
        if (!this.isMultiLine()) {
            return this.prompt;
        }
        return new Prompt("> ");
    }

    protected void setCursor(int cursor) {
        this.cursor = cursor;
    }

    protected boolean isMultiLine() {
        return this.multiLine;
    }

    protected void setMultiLine(boolean m) {
        this.multiLine = m;
    }

    protected void updateMultiLineBuffer() {
        String newLine;
        if (this.multiLineBuffer == null) {
            this.multiLineBuffer = new StringBuilder();
        }
        if ((newLine = this.line.toString()).endsWith(" \\")) {
            this.multiLineBuffer.append(newLine.substring(0, newLine.length() - 1));
        } else {
            this.multiLineBuffer.append(newLine);
        }
        this.line = new StringBuilder();
        this.cursor = 0;
    }

    protected String getMultiLineBuffer() {
        return this.multiLineBuffer.toString();
    }

    public boolean isMasking() {
        return this.prompt.isMasking();
    }

    protected void disablePrompt(boolean disable) {
        this.disablePrompt = disable;
    }

    protected boolean isPromptDisabled() {
        return this.disablePrompt;
    }

    protected boolean isEchoing() {
        return this.echo;
    }

    protected void setEcho(boolean echo) {
        this.echo = echo;
    }

    protected char[] move(int move, int termWidth) {
        return this.move(move, termWidth, false);
    }

    protected char[] move(int move, int termWidth, boolean viMode) {
        int newRow;
        move = this.moveCursor(move, viMode);
        int currentRow = this.getCursorWithPrompt() / termWidth;
        if (currentRow > 0 && this.getCursorWithPrompt() % termWidth == 0) {
            --currentRow;
        }
        if ((newRow = (move + this.getCursorWithPrompt()) / termWidth) > 0 && (move + this.getCursorWithPrompt()) % termWidth == 0) {
            --newRow;
        }
        int row = newRow - currentRow;
        this.setCursor(this.getCursor() + move);
        if (this.prompt.isMasking() && this.prompt.getMask().charValue() == '\u0000' || !this.echo) {
            return new char[0];
        }
        int cursor = this.getCursorWithPrompt() % termWidth;
        if (cursor == 0 && this.getCursorWithPrompt() > 0) {
            cursor = termWidth;
        }
        if (row > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Buffer.printAnsi(row + "B")).append(Buffer.printAnsi(cursor + "G"));
            return sb.toString().toCharArray();
        }
        if (row < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Buffer.printAnsi(Math.abs(row) + "A")).append(Buffer.printAnsi(cursor + "G"));
            return sb.toString().toCharArray();
        }
        if (move < 0) {
            return Buffer.printAnsi(Math.abs(move) + "D");
        }
        if (move > 0) {
            return Buffer.printAnsi(move + "C");
        }
        return new char[0];
    }

    public static char[] printAnsi(String out) {
        return Buffer.printAnsi(out.toCharArray());
    }

    private static char[] printAnsi(char[] out) {
        if (!ansi) {
            return new char[0];
        }
        int length = 0;
        for (char c : out) {
            if (c == '\t') {
                length += 4;
                continue;
            }
            ++length;
        }
        char[] ansi = new char[length + 2];
        ansi[0] = 27;
        ansi[1] = 91;
        int counter = 0;
        for (char anOut : out) {
            if (anOut == '\t') {
                Arrays.fill(ansi, counter + 2, counter + 2 + 4, ' ');
                counter += 3;
            } else {
                ansi[counter + 2] = anOut;
            }
            ++counter;
        }
        return ansi;
    }

    private int moveCursor(int move, boolean viMode) {
        if (this.getCursor() == 0 && move <= 0) {
            return 0;
        }
        if (viMode ? this.getCursor() == this.length() - 1 && move > 0 : this.getCursor() == this.length() && move > 0) {
            return 0;
        }
        if (this.getCursor() + move <= 0) {
            return -this.getCursor();
        }
        if (viMode) {
            if (this.getCursor() + move > this.length() - 1) {
                return this.length() - 1 - this.getCursor();
            }
        } else if (this.getCursor() + move > this.length()) {
            return this.length() - this.getCursor();
        }
        return move;
    }

    protected char[] getLineFrom(int position) {
        return this.line.substring(position).toCharArray();
    }

    public String getLine() {
        if (!this.prompt.isMasking() && this.echo) {
            return this.line.toString();
        }
        if (this.echo && this.line.length() > 0 && this.prompt.getMask().charValue() != '\u0000') {
            return String.format("%" + this.line.length() + "s", "").replace(' ', this.prompt.getMask().charValue());
        }
        return "";
    }

    public String getLineNoMask() {
        return this.line.toString();
    }

    protected void setLine(String line) {
        this.delta = line.length() - this.line.length();
        this.line = new StringBuilder(line);
    }

    public String getMultiLine() {
        if (this.multiLine) {
            return this.getMultiLineBuffer() + this.getLine();
        }
        return this.getLine();
    }

    public int getMultiCursor() {
        if (this.multiLine) {
            return this.multiLineBuffer.length() + this.getCursor();
        }
        return this.getCursor();
    }

    protected void delete(int start, int end) {
        this.delta = start - end;
        this.line.delete(start, end);
    }

    protected void insert(int start, String in) {
        this.line.insert(start, in);
    }

    public String getLineWithPrompt() {
        return this.getPrompt().getPromptAsString() + this.line;
    }

    public void write(char c) {
        this.line.insert(this.cursor++, c);
        this.delta = 1;
    }

    public void write(String str) {
        assert (str != null);
        if (this.line.length() == 0) {
            this.line.append(str);
        } else {
            this.line.insert(this.getCursor(), str);
        }
        this.cursor += str.length();
        this.delta = str.length();
    }

    protected void clear() {
        this.line = new StringBuilder();
        this.delta = 0;
    }

    public int getDelta() {
        return this.delta;
    }

    protected boolean changeCase() {
        char c = this.getLine().charAt(this.getCursor());
        if (Character.isLetter(c)) {
            if (Character.isLowerCase(c)) {
                this.line.setCharAt(this.getCursor(), Character.toUpperCase(c));
            } else {
                this.line.setCharAt(this.getCursor(), Character.toLowerCase(c));
            }
            return true;
        }
        return false;
    }

    protected void replaceChar(char rChar) {
        this.line.setCharAt(this.getCursor(), rChar);
    }

    protected void replaceChar(char rChar, int pos) {
        if (pos > -1 && pos < this.line.length()) {
            this.line.setCharAt(pos, rChar);
        }
    }

    protected boolean containRedirection() {
        return this.line.indexOf(">") > -1;
    }

    protected int getRedirectionPosition() {
        return this.line.indexOf(">");
    }
}

