/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.extension.clustering.singleton.SingletonLogger;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentUnitPhaseBuilder;

public class SingletonDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<SingletonPolicy> POLICY_KEY = AttachmentKey.create(SingletonPolicy.class);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        SingletonPolicy policy;
        DeploymentUnit unit = context.getDeploymentUnit();
        if (unit.getParent() == null && (policy = (SingletonPolicy)context.getAttachment(POLICY_KEY)) != null && unit.putAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_BUILDER, (Object)new SingletonDeploymentUnitPhaseBuilder(policy)) == null) {
            SingletonLogger.ROOT_LOGGER.singletonDeploymentDetected(policy);
            ServiceController controller = context.getServiceRegistry().getRequiredService(unit.getServiceName());
            controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                    if (transition.getAfter().equals((Object)ServiceController.Substate.DOWN)) {
                        controller.setMode(ServiceController.Mode.ACTIVE);
                        controller.removeListener((ServiceListener)this);
                    }
                }
            });
            controller.setMode(ServiceController.Mode.NEVER);
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }
}

