/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.util.Collections;
import java.util.Map;
import org.jboss.as.ee.component.deployers.StartupCountdown;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ModuleDeployment
implements Service<ModuleDeployment> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"moduleDeploymentRuntimeInformation"});
    public static final ServiceName START_SERVICE_NAME = ServiceName.of((String[])new String[]{"moduleDeploymentRuntimeInformationStart"});
    private final DeploymentModuleIdentifier identifier;
    private final InjectedValue<DeploymentRepository> deploymentRepository = new InjectedValue();
    private final Map<String, EjbDeploymentInformation> ejbs;
    private final StartupCountdown startupCountdown;

    public ModuleDeployment(DeploymentModuleIdentifier identifier, Map<String, EjbDeploymentInformation> ejbs) {
        this(identifier, ejbs, null);
    }

    public ModuleDeployment(DeploymentModuleIdentifier identifier, Map<String, EjbDeploymentInformation> ejbs, StartupCountdown startupCountdown) {
        this.identifier = identifier;
        this.ejbs = Collections.unmodifiableMap(ejbs);
        this.startupCountdown = startupCountdown;
    }

    public DeploymentModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public Map<String, EjbDeploymentInformation> getEjbs() {
        return this.ejbs;
    }

    public InjectedValue<DeploymentRepository> getDeploymentRepository() {
        return this.deploymentRepository;
    }

    public void start(StartContext context) throws StartException {
        ((DeploymentRepository)this.deploymentRepository.getValue()).add(this.identifier, this);
    }

    public void stop(StopContext context) {
        ((DeploymentRepository)this.deploymentRepository.getValue()).remove(this.identifier);
    }

    public ModuleDeployment getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public static final class ModuleDeploymentStartService
    implements Service<Void> {
        private final DeploymentModuleIdentifier identifier;
        private final InjectedValue<DeploymentRepository> deploymentRepository = new InjectedValue();
        private final StartupCountdown countdown;

        public ModuleDeploymentStartService(DeploymentModuleIdentifier identifier, StartupCountdown countdown) {
            this.identifier = identifier;
            this.countdown = countdown;
        }

        public void start(StartContext startContext) throws StartException {
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    ((DeploymentRepository)deploymentRepository.getValue()).startDeployment(identifier);
                }
            };
            if (this.countdown == null) {
                action.run();
            } else {
                this.countdown.addCallback(action);
            }
        }

        public void stop(StopContext stopContext) {
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }

        public InjectedValue<DeploymentRepository> getDeploymentRepository() {
            return this.deploymentRepository;
        }
    }
}

