/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authorization;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.config.http.AuthorizationConfiguration;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.http.internal.authorization.AbstractPathAuthorizer;
import org.picketlink.internal.el.ELProcessor;

public class ExpressionPathAuthorizer
extends AbstractPathAuthorizer {
    @Inject
    private ELProcessor elProcessor;

    @Override
    protected boolean doAuthorize(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationConfiguration authorizationConfiguration = pathConfiguration.getAuthorizationConfiguration();
        if (authorizationConfiguration.getExpressions() == null) {
            return true;
        }
        String protectedUri = request.getContextPath() + pathConfiguration.getUri();
        int startRegex = protectedUri.indexOf("{");
        if (startRegex == -1) {
            String[] expressions = authorizationConfiguration.getExpressions();
            if (expressions != null) {
                for (String expression : expressions) {
                    try {
                        Object eval = this.elProcessor.eval(expression);
                        if (eval == null || !Boolean.class.isInstance(eval)) {
                            throw new RuntimeException("Authorization expressions [" + expression + "] must evaluate to a boolean.");
                        }
                        if (Boolean.valueOf(eval.toString()).booleanValue()) continue;
                        return false;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to process authorization expression [" + expression + "] for path [" + protectedUri + "].", e);
                    }
                }
            }
        } else {
            String[] expressions = authorizationConfiguration.getExpressions();
            String formattedProtectedUri = protectedUri;
            if (expressions != null) {
                int prefixEnd;
                for (String expression : expressions) {
                    try {
                        Object eval = this.elProcessor.eval(expression);
                        if (eval == null) {
                            throw new RuntimeException("Authorization expressions [" + expression + "] must evaluate to a not null value.");
                        }
                        String expressionPattern = expression.substring(1);
                        if (formattedProtectedUri.indexOf(expressionPattern) == -1) {
                            return false;
                        }
                        formattedProtectedUri = formattedProtectedUri.replace(expressionPattern, eval.toString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to process authorization expression [" + expression + "] for path [" + protectedUri + "].", e);
                    }
                }
                if (!request.getRequestURI().equals(formattedProtectedUri) && (prefixEnd = formattedProtectedUri.lastIndexOf(47)) != -1) {
                    String prefix = formattedProtectedUri.substring(0, prefixEnd);
                    if (!request.getRequestURI().startsWith(prefix)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

