/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Collections;
import org.hibernate.cache.infinispan.access.BaseInvalidationInterceptor;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class NonTxInvalidationInterceptor
extends BaseInvalidationInterceptor {
    private final PutFromLoadValidator putFromLoadValidator;
    private CacheCommandInitializer commandInitializer;
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InvalidationInterceptor.class);

    public NonTxInvalidationInterceptor(PutFromLoadValidator putFromLoadValidator) {
        this.putFromLoadValidator = putFromLoadValidator;
    }

    @Inject
    public void injectDependencies(CacheCommandInitializer commandInitializer) {
        this.commandInitializer = commandInitializer;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }
        boolean isTransactional = this.putFromLoadValidator.registerRemoteInvalidation(command.getKey(), command.getKeyLockOwner());
        if (!isTransactional) {
            throw new IllegalStateException("Put executed without transaction!");
        }
        if (!this.putFromLoadValidator.beginInvalidatingWithPFER(command.getKeyLockOwner(), command.getKey(), command.getValue())) {
            log.failedInvalidatePendingPut(command.getKey(), this.cacheName);
        }
        RemoveCommand removeCommand = this.commandsFactory.buildRemoveCommand(command.getKey(), null, command.getFlags());
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)removeCommand);
        if (command.isSuccessful()) {
            this.invalidateAcrossCluster(command, isTransactional, command.getKey());
        }
        return retval;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        throw new UnsupportedOperationException("Unexpected replace");
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        boolean isTransactional = this.putFromLoadValidator.registerRemoteInvalidation(command.getKey(), command.getKeyLockOwner());
        if (isTransactional) {
            if (!this.putFromLoadValidator.beginInvalidatingKey(command.getKeyLockOwner(), command.getKey())) {
                log.failedInvalidatePendingPut(command.getKey(), this.cacheName);
            }
        } else {
            log.trace("This is an eviction, not invalidating anything");
        }
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (command.isSuccessful()) {
            this.invalidateAcrossCluster(command, isTransactional, command.getKey());
        }
        return retval;
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (!this.isLocalModeForced((FlagAffectedCommand)command) && ctx.isOriginLocal()) {
            this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)command, this.isSynchronous((FlagAffectedCommand)command) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
        return retval;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        throw new UnsupportedOperationException("Unexpected putAll");
    }

    private <T extends WriteCommand & RemoteLockCommand> void invalidateAcrossCluster(T command, boolean isTransactional, Object key) throws Throwable {
        this.incrementInvalidations();
        if (!this.isLocalModeForced((FlagAffectedCommand)command)) {
            InvalidateCommand invalidateCommand = isTransactional ? this.commandInitializer.buildBeginInvalidationCommand(Collections.emptySet(), new Object[]{key}, ((RemoteLockCommand)command).getKeyLockOwner()) : this.commandsFactory.buildInvalidateCommand(Collections.emptySet(), new Object[]{key});
            if (log.isDebugEnabled()) {
                log.debug("Cache [" + this.rpcManager.getAddress() + "] replicating " + invalidateCommand);
            }
            this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)invalidateCommand, this.isSynchronous((FlagAffectedCommand)command) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
    }
}

