/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.metadata.store;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static Class<?> loadClass(final Class<?> theClass, final String fullQualifiedName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    ClassLoader classLoader = theClass.getClassLoader();
                    Class<?> clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
                    if (clazz == null) {
                        classLoader = Thread.currentThread().getContextClassLoader();
                        clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
                    }
                    return clazz;
                }
            });
        }
        ClassLoader classLoader = theClass.getClassLoader();
        Class<?> clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
        if (clazz == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
        }
        return clazz;
    }

    static Class<?> loadClass(final ClassLoader classLoader, final String fullQualifiedName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return classLoader.loadClass(fullQualifiedName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            });
        }
        try {
            return classLoader.loadClass(fullQualifiedName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static String getSystemProperty(final String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
        return System.getProperty(key);
    }

    static void setSystemProperty(final String key, final String value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty(key, value);
                    return null;
                }
            });
        } else {
            System.setProperty(key, value);
        }
    }
}

