/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.job.repository;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.jberet.job.model.Job;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobExecutionSelector;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.batch.jberet._private.BatchLogger;

abstract class JobRepositoryService
implements JobRepository,
Service<JobRepository> {
    private volatile boolean started;

    JobRepositoryService() {
    }

    public final void start(StartContext context) throws StartException {
        this.startJobRepository(context);
        this.started = true;
    }

    public final void stop(StopContext context) {
        this.stopJobRepository(context);
        this.started = false;
    }

    public final JobRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void addJob(ApplicationAndJobName applicationAndJobName, Job job) {
        this.getAndCheckDelegate().addJob(applicationAndJobName, job);
    }

    public void removeJob(String jobId) {
        this.getAndCheckDelegate().removeJob(jobId);
    }

    public Job getJob(ApplicationAndJobName applicationAndJobName) {
        return this.getAndCheckDelegate().getJob(applicationAndJobName);
    }

    public Set<String> getJobNames() {
        return this.getAndCheckDelegate().getJobNames();
    }

    public boolean jobExists(String jobName) {
        return this.getAndCheckDelegate().jobExists(jobName);
    }

    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        return this.getAndCheckDelegate().createJobInstance(job, applicationName, classLoader);
    }

    public void removeJobInstance(long jobInstanceId) {
        this.getAndCheckDelegate().removeJobInstance(jobInstanceId);
    }

    public JobInstance getJobInstance(long jobInstanceId) {
        return this.getAndCheckDelegate().getJobInstance(jobInstanceId);
    }

    public List<JobInstance> getJobInstances(String jobName) {
        return this.getAndCheckDelegate().getJobInstances(jobName);
    }

    public int getJobInstanceCount(String jobName) {
        return this.getAndCheckDelegate().getJobInstanceCount(jobName);
    }

    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        return this.getAndCheckDelegate().createJobExecution(jobInstance, jobParameters);
    }

    public JobExecution getJobExecution(long jobExecutionId) {
        return this.getAndCheckDelegate().getJobExecution(jobExecutionId);
    }

    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        return this.getAndCheckDelegate().getJobExecutions(jobInstance);
    }

    public void updateJobExecution(JobExecutionImpl jobExecution, boolean fullUpdate, boolean saveJobParameters) {
        this.getAndCheckDelegate().updateJobExecution(jobExecution, fullUpdate, saveJobParameters);
    }

    public List<Long> getRunningExecutions(String jobName) {
        return this.getAndCheckDelegate().getRunningExecutions(jobName);
    }

    public void removeJobExecutions(JobExecutionSelector jobExecutionSelector) {
        this.getAndCheckDelegate().removeJobExecutions(jobExecutionSelector);
    }

    public List<StepExecution> getStepExecutions(long jobExecutionId, ClassLoader classLoader) {
        return this.getAndCheckDelegate().getStepExecutions(jobExecutionId, classLoader);
    }

    public StepExecutionImpl createStepExecution(String stepName) {
        return this.getAndCheckDelegate().createStepExecution(stepName);
    }

    public void addStepExecution(JobExecutionImpl jobExecution, StepExecutionImpl stepExecution) {
        this.getAndCheckDelegate().addStepExecution(jobExecution, stepExecution);
    }

    public void updateStepExecution(StepExecution stepExecution) {
        this.getAndCheckDelegate().updateStepExecution(stepExecution);
    }

    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart, ClassLoader classLoader) {
        return this.getAndCheckDelegate().findOriginalStepExecutionForRestart(stepName, jobExecutionToRestart, classLoader);
    }

    public int countStepStartTimes(String stepName, long jobInstanceId) {
        return this.getAndCheckDelegate().countStepStartTimes(stepName, jobInstanceId);
    }

    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, PartitionExecutionImpl partitionExecution) {
        this.getAndCheckDelegate().addPartitionExecution(enclosingStepExecution, partitionExecution);
    }

    public List<PartitionExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly, ClassLoader classLoader) {
        return this.getAndCheckDelegate().getPartitionExecutions(stepExecutionId, stepExecution, notCompletedOnly, classLoader);
    }

    public void savePersistentData(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        this.getAndCheckDelegate().savePersistentData(jobExecution, stepOrPartitionExecution);
    }

    protected abstract void startJobRepository(StartContext var1) throws StartException;

    protected abstract void stopJobRepository(StopContext var1);

    protected abstract JobRepository getDelegate();

    private JobRepository getAndCheckDelegate() {
        JobRepository delegate = this.getDelegate();
        if (this.started && delegate != null) {
            return delegate;
        }
        throw BatchLogger.LOGGER.jobOperatorServiceStopped();
    }
}

