/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;
import org.wildfly.clustering.server.group.LocalGroup;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class LocalGroupBuilder
implements CapabilityServiceBuilder<Group> {
    private final ServiceName name;
    private final String group;
    private volatile ValueDependency<JGroupsNodeFactory> factory;

    public LocalGroupBuilder(ServiceName name, String group) {
        this.name = name;
        this.group = group;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<Group> configure(CapabilityServiceSupport support) {
        this.factory = new InjectedValueDependency(ClusteringRequirement.NODE_FACTORY.getServiceName(support, this.group), JGroupsNodeFactory.class);
        return this;
    }

    public ServiceBuilder<Group> build(ServiceTarget target) {
        Value value = () -> new LocalGroup(this.group, ((JGroupsNodeFactory)this.factory.getValue()).createNode(null));
        return this.factory.register(target.addService(this.name, (Service)new ValueService(value)).setInitialMode(ServiceController.Mode.ON_DEMAND));
    }
}

