/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Deque;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.OperationParameter;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;

class DomainApiGenericOperationHandler
implements HttpHandler {
    private static final String OPERATION = "operation";
    private static final String CLIENT_NAME = "X-Management-Client-Name";
    private final ModelController modelController;
    private final FormParserFactory formParserFactory;
    static final String RELOAD = "reload";

    public DomainApiGenericOperationHandler(ModelController modelController) {
        this.modelController = modelController;
        this.formParserFactory = FormParserFactory.builder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        ModelNode response;
        ModelNode operation;
        OperationParameter.Builder operationParameterBuilder;
        FormData data;
        block41: {
            HeaderMap headers;
            FormDataParser parser = this.formParserFactory.createParser(exchange);
            if (parser == null) {
                Common.UNSUPPORTED_MEDIA_TYPE.handleRequest(exchange);
            }
            if (!(headers = exchange.getRequestHeaders()).contains(Headers.ORIGIN) && !headers.contains(CLIENT_NAME)) {
                HttpServerLogger.ROOT_LOGGER.debug("HTTP Origin or X-Management-Client-Name header is required for all multipart form data posts.");
                Common.UNAUTHORIZED.handleRequest(exchange);
                return;
            }
            data = parser.parseBlocking();
            operationParameterBuilder = new OperationParameter.Builder(false);
            FormData.FormValue op = data.getFirst(OPERATION);
            try {
                Throwable throwable;
                InputStream stream;
                String type = op.getHeaders().getFirst(Headers.CONTENT_TYPE);
                if ("application/dmr-encoded".equals(type)) {
                    stream = this.convertToStream(op);
                    throwable = null;
                    try {
                        operation = ModelNode.fromBase64((InputStream)stream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                stream.close();
                            }
                        }
                    }
                    operationParameterBuilder.encode(true);
                    break block41;
                }
                if ("application/json".equals(DomainApiGenericOperationHandler.stripSuffix(type))) {
                    stream = this.convertToStream(op);
                    throwable = null;
                    try {
                        operation = ModelNode.fromJSONStream((InputStream)stream);
                        break block41;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stream.close();
                            }
                        }
                    }
                }
                HttpServerLogger.ROOT_LOGGER.debug("Content-type must be application/dmr-encoded or application/json");
                Common.UNAUTHORIZED.handleRequest(exchange);
                return;
            }
            catch (Exception e) {
                HttpServerLogger.ROOT_LOGGER.errorf("Unable to construct ModelNode '%s'", e.getMessage());
                Common.sendError(exchange, false, e.getLocalizedMessage());
                return;
            }
        }
        OperationBuilder builder = OperationBuilder.create((ModelNode)operation, (boolean)true);
        for (String name : data) {
            Deque contents = data.get(name);
            if (contents == null || contents.isEmpty()) continue;
            for (FormData.FormValue value : contents) {
                if (!value.isFile()) continue;
                builder.addFileAsAttachment(value.getPath().toFile());
            }
        }
        operationParameterBuilder.pretty(operation.hasDefined("json.pretty") && operation.get("json.pretty").asBoolean());
        final OperationParameter opParam = operationParameterBuilder.build();
        final ResponseCallback callback = new ResponseCallback(){

            @Override
            void doSendResponse(ModelNode response) {
                if (response.hasDefined("outcome") && "failed".equals(response.get("outcome").asString())) {
                    Common.sendError(exchange, opParam.isEncode(), response);
                    return;
                }
                DomainUtil.writeResponse(exchange, 200, response, opParam);
            }
        };
        boolean sendPreparedResponse = this.sendPreparedResponse(operation);
        ModelController.OperationTransactionControl control = sendPreparedResponse ? new ModelController.OperationTransactionControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                transaction.commit();
                result.get("outcome").set("success");
                result.get("result");
                callback.sendResponse(result);
            }
        } : ModelController.OperationTransactionControl.COMMIT;
        Operation builtOp = builder.build();
        try {
            ModelNode opheaders = operation.get("operation-headers");
            opheaders.get("access-mechanism").set(AccessMechanism.HTTP.toString());
            opheaders.get("caller-type").set("user");
            if (opheaders.hasDefined("domain-uuid")) {
                opheaders.remove("domain-uuid");
            }
            response = this.modelController.execute(operation, OperationMessageHandler.DISCARD, control, (OperationAttachments)builtOp);
        }
        catch (Throwable t) {
            HttpServerLogger.ROOT_LOGGER.modelRequestError(t);
            Common.sendError(exchange, opParam.isEncode(), t.getLocalizedMessage());
            return;
        }
        finally {
            if (builtOp.isAutoCloseStreams()) {
                for (InputStream in : builtOp.getInputStreams()) {
                    IoUtils.safeClose((Closeable)in);
                }
            }
        }
        callback.sendResponse(response);
    }

    private InputStream convertToStream(FormData.FormValue op) throws IOException {
        if (op.isFile()) {
            return Files.newInputStream(op.getPath(), new OpenOption[0]);
        }
        return new ByteArrayInputStream(op.getValue().getBytes(StandardCharsets.UTF_8));
    }

    private static String stripSuffix(String contentType) {
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        if (index > 0) {
            contentType = contentType.substring(0, index);
        }
        return contentType;
    }

    private boolean sendPreparedResponse(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String op = operation.get(OPERATION).asString();
        int size = address.size();
        if (size == 0) {
            if (op.equals(RELOAD)) {
                return true;
            }
            if (op.equals("composite")) {
                return false;
            }
            return false;
        }
        if (size == 1 && address.getLastElement().getKey().equals("host")) {
            return op.equals(RELOAD);
        }
        return false;
    }

    private static abstract class ResponseCallback {
        private boolean complete;

        private ResponseCallback() {
        }

        synchronized void sendResponse(ModelNode response) {
            if (this.complete) {
                return;
            }
            this.complete = true;
            this.doSendResponse(response);
        }

        abstract void doSendResponse(ModelNode var1);
    }
}

