/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class ReflectionHelper {
    private static final Log LOG = LoggerFactory.make();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private ReflectionHelper() {
    }

    public static String getAttributeName(XMember member, String name) {
        return StringHelper.isNotEmpty(name) ? name : member.getName();
    }

    public static void setAccessible(XMember member) {
        block2: {
            try {
                member.setAccessible(true);
            }
            catch (SecurityException se) {
                if (Modifier.isPublic(member.getModifiers())) break block2;
                throw se;
            }
        }
    }

    public static void setAccessible(AccessibleObject member) {
        block2: {
            try {
                member.setAccessible(true);
            }
            catch (SecurityException se) {
                if (Modifier.isPublic(((Member)((Object)member)).getModifiers())) break block2;
                throw se;
            }
        }
    }

    public static Object getMemberValue(Object bean, XMember getter) {
        Object value;
        try {
            value = getter.invoke(bean, EMPTY_ARRAY);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
        return value;
    }

    public static List<XClass> createXClassHierarchy(XClass clazz) {
        LinkedList<XClass> hierarchy = new LinkedList<XClass>();
        XClass previousClass = clazz;
        while (previousClass != null) {
            XClass next = previousClass.getSuperclass();
            if (next != null) {
                hierarchy.add(0, previousClass);
            }
            previousClass = next;
        }
        return hierarchy;
    }

    public static boolean containsSearchAnnotations(XClass mappedClass) {
        List<XClass> hierarchy = ReflectionHelper.createXClassHierarchy(mappedClass);
        for (XClass clazz : hierarchy) {
            if (!ReflectionHelper.containsLocalSearchAnnotation(clazz)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsLocalSearchAnnotation(XClass mappedClass) {
        if (ReflectionHelper.containsSearchAnnotation(mappedClass.getAnnotations())) {
            return true;
        }
        for (XProperty method : mappedClass.getDeclaredProperties("property")) {
            if (!ReflectionHelper.containsSearchAnnotation(method.getAnnotations())) continue;
            return true;
        }
        for (XProperty field : mappedClass.getDeclaredProperties("field")) {
            if (!ReflectionHelper.containsSearchAnnotation(field.getAnnotations())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSearchAnnotation(Annotation annotation) {
        return "org.hibernate.search.annotations".equals(annotation.annotationType().getPackage().getName());
    }

    public static Object createInstance(Class<?> clazz, boolean checkForFactoryAnnotation) {
        Object instance;
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw LOG.noPublicNoArgConstructor(clazz.getName());
        }
        catch (IllegalAccessException e) {
            throw LOG.unableToAccessClass(clazz.getName());
        }
        if (!checkForFactoryAnnotation) {
            return instance;
        }
        int numberOfFactoryMethodsFound = 0;
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(Factory.class)) continue;
            if (numberOfFactoryMethodsFound == 1) {
                throw LOG.multipleFactoryMethodsInClass(clazz.getName());
            }
            if (method.getReturnType() == Void.TYPE) {
                throw LOG.factoryMethodsMustReturnAnObject(clazz.getName(), method.getName());
            }
            try {
                instance = method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw LOG.unableToAccessMethod(clazz.getName(), method.getName());
            }
            catch (InvocationTargetException e) {
                throw LOG.exceptionDuringFactoryMethodExecution(e, clazz.getName(), method.getName());
            }
            ++numberOfFactoryMethodsFound;
        }
        return instance;
    }

    public static boolean isFloatingPointType(Class<?> type) {
        return Float.TYPE.equals(type) || Float.class.equals(type) || Double.TYPE.equals(type) || Double.class.equals(type);
    }

    public static boolean isIntegerType(Class<?> type) {
        return Byte.TYPE.equals(type) || Byte.class.equals(type) || Short.TYPE.equals(type) || Short.class.equals(type) || Integer.TYPE.equals(type) || Integer.class.equals(type) || Long.TYPE.equals(type) || Long.class.equals(type);
    }

    private static boolean containsSearchAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!ReflectionHelper.isSearchAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }
}

