/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.extensions.policy;

import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.annotations.Policy;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.jboss.logging.Logger;
import org.jboss.wsf.stack.cxf.Messages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PolicyAttachment {
    private static final Logger log = Logger.getLogger(PolicyAttachment.class);
    private final Policy.Placement placement;
    private final String uri;

    public PolicyAttachment(Policy.Placement placement, String uri) {
        this.placement = placement;
        this.uri = uri;
    }

    public Policy.Placement getPlacement() {
        return this.placement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element read(String defName) {
        Element element;
        XMLStreamReader reader = null;
        InputStream is = null;
        try {
            is = new URL(this.uri).openStream();
            reader = StaxUtils.createXMLStreamReader((InputStream)is);
            Document doc = StaxUtils.read((XMLStreamReader)reader);
            Element elem = doc.getDocumentElement();
            String id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            if (StringUtils.isEmpty((String)id)) {
                Attr att = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id");
                att.setNodeValue(defName);
                elem.setAttributeNodeNS(att);
            }
            element = elem;
        }
        catch (Exception e) {
            try {
                throw Messages.MESSAGES.errorParsingPolicyAttachment(this.uri, e);
            }
            catch (Throwable throwable) {
                try {
                    StaxUtils.close(reader);
                }
                catch (Exception e2) {
                    log.trace((Object)e2);
                }
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception e3) {
                    log.trace((Object)e3);
                }
                throw throwable;
            }
        }
        try {
            StaxUtils.close((XMLStreamReader)reader);
        }
        catch (Exception e) {
            log.trace((Object)e);
        }
        if (is == null) return element;
        try {
            is.close();
            return element;
        }
        catch (Exception e) {
            log.trace((Object)e);
        }
        return element;
    }
}

