/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.marshalling.AbstractMarshaller;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Pair;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.BlockMarshaller;
import org.jboss.marshalling.river.Protocol;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.marshalling.river.RiverObjectOutputStream;
import org.jboss.marshalling.util.IdentityIntMap;
import org.jboss.marshalling.util.Kind;

public class RiverMarshaller
extends AbstractMarshaller {
    private final IdentityIntMap<Object> instanceCache;
    private final IdentityIntMap<Class<?>> classCache;
    private final IdentityHashMap<Class<?>, Externalizer> externalizers;
    private int instanceSeq;
    private int classSeq;
    private final SerializableClassRegistry registry;
    private RiverObjectOutputStream objectOutputStream;
    private ObjectOutput objectOutput;
    private BlockMarshaller blockMarshaller;
    private final PrivilegedExceptionAction<RiverObjectOutputStream> createObjectOutputStreamAction = new PrivilegedExceptionAction<RiverObjectOutputStream>(){

        @Override
        public RiverObjectOutputStream run() throws IOException {
            return new RiverObjectOutputStream(RiverMarshaller.this.getBlockMarshaller(), RiverMarshaller.this);
        }
    };
    private static final IdentityIntMap<Class<?>> BASIC_CLASSES_V2;
    private static final IdentityIntMap<Class<?>> BASIC_CLASSES_V3;
    private static final IdentityIntMap<Class<?>> BASIC_CLASSES_V4;
    private static final Field ENUM_SET_ELEMENT_TYPE_FIELD;
    private static final Field ENUM_SET_VALUES_FIELD;
    private static final Field ENUM_MAP_KEY_TYPE_FIELD;

    protected RiverMarshaller(RiverMarshallerFactory marshallerFactory, SerializableClassRegistry registry, MarshallingConfiguration configuration) throws IOException {
        super((AbstractMarshallerFactory)marshallerFactory, configuration);
        int configuredVersion = this.configuredVersion;
        if (configuredVersion < 2 || configuredVersion > 4) {
            throw new IOException("Unsupported protocol version " + configuredVersion);
        }
        this.registry = registry;
        float loadFactor = 0.3125f;
        this.instanceCache = new IdentityIntMap((int)((double)configuration.getInstanceCount() / 0.3125), 0.3125f);
        this.classCache = new IdentityIntMap((int)((double)configuration.getClassCount() / 0.3125), 0.3125f);
        this.externalizers = new IdentityHashMap(configuration.getClassCount());
    }

    protected void doWriteObject(Object original, boolean unshared) throws IOException {
        ClassExternalizerFactory classExternalizerFactory = this.classExternalizerFactory;
        ObjectResolver objectResolver = this.objectResolver;
        ObjectResolver objectPreResolver = this.objectPreResolver;
        Object obj = original;
        boolean unreplaced = true;
        int configuredVersion = this.configuredVersion;
        try {
            Externalizer externalizer;
            SerializableClass info;
            boolean isArray;
            boolean isEnum;
            int id;
            Class<?> objClass;
            while (true) {
                ObjectTable.Writer objectTableWriter;
                int rid;
                if (obj == null) {
                    this.write(1);
                    return;
                }
                if (!unshared && (rid = this.instanceCache.get(obj, -1)) != -1) {
                    int diff = rid - this.instanceSeq;
                    if (diff >= -256) {
                        this.write(57);
                        this.write(diff);
                    } else if (diff >= -65536) {
                        this.write(58);
                        this.writeShort(diff);
                    } else {
                        this.write(2);
                        this.writeInt(rid);
                    }
                    return;
                }
                obj = objectPreResolver.writeReplace(obj);
                if (!unshared && (objectTableWriter = this.objectTable.getObjectWriter(obj)) != null) {
                    this.write(3);
                    if (configuredVersion == 1) {
                        objectTableWriter.writeObject((Marshaller)this.getBlockMarshaller(), obj);
                        this.writeEndBlock();
                    } else {
                        objectTableWriter.writeObject((Marshaller)this, obj);
                    }
                    return;
                }
                objClass = obj.getClass();
                id = RiverMarshaller.getBasicClasses(configuredVersion).get(objClass, -1);
                if (id == 21) {
                    Class classObj = (Class)obj;
                    int cid = BASIC_CLASSES_V2.get((Object)classObj, -1);
                    switch (cid) {
                        case -1: 
                        case 92: 
                        case 93: 
                        case 97: 
                        case 98: 
                        case 104: 
                        case 105: {
                            this.write(4);
                            this.writeClassClass(classObj);
                            return;
                        }
                    }
                    this.write(cid);
                    return;
                }
                isEnum = obj instanceof Enum;
                isArray = objClass.isArray();
                SerializableClass serializableClass = info = isArray || isEnum || id != -1 ? null : this.registry.lookup(objClass);
                if (!unreplaced) break;
                if (info != null && info.hasWriteReplace()) {
                    obj = info.callWriteReplace(obj);
                }
                if ((obj = objectResolver.writeReplace(obj)) == original) break;
                unreplaced = false;
            }
            if (isEnum) {
                Enum theEnum = (Enum)obj;
                this.write(4);
                this.writeEnumClass(theEnum.getDeclaringClass());
                this.writeString(theEnum.name());
                this.instanceCache.put(obj, this.instanceSeq++);
                return;
            }
            switch (id) {
                case 42: {
                    this.write(73);
                    this.writeByte(((Byte)obj).byteValue());
                    return;
                }
                case 41: {
                    this.write((Boolean)obj != false ? 80 : 81);
                    return;
                }
                case 46: {
                    this.write(77);
                    this.writeChar(((Character)obj).charValue());
                    return;
                }
                case 48: {
                    this.write(79);
                    this.writeDouble((Double)obj);
                    return;
                }
                case 47: {
                    this.write(78);
                    this.writeFloat(((Float)obj).floatValue());
                    return;
                }
                case 44: {
                    this.write(75);
                    this.writeInt((Integer)obj);
                    return;
                }
                case 45: {
                    this.write(76);
                    this.writeLong((Long)obj);
                    return;
                }
                case 43: {
                    this.write(74);
                    this.writeShort(((Short)obj).shortValue());
                    return;
                }
                case 20: {
                    String string = (String)obj;
                    int len = string.length();
                    if (len == 0) {
                        this.write(61);
                        return;
                    }
                    if (len <= 256) {
                        this.write(62);
                        this.write(len);
                    } else if (len <= 65536) {
                        this.write(63);
                        this.writeShort(len);
                    } else {
                        this.write(64);
                        this.writeInt(len);
                    }
                    this.shallowFlush();
                    UTFUtils.writeUTFBytes((ByteOutput)this.byteOutput, (String)string);
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                        ++this.instanceSeq;
                    } else {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    return;
                }
                case 25: {
                    byte[] bytes;
                    int len;
                    if (!unshared) {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    if ((len = (bytes = (byte[])obj).length) == 0) {
                        this.write(unshared ? 69 : 65);
                        this.write(33);
                    } else if (len <= 256) {
                        this.write(unshared ? 70 : 66);
                        this.write(len);
                        this.write(33);
                        this.write(bytes, 0, len);
                    } else if (len <= 65536) {
                        this.write(unshared ? 71 : 67);
                        this.writeShort(len);
                        this.write(33);
                        this.write(bytes, 0, len);
                    } else {
                        this.write(unshared ? 72 : 68);
                        this.writeInt(len);
                        this.write(33);
                        this.write(bytes, 0, len);
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 24: {
                    boolean[] booleans;
                    int len;
                    if (!unshared) {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    if ((len = (booleans = (boolean[])obj).length) == 0) {
                        this.write(unshared ? 69 : 65);
                        this.write(32);
                    } else if (len <= 256) {
                        this.write(unshared ? 70 : 66);
                        this.write(len);
                        this.write(32);
                        this.writeBooleanArray(booleans);
                    } else if (len <= 65536) {
                        this.write(unshared ? 71 : 67);
                        this.writeShort(len);
                        this.write(32);
                        this.writeBooleanArray(booleans);
                    } else {
                        this.write(unshared ? 72 : 68);
                        this.writeInt(len);
                        this.write(32);
                        this.writeBooleanArray(booleans);
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 29: {
                    int i;
                    char[] chars;
                    int len;
                    if (!unshared) {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    if ((len = (chars = (char[])obj).length) == 0) {
                        this.write(unshared ? 69 : 65);
                        this.write(37);
                    } else if (len <= 256) {
                        this.write(unshared ? 70 : 66);
                        this.write(len);
                        this.write(37);
                        for (i = 0; i < len; ++i) {
                            this.writeChar(chars[i]);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 71 : 67);
                        this.writeShort(len);
                        this.write(37);
                        for (i = 0; i < len; ++i) {
                            this.writeChar(chars[i]);
                        }
                    } else {
                        this.write(unshared ? 72 : 68);
                        this.writeInt(len);
                        this.write(37);
                        for (i = 0; i < len; ++i) {
                            this.writeChar(chars[i]);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 26: {
                    int i;
                    short[] shorts;
                    int len;
                    if (!unshared) {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    if ((len = (shorts = (short[])obj).length) == 0) {
                        this.write(unshared ? 69 : 65);
                        this.write(34);
                    } else if (len <= 256) {
                        this.write(unshared ? 70 : 66);
                        this.write(len);
                        this.write(34);
                        for (i = 0; i < len; ++i) {
                            this.writeShort(shorts[i]);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 71 : 67);
                        this.writeShort(len);
                        this.write(34);
                        for (i = 0; i < len; ++i) {
                            this.writeShort(shorts[i]);
                        }
                    } else {
                        this.write(unshared ? 72 : 68);
                        this.writeInt(len);
                        this.write(34);
                        for (i = 0; i < len; ++i) {
                            this.writeShort(shorts[i]);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 27: {
                    int i;
                    int[] ints;
                    int len;
                    if (!unshared) {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    if ((len = (ints = (int[])obj).length) == 0) {
                        this.write(unshared ? 69 : 65);
                        this.write(35);
                    } else if (len <= 256) {
                        this.write(unshared ? 70 : 66);
                        this.write(len);
                        this.write(35);
                        for (i = 0; i < len; ++i) {
                            this.writeInt(ints[i]);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 71 : 67);
                        this.writeShort(len);
                        this.write(35);
                        for (i = 0; i < len; ++i) {
                            this.writeInt(ints[i]);
                        }
                    } else {
                        this.write(unshared ? 72 : 68);
                        this.writeInt(len);
                        this.write(35);
                        for (i = 0; i < len; ++i) {
                            this.writeInt(ints[i]);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 28: {
                    int i;
                    long[] longs;
                    int len;
                    if (!unshared) {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    if ((len = (longs = (long[])obj).length) == 0) {
                        this.write(unshared ? 69 : 65);
                        this.write(36);
                    } else if (len <= 256) {
                        this.write(unshared ? 70 : 66);
                        this.write(len);
                        this.write(36);
                        for (i = 0; i < len; ++i) {
                            this.writeLong(longs[i]);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 71 : 67);
                        this.writeShort(len);
                        this.write(36);
                        for (i = 0; i < len; ++i) {
                            this.writeLong(longs[i]);
                        }
                    } else {
                        this.write(unshared ? 72 : 68);
                        this.writeInt(len);
                        this.write(36);
                        for (i = 0; i < len; ++i) {
                            this.writeLong(longs[i]);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 30: {
                    int i;
                    float[] floats;
                    int len;
                    if (!unshared) {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    if ((len = (floats = (float[])obj).length) == 0) {
                        this.write(unshared ? 69 : 65);
                        this.write(38);
                    } else if (len <= 256) {
                        this.write(unshared ? 70 : 66);
                        this.write(len);
                        this.write(38);
                        for (i = 0; i < len; ++i) {
                            this.writeFloat(floats[i]);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 71 : 67);
                        this.writeShort(len);
                        this.write(38);
                        for (i = 0; i < len; ++i) {
                            this.writeFloat(floats[i]);
                        }
                    } else {
                        this.write(unshared ? 72 : 68);
                        this.writeInt(len);
                        this.write(38);
                        for (i = 0; i < len; ++i) {
                            this.writeFloat(floats[i]);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 31: {
                    int i;
                    double[] doubles;
                    int len;
                    if (!unshared) {
                        this.instanceCache.put(obj, this.instanceSeq++);
                    }
                    if ((len = (doubles = (double[])obj).length) == 0) {
                        this.write(unshared ? 69 : 65);
                        this.write(39);
                    } else if (len <= 256) {
                        this.write(unshared ? 70 : 66);
                        this.write(len);
                        this.write(39);
                        for (i = 0; i < len; ++i) {
                            this.writeDouble(doubles[i]);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 71 : 67);
                        this.writeShort(len);
                        this.write(39);
                        for (i = 0; i < len; ++i) {
                            this.writeDouble(doubles[i]);
                        }
                    } else {
                        this.write(unshared ? 72 : 68);
                        this.writeInt(len);
                        this.write(39);
                        for (i = 0; i < len; ++i) {
                            this.writeDouble(doubles[i]);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 90: 
                case 91: 
                case 117: 
                case 118: 
                case 120: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    Collection collection = (Collection)obj;
                    int len = collection.size();
                    if (len == 0) {
                        this.write(unshared ? 86 : 82);
                        this.write(id);
                    } else if (len <= 256) {
                        this.write(unshared ? 87 : 83);
                        this.write(len);
                        this.write(id);
                        for (Object o : collection) {
                            this.doWriteObject(o, false);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 88 : 84);
                        this.writeShort(len);
                        this.write(id);
                        for (Object o : collection) {
                            this.doWriteObject(o, false);
                        }
                    } else {
                        this.write(unshared ? 89 : 85);
                        this.writeInt(len);
                        this.write(id);
                        for (Object o : collection) {
                            this.doWriteObject(o, false);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 106: {
                    Enum[] elements = RiverMarshaller.getEnumSetElements(obj);
                    int len = elements.length;
                    if (len == 0) {
                        this.write(unshared ? 86 : 82);
                        this.write(id);
                        this.writeClass(RiverMarshaller.getEnumSetElementType(obj));
                        this.instanceCache.put(obj, this.instanceSeq++);
                    } else if (len <= 256) {
                        this.write(unshared ? 87 : 83);
                        this.write(len);
                        this.write(id);
                        this.writeClass(RiverMarshaller.getEnumSetElementType(obj));
                        this.instanceCache.put(obj, this.instanceSeq++);
                        for (Enum o : elements) {
                            this.doWriteObject(o, false);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 88 : 84);
                        this.writeShort(len);
                        this.write(id);
                        this.writeClass(RiverMarshaller.getEnumSetElementType(obj));
                        this.instanceCache.put(obj, this.instanceSeq++);
                        for (Enum o : elements) {
                            this.doWriteObject(o, false);
                        }
                    } else {
                        this.write(unshared ? 89 : 85);
                        this.writeInt(len);
                        this.write(id);
                        this.writeClass(RiverMarshaller.getEnumSetElementType(obj));
                        this.instanceCache.put(obj, this.instanceSeq++);
                        for (Enum o : elements) {
                            this.doWriteObject(o, false);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 99: 
                case 108: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    Map map = (Map)obj;
                    int len = map.size();
                    if (len == 0) {
                        this.write(unshared ? 86 : 82);
                        this.write(id);
                        switch (id) {
                            case 108: {
                                this.writeClass(RiverMarshaller.getEnumMapKeyType(obj));
                            }
                        }
                    } else if (len <= 256) {
                        this.write(unshared ? 87 : 83);
                        this.write(len);
                        this.write(id);
                        switch (id) {
                            case 108: {
                                this.writeClass(RiverMarshaller.getEnumMapKeyType(obj));
                            }
                        }
                        for (Map.Entry entry : map.entrySet()) {
                            this.doWriteObject(entry.getKey(), false);
                            this.doWriteObject(entry.getValue(), false);
                        }
                    } else if (len <= 65536) {
                        this.write(unshared ? 88 : 84);
                        this.writeShort(len);
                        this.write(id);
                        switch (id) {
                            case 108: {
                                this.writeClass(RiverMarshaller.getEnumMapKeyType(obj));
                            }
                        }
                        for (Map.Entry entry : map.entrySet()) {
                            this.doWriteObject(entry.getKey(), false);
                            this.doWriteObject(entry.getValue(), false);
                        }
                    } else {
                        this.write(unshared ? 89 : 85);
                        this.writeInt(len);
                        this.write(id);
                        switch (id) {
                            case 108: {
                                this.writeClass(RiverMarshaller.getEnumMapKeyType(obj));
                            }
                        }
                        for (Map.Entry entry : map.entrySet()) {
                            this.doWriteObject(entry.getKey(), false);
                            this.doWriteObject(entry.getValue(), false);
                        }
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 93: 
                case 98: 
                case 105: 
                case 121: {
                    this.write(id);
                    return;
                }
                case 104: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    Map.Entry entry = ((Map)obj).entrySet().iterator().next();
                    this.doWriteObject(entry.getKey(), false);
                    this.doWriteObject(entry.getValue(), false);
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 92: 
                case 97: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    this.doWriteObject(((Collection)obj).iterator().next(), false);
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 122: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    try {
                        this.doWriteObject(Protocol.reverseOrder2Field.get(obj), false);
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidObjectException("Cannot access standard field for reverse-order comparator");
                    }
                    return;
                }
                case 115: 
                case 116: {
                    info = this.registry.lookup(objClass);
                    break;
                }
                case 119: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    Pair pair = (Pair)obj;
                    this.doWriteObject(pair.getA(), unshared);
                    this.doWriteObject(pair.getB(), unshared);
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 123: {
                    List list = (List)obj;
                    int size = list.size();
                    if (size == 0) {
                        this.write(93);
                        return;
                    }
                    this.instanceCache.put(obj, this.instanceSeq++);
                    if (size <= 256) {
                        this.write(unshared ? 87 : 83);
                        this.write(size);
                    } else if (size <= 65536) {
                        this.write(unshared ? 88 : 84);
                        this.writeShort(size);
                    } else {
                        this.write(unshared ? 89 : 85);
                        this.writeInt(size);
                    }
                    this.write(id);
                    this.doWriteObject(list.iterator().next(), false);
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 124: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    try {
                        this.doWriteObject(Protocol.unmodifiableCollectionField.get(obj), false);
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidObjectException("Cannot access standard field for unmodifiable collections class");
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 127: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    try {
                        this.doWriteObject(Protocol.unmodifiableSetField.get(obj), false);
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidObjectException("Cannot access standard field for unmodifiable collections class");
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 125: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    try {
                        this.doWriteObject((objClass == Protocol.unmodifiableRandomAccessListClass ? Protocol.unmodifiableRandomAccessListField : Protocol.unmodifiableListField).get(obj), false);
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidObjectException("Cannot access standard field for unmodifiable collections class");
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 126: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    try {
                        this.doWriteObject(Protocol.unmodifiableMapField.get(obj), false);
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidObjectException("Cannot access standard field for unmodifiable collections class");
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 129: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    try {
                        this.doWriteObject(Protocol.unmodifiableSortedMapField.get(obj), false);
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidObjectException("Cannot access standard field for unmodifiable collections class");
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 128: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    try {
                        this.doWriteObject(Protocol.unmodifiableSortedSetField.get(obj), false);
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidObjectException("Cannot access standard field for unmodifiable collections class");
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case 130: {
                    this.instanceCache.put(obj, this.instanceSeq++);
                    this.write(id);
                    try {
                        this.doWriteObject(Protocol.unmodifiableMapEntrySetField.get(obj), false);
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidObjectException("Cannot access standard field for unmodifiable collections class");
                    }
                    if (unshared) {
                        this.instanceCache.put(obj, -1);
                    }
                    return;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NotSerializableException(objClass.getName());
                }
            }
            if (isArray) {
                int i;
                Object[] objects = (Object[])obj;
                int len = objects.length;
                if (len == 0) {
                    this.write(unshared ? 69 : 65);
                    this.writeClass(objClass.getComponentType());
                    this.instanceCache.put(obj, this.instanceSeq++);
                } else if (len <= 256) {
                    this.write(unshared ? 70 : 66);
                    this.write(len);
                    this.writeClass(objClass.getComponentType());
                    this.instanceCache.put(obj, this.instanceSeq++);
                    for (i = 0; i < len; ++i) {
                        this.doWriteObject(objects[i], unshared);
                    }
                } else if (len <= 65536) {
                    this.write(unshared ? 71 : 67);
                    this.writeShort(len);
                    this.writeClass(objClass.getComponentType());
                    this.instanceCache.put(obj, this.instanceSeq++);
                    for (i = 0; i < len; ++i) {
                        this.doWriteObject(objects[i], unshared);
                    }
                } else {
                    this.write(unshared ? 72 : 68);
                    this.writeInt(len);
                    this.writeClass(objClass.getComponentType());
                    this.instanceCache.put(obj, this.instanceSeq++);
                    for (i = 0; i < len; ++i) {
                        this.doWriteObject(objects[i], unshared);
                    }
                }
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            if (obj instanceof Proxy) {
                this.write(unshared ? 5 : 4);
                this.writeProxyClass(objClass);
                this.instanceCache.put(obj, this.instanceSeq++);
                this.doWriteObject(Proxy.getInvocationHandler(obj), false);
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            if (this.externalizers.containsKey(objClass)) {
                externalizer = this.externalizers.get(objClass);
            } else {
                externalizer = classExternalizerFactory.getExternalizer(objClass);
                this.externalizers.put(objClass, externalizer);
            }
            if (externalizer != null) {
                this.write(unshared ? 5 : 4);
                this.writeExternalizerClass(objClass, externalizer);
                this.instanceCache.put(obj, this.instanceSeq++);
                ObjectOutput objectOutput = this.getObjectOutput();
                externalizer.writeExternal(obj, objectOutput);
                this.writeEndBlock();
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            if (obj instanceof Externalizable) {
                this.write(unshared ? 5 : 4);
                Externalizable ext = (Externalizable)obj;
                ObjectOutput objectOutput = this.getObjectOutput();
                this.writeExternalizableClass(objClass);
                this.instanceCache.put(obj, this.instanceSeq++);
                ext.writeExternal(objectOutput);
                this.writeEndBlock();
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            if (this.serializabilityChecker.isSerializable(objClass)) {
                this.write(unshared ? 5 : 4);
                this.writeSerializableClass(objClass);
                this.instanceCache.put(obj, this.instanceSeq++);
                this.doWriteSerializableObject(info, obj, objClass);
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            throw new NotSerializableException(objClass.getName());
        }
        finally {
            int replId;
            if (!unreplaced && obj != original && (replId = this.instanceCache.get(obj, -1)) != -1) {
                this.instanceCache.put(original, replId);
            }
        }
    }

    private static IdentityIntMap<Class<?>> getBasicClasses(int configuredVersion) {
        return configuredVersion == 2 ? BASIC_CLASSES_V2 : (configuredVersion == 3 ? BASIC_CLASSES_V3 : BASIC_CLASSES_V4);
    }

    private static Class<? extends Enum> getEnumMapKeyType(Object obj) {
        return RiverMarshaller.getAccessibleEnumFieldValue(ENUM_MAP_KEY_TYPE_FIELD, obj);
    }

    private static Class<? extends Enum> getEnumSetElementType(Object obj) {
        return RiverMarshaller.getAccessibleEnumFieldValue(ENUM_SET_ELEMENT_TYPE_FIELD, obj);
    }

    private static Enum[] getEnumSetElements(Object obj) {
        try {
            return (Enum[])ENUM_SET_VALUES_FIELD.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected state", e);
        }
    }

    private static Class<? extends Enum> getAccessibleEnumFieldValue(Field field, Object obj) {
        try {
            return ((Class)field.get(obj)).asSubclass(Enum.class);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected state", e);
        }
    }

    private void writeBooleanArray(boolean[] booleans) throws IOException {
        int len = booleans.length;
        int bc = len & 0xFFFFFFF8;
        int i = 0;
        while (i < bc) {
            this.write((booleans[i++] ? 1 : 0) | (booleans[i++] ? 2 : 0) | (booleans[i++] ? 4 : 0) | (booleans[i++] ? 8 : 0) | (booleans[i++] ? 16 : 0) | (booleans[i++] ? 32 : 0) | (booleans[i++] ? 64 : 0) | (booleans[i++] ? 128 : 0));
        }
        if (bc < len) {
            int out = 0;
            int bit = 1;
            for (int i2 = bc; i2 < len; ++i2) {
                if (booleans[i2]) {
                    out |= bit;
                }
                bit <<= 1;
            }
            this.write(out);
        }
    }

    private void writeEndBlock() throws IOException {
        BlockMarshaller blockMarshaller = this.blockMarshaller;
        if (blockMarshaller != null) {
            blockMarshaller.flush();
            this.writeByte(53);
        }
    }

    protected ObjectOutput getObjectOutput() {
        ObjectOutput output = this.objectOutput;
        return output == null ? (this.objectOutput = this.getBlockMarshaller()) : output;
    }

    protected BlockMarshaller getBlockMarshaller() {
        BlockMarshaller blockMarshaller = this.blockMarshaller;
        return blockMarshaller == null ? (this.blockMarshaller = new BlockMarshaller(this, this.bufferSize)) : blockMarshaller;
    }

    private RiverObjectOutputStream getObjectOutputStream() throws IOException {
        RiverObjectOutputStream objectOutputStream = this.objectOutputStream;
        return objectOutputStream == null ? (this.objectOutputStream = this.createObjectOutputStream()) : objectOutputStream;
    }

    private RiverObjectOutputStream createObjectOutputStream() throws IOException {
        try {
            return AccessController.doPrivileged(this.createObjectOutputStreamAction);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteSerializableObject(SerializableClass info, Object obj, Class<?> objClass) throws IOException {
        Class<?> superclass = objClass.getSuperclass();
        if (superclass != null && this.serializabilityChecker.isSerializable(superclass)) {
            this.doWriteSerializableObject(this.registry.lookup(superclass), obj, superclass);
        }
        if (info.hasWriteObject()) {
            RiverObjectOutputStream objectOutputStream = this.getObjectOutputStream();
            SerializableClass oldInfo = objectOutputStream.swapClass(info);
            Object oldObj = objectOutputStream.swapCurrent(obj);
            int restoreState = objectOutputStream.start();
            boolean ok = false;
            try {
                info.callWriteObject(obj, (ObjectOutputStream)((Object)objectOutputStream));
                objectOutputStream.finish(restoreState);
                this.writeEndBlock();
                objectOutputStream.swapCurrent(oldObj);
                objectOutputStream.swapClass(oldInfo);
                ok = true;
            }
            finally {
                if (!ok) {
                    objectOutputStream.fullReset();
                }
            }
        } else {
            this.doWriteFields(info, obj);
        }
    }

    protected void doWriteFields(SerializableClass info, Object obj) throws IOException {
        SerializableField[] serializableFields;
        for (SerializableField serializableField : serializableFields = info.getFields()) {
            try {
                try {
                    Field field = serializableField.getField();
                    switch (serializableField.getKind()) {
                        case BOOLEAN: {
                            this.writeBoolean(field == null ? false : field.getBoolean(obj));
                            break;
                        }
                        case BYTE: {
                            this.writeByte(field == null ? 0 : (int)field.getByte(obj));
                            break;
                        }
                        case SHORT: {
                            this.writeShort(field == null ? 0 : (int)field.getShort(obj));
                            break;
                        }
                        case INT: {
                            this.writeInt(field == null ? 0 : field.getInt(obj));
                            break;
                        }
                        case CHAR: {
                            this.writeChar(field == null ? 0 : (int)field.getChar(obj));
                            break;
                        }
                        case LONG: {
                            this.writeLong(field == null ? 0L : field.getLong(obj));
                            break;
                        }
                        case DOUBLE: {
                            this.writeDouble(field == null ? 0.0 : field.getDouble(obj));
                            break;
                        }
                        case FLOAT: {
                            this.writeFloat(field == null ? 0.0f : field.getFloat(obj));
                            break;
                        }
                        case OBJECT: {
                            this.doWriteObject(field == null ? null : field.get(obj), serializableField.isUnshared());
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    InvalidObjectException ioe = new InvalidObjectException("Unexpected illegal access exception");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            catch (IOException e) {
                TraceInformation.addFieldInformation((Throwable)e, (SerializableClass)info, (SerializableField)serializableField);
                TraceInformation.addObjectInformation((Throwable)e, (Object)obj);
                throw e;
            }
            catch (RuntimeException e) {
                TraceInformation.addFieldInformation((Throwable)e, (SerializableClass)info, (SerializableField)serializableField);
                TraceInformation.addObjectInformation((Throwable)e, (Object)obj);
                throw e;
            }
        }
    }

    protected void doWriteEmptyFields(SerializableClass info) throws IOException {
        SerializableField[] serializableFields;
        for (SerializableField serializableField : serializableFields = info.getFields()) {
            try {
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        this.writeBoolean(false);
                        break;
                    }
                    case BYTE: {
                        this.writeByte(0);
                        break;
                    }
                    case SHORT: {
                        this.writeShort(0);
                        break;
                    }
                    case INT: {
                        this.writeInt(0);
                        break;
                    }
                    case CHAR: {
                        this.writeChar(0);
                        break;
                    }
                    case LONG: {
                        this.writeLong(0L);
                        break;
                    }
                    case DOUBLE: {
                        this.writeDouble(0.0);
                        break;
                    }
                    case FLOAT: {
                        this.writeFloat(0.0f);
                        break;
                    }
                    case OBJECT: {
                        this.writeObject(null);
                    }
                }
            }
            catch (IOException e) {
                TraceInformation.addFieldInformation((Throwable)e, (SerializableClass)info, (SerializableField)serializableField);
                throw e;
            }
            catch (RuntimeException e) {
                TraceInformation.addFieldInformation((Throwable)e, (SerializableClass)info, (SerializableField)serializableField);
                throw e;
            }
        }
    }

    protected void writeProxyClass(Class<?> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewProxyClass(objClass);
        }
    }

    protected void writeNewProxyClass(Class<?> objClass) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(15);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            this.write(8);
            String[] names = this.classResolver.getProxyInterfaces(objClass);
            this.writeInt(names.length);
            for (String name : names) {
                this.writeString(name);
            }
            this.classCache.put(objClass, this.classSeq++);
            if (this.configuredVersion == 1) {
                BlockMarshaller blockMarshaller = this.getBlockMarshaller();
                this.classResolver.annotateProxyClass((Marshaller)blockMarshaller, objClass);
                this.writeEndBlock();
            } else {
                this.classResolver.annotateProxyClass((Marshaller)this, objClass);
            }
        }
    }

    protected void writeEnumClass(Class<? extends Enum> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewEnumClass(objClass);
        }
    }

    protected void writeNewEnumClass(Class<? extends Enum> objClass) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(19);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            this.write(12);
            this.writeString(this.classResolver.getClassName(objClass));
            this.classCache.put(objClass, this.classSeq++);
            this.classResolver.annotateClass((Marshaller)this, objClass);
        }
    }

    protected void writeClassClass(Class<?> classObj) throws IOException {
        this.write(21);
        this.writeClass(classObj);
    }

    protected void writeObjectArrayClass(Class<?> objClass) throws IOException {
        this.write(13);
        this.writeClass(objClass.getComponentType());
        this.classCache.put(objClass, this.classSeq++);
    }

    protected void writeClass(Class<?> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewClass(objClass);
        }
    }

    protected void writeNewClass(Class<?> objClass) throws IOException {
        if (objClass.isEnum()) {
            this.writeNewEnumClass(objClass.asSubclass(Enum.class));
        } else if (Proxy.class.isAssignableFrom(objClass)) {
            this.writeNewProxyClass(objClass);
        } else if (objClass.isArray()) {
            this.writeObjectArrayClass(objClass);
        } else if (!objClass.isInterface() && this.serializabilityChecker.isSerializable(objClass)) {
            if (Externalizable.class.isAssignableFrom(objClass)) {
                this.writeNewExternalizableClass(objClass);
            } else {
                this.writeNewSerializableClass(objClass);
            }
        } else {
            ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
            if (classTableWriter != null) {
                this.write(14);
                this.classCache.put(objClass, this.classSeq++);
                this.writeClassTableData(objClass, classTableWriter);
            } else {
                this.write(7);
                this.writeString(this.classResolver.getClassName(objClass));
                this.classResolver.annotateClass((Marshaller)this, objClass);
                this.classCache.put(objClass, this.classSeq++);
            }
        }
    }

    private void writeClassTableData(Class<?> objClass, ClassTable.Writer classTableWriter) throws IOException {
        if (this.configuredVersion == 1) {
            classTableWriter.writeClass((Marshaller)this.getBlockMarshaller(), objClass);
            this.writeEndBlock();
        } else {
            classTableWriter.writeClass((Marshaller)this, objClass);
        }
    }

    protected boolean writeKnownClass(Class<?> objClass) throws IOException {
        int configuredVersion = this.configuredVersion;
        int i = RiverMarshaller.getBasicClasses(configuredVersion).get(objClass, -1);
        if (i != -1) {
            this.write(i);
            return true;
        }
        i = this.classCache.get(objClass, -1);
        if (i != -1) {
            int diff = i - this.classSeq;
            if (diff >= -256) {
                this.write(59);
                this.write(diff);
            } else if (diff >= -65536) {
                this.write(60);
                this.writeShort(diff);
            } else {
                this.write(6);
                this.writeInt(i);
            }
            return true;
        }
        return false;
    }

    protected void writeSerializableClass(Class<?> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewSerializableClass(objClass);
        }
    }

    protected void writeNewSerializableClass(Class<?> objClass) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(16);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            SerializableClass info = this.registry.lookup(objClass);
            if (info.hasWriteObject()) {
                this.write(56);
            } else {
                this.write(9);
            }
            String className = this.classResolver.getClassName(objClass);
            if (this.configuredVersion >= 4) {
                this.writeObject(className);
            } else {
                this.writeString(className);
            }
            this.writeLong(info.getEffectiveSerialVersionUID());
            this.classCache.put(objClass, this.classSeq++);
            this.classResolver.annotateClass((Marshaller)this, objClass);
            SerializableField[] fields = info.getFields();
            int cnt = fields.length;
            this.writeInt(cnt);
            for (int i = 0; i < cnt; ++i) {
                SerializableField field = fields[i];
                if (this.configuredVersion >= 4) {
                    this.writeObject(field.getName());
                } else {
                    this.writeUTF(field.getName());
                }
                try {
                    this.writeClass(field.getKind() == Kind.OBJECT ? Object.class : field.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidClassException("Class of field was unloaded");
                }
                this.writeBoolean(field.isUnshared());
            }
        }
        Class<?> sc = objClass.getSuperclass();
        if (!this.serializabilityChecker.isSerializable(sc)) {
            this.write(22);
            return;
        }
        this.writeClass(sc);
    }

    protected void writeExternalizableClass(Class<?> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewExternalizableClass(objClass);
        }
    }

    protected void writeNewExternalizableClass(Class<?> objClass) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(17);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            this.write(10);
            this.writeString(this.classResolver.getClassName(objClass));
            this.writeLong(this.registry.lookup(objClass).getEffectiveSerialVersionUID());
            this.classCache.put(objClass, this.classSeq++);
            this.classResolver.annotateClass((Marshaller)this, objClass);
        }
    }

    protected void writeExternalizerClass(Class<?> objClass, Externalizer externalizer) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewExternalizerClass(objClass, externalizer);
        }
    }

    protected void writeNewExternalizerClass(Class<?> objClass, Externalizer externalizer) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(18);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            this.write(11);
            this.writeString(this.classResolver.getClassName(objClass));
            this.classCache.put(objClass, this.classSeq++);
            this.classResolver.annotateClass((Marshaller)this, objClass);
        }
        this.writeObject(externalizer);
    }

    public void clearInstanceCache() throws IOException {
        this.instanceCache.clear();
        this.instanceSeq = 0;
        if (this.byteOutput != null) {
            this.write(55);
        }
    }

    public void clearClassCache() throws IOException {
        this.classCache.clear();
        this.externalizers.clear();
        this.classSeq = 0;
        this.instanceCache.clear();
        this.instanceSeq = 0;
        if (this.byteOutput != null) {
            this.write(54);
        }
    }

    public void start(ByteOutput byteOutput) throws IOException {
        super.start(byteOutput);
        this.writeByte(this.configuredVersion);
    }

    private void writeString(String string) throws IOException {
        this.writeInt(string.length());
        this.shallowFlush();
        UTFUtils.writeUTFBytes((ByteOutput)this.byteOutput, (String)string);
    }

    public void writeUTF(String string) throws IOException {
        this.writeInt(string.length());
        this.shallowFlush();
        UTFUtils.writeUTFBytes((ByteOutput)this.byteOutput, (String)string);
    }

    static {
        IdentityIntMap map = new IdentityIntMap(0.375f);
        map.put(Byte.TYPE, 33);
        map.put(Boolean.TYPE, 32);
        map.put(Character.TYPE, 37);
        map.put(Double.TYPE, 39);
        map.put(Float.TYPE, 38);
        map.put(Integer.TYPE, 35);
        map.put(Long.TYPE, 36);
        map.put(Short.TYPE, 34);
        map.put(Void.TYPE, 40);
        map.put(Byte.class, 42);
        map.put(Boolean.class, 41);
        map.put(Character.class, 46);
        map.put(Double.class, 48);
        map.put(Float.class, 47);
        map.put(Integer.class, 44);
        map.put(Long.class, 45);
        map.put(Short.class, 43);
        map.put(Void.class, 49);
        map.put(Object.class, 22);
        map.put(Class.class, 21);
        map.put(String.class, 20);
        map.put(Enum.class, 23);
        map.put(byte[].class, 25);
        map.put(boolean[].class, 24);
        map.put(char[].class, 29);
        map.put(double[].class, 31);
        map.put(float[].class, 30);
        map.put(int[].class, 27);
        map.put(long[].class, 28);
        map.put(short[].class, 26);
        map.put(ArrayList.class, 90);
        map.put(LinkedList.class, 91);
        map.put(IdentityHashMap.class, 99);
        map.put(AbstractCollection.class, 109);
        map.put(AbstractList.class, 111);
        map.put(AbstractQueue.class, 112);
        map.put(AbstractSequentialList.class, 113);
        map.put(AbstractSet.class, 110);
        map.put(CopyOnWriteArrayList.class, 115);
        map.put(CopyOnWriteArraySet.class, 116);
        map.put(Vector.class, 117);
        map.put(Stack.class, 118);
        map.put(Protocol.emptyListClass, 93);
        map.put(Protocol.singletonListClass, 92);
        map.put(Protocol.emptySetClass, 98);
        map.put(Protocol.singletonSetClass, 97);
        map.put(Protocol.emptyMapClass, 105);
        map.put(Protocol.singletonMapClass, 104);
        map.put(EnumMap.class, 108);
        map.put(EnumSet.class, 107);
        map.put(Protocol.enumSetProxyClass, 106);
        BASIC_CLASSES_V2 = map.clone();
        map.put(Pair.class, 119);
        map.put(ArrayDeque.class, 120);
        map.put(Protocol.reverseOrderClass, 121);
        map.put(Protocol.reverseOrder2Class, 122);
        map.put(Protocol.nCopiesClass, 123);
        BASIC_CLASSES_V3 = map.clone();
        map.put(Protocol.unmodifiableCollectionClass, 124);
        map.put(Protocol.unmodifiableSetClass, 127);
        map.put(Protocol.unmodifiableListClass, 125);
        map.put(Protocol.unmodifiableMapClass, 126);
        map.put(Protocol.unmodifiableSortedSetClass, 128);
        map.put(Protocol.unmodifiableSortedMapClass, 129);
        map.put(Protocol.unmodifiableMapEntrySetClass, 130);
        BASIC_CLASSES_V4 = map;
        ENUM_SET_VALUES_FIELD = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = Protocol.enumSetProxyClass.getDeclaredField("elements");
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("Cannot locate the elements field on EnumSet's serialization proxy!");
                }
            }
        });
        ENUM_SET_ELEMENT_TYPE_FIELD = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = Protocol.enumSetProxyClass.getDeclaredField("elementType");
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("Cannot locate the elementType field on EnumSet's serialization proxy!");
                }
            }
        });
        ENUM_MAP_KEY_TYPE_FIELD = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = EnumMap.class.getDeclaredField("keyType");
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("Cannot locate the keyType field on EnumMap!");
                }
            }
        });
    }
}

