/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.math;

public final class HashMath {
    private static final int PRESELECTED_PRIME = 1299827;

    private HashMath() {
    }

    public static int multiHashOrdered(int accumulatedHash, int prime, int nextHash) {
        return HashMath.multiplyWrap(accumulatedHash, prime) + nextHash;
    }

    public static int multiHashUnordered(int accumulatedHash, int prime, int nextHash) {
        return HashMath.multiplyWrap(nextHash, prime) + accumulatedHash;
    }

    public static int multiHashOrdered(int accumulatedHash, int nextHash) {
        return HashMath.multiHashOrdered(accumulatedHash, 1299827, nextHash);
    }

    public static int multiHashUnordered(int accumulatedHash, int nextHash) {
        return HashMath.multiHashUnordered(accumulatedHash, 1299827, nextHash);
    }

    public static int multiplyWrap(int a, int b) {
        long r1 = (long)a * (long)b;
        return (int)r1 ^ (int)(r1 >>> 32);
    }
}

