/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.DERDecoder;
import sun.security.x509.X500Name;

public final class X500PrincipalUtil {
    private static final String[] NO_STRINGS = new String[0];
    private static final boolean HAS_X500_NAME;

    private X500PrincipalUtil() {
    }

    public static String[] getAttributeValues(X500Principal principal, String oid) {
        return X500PrincipalUtil.getAttributeValues(principal, oid, false);
    }

    public static String[] getAttributeValues(X500Principal principal, String oid, boolean reverse) {
        String[] result;
        DERDecoder decoder = new DERDecoder(principal.getEncoded());
        String[] strings = NO_STRINGS;
        int len = 0;
        decoder.startSequence();
        while (decoder.hasNextElement()) {
            decoder.startSet();
            while (decoder.hasNextElement()) {
                decoder.startSequence();
                String testOid = decoder.decodeObjectIdentifier();
                if (oid.equals(testOid)) {
                    switch (decoder.peekType()) {
                        case 22: {
                            if (strings.length == len) {
                                strings = Arrays.copyOf(strings, Math.max(2, strings.length) * 2);
                            }
                            strings[len++] = decoder.decodeIA5String();
                            break;
                        }
                        case 19: {
                            if (strings.length == len) {
                                strings = Arrays.copyOf(strings, Math.max(2, strings.length) * 2);
                            }
                            strings[len++] = decoder.decodePrintableString();
                            break;
                        }
                        default: {
                            decoder.skipElement();
                            break;
                        }
                    }
                } else {
                    decoder.skipElement();
                }
                decoder.endSequence();
            }
            decoder.endSet();
        }
        decoder.endSequence();
        if (decoder.hasNextElement()) {
            throw ElytronMessages.log.unexpectedTrailingGarbageInX500principal();
        }
        String[] stringArray = result = len == 0 ? NO_STRINGS : new String[len];
        if (!reverse) {
            for (int i = 0; i < len; ++i) {
                result[len - i - 1] = strings[i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                result[i] = strings[i];
            }
        }
        return result;
    }

    public static boolean containsAllAttributes(X500Principal principal, String ... oids) {
        Assert.checkNotNullParam("principal", principal);
        Assert.checkNotNullParam("oids", oids);
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList(oids));
        DERDecoder decoder = new DERDecoder(principal.getEncoded());
        decoder.startSequence();
        while (decoder.hasNextElement() && !requiredAttributes.isEmpty()) {
            decoder.startSet();
            while (decoder.hasNextElement() && !requiredAttributes.isEmpty()) {
                decoder.startSequence();
                String testOid = decoder.decodeObjectIdentifier();
                requiredAttributes.remove(testOid);
                decoder.skipElement();
                decoder.endSequence();
            }
            decoder.endSet();
        }
        decoder.endSequence();
        if (decoder.hasNextElement()) {
            throw ElytronMessages.log.unexpectedTrailingGarbageInX500principal();
        }
        return requiredAttributes.isEmpty();
    }

    public static X500Principal asX500Principal(Principal principal) {
        return X500PrincipalUtil.asX500Principal(principal, false);
    }

    public static X500Principal asX500Principal(Principal principal, boolean convert) {
        if (principal instanceof X500Principal) {
            return (X500Principal)principal;
        }
        if (HAS_X500_NAME && principal instanceof X500Name) {
            return ((X500Name)principal).asX500Principal();
        }
        if (convert) {
            try {
                return new X500Principal(principal.getName());
            }
            catch (IllegalArgumentException ignored) {
                ElytronMessages.log.trace("Unable to convert to X500Principal", ignored);
            }
        }
        return null;
    }

    static {
        boolean hasX500Name = false;
        try {
            Class.forName("sun.security.x509.X500Name", true, X500PrincipalUtil.class.getClassLoader());
            hasX500Name = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAS_X500_NAME = hasX500Name;
    }
}

