/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.util.Objects;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.wildfly.common.Assert;

public final class EJBIdentifier
implements Serializable {
    private static final long serialVersionUID = 7065644117552778408L;
    private final EJBModuleIdentifier moduleIdentifier;
    private final String beanName;
    private transient int hashCode;

    public EJBIdentifier(String appName, String moduleName, String beanName, String distinctName) {
        this(new EJBModuleIdentifier(appName, moduleName, distinctName), beanName);
    }

    public EJBIdentifier(EJBModuleIdentifier moduleIdentifier, String beanName) {
        Assert.checkNotNullParam((String)"moduleIdentifier", (Object)moduleIdentifier);
        Assert.checkNotNullParam((String)"beanName", (Object)beanName);
        Assert.checkNotEmptyParam((String)"beanName", (String)beanName);
        this.moduleIdentifier = moduleIdentifier;
        this.beanName = beanName;
    }

    public String getAppName() {
        return this.moduleIdentifier.getAppName();
    }

    public String getModuleName() {
        return this.moduleIdentifier.getModuleName();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getDistinctName() {
        return this.moduleIdentifier.getDistinctName();
    }

    public EJBModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public boolean equals(Object other) {
        return other instanceof EJBIdentifier && this.equals((EJBIdentifier)other);
    }

    public boolean equals(EJBIdentifier other) {
        return other != null && (other == this || other.hashCode() == this.hashCode() && this.moduleIdentifier.equals(other.moduleIdentifier) && Objects.equals(this.beanName, other.beanName));
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode != 0) {
            return hashCode;
        }
        hashCode = this.moduleIdentifier.hashCode() * 13 + this.beanName.hashCode();
        this.hashCode = hashCode == 0 ? 1 : hashCode;
        return this.hashCode;
    }

    public String toString() {
        return this.moduleIdentifier.toString() + "/" + this.beanName;
    }
}

