/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.logging;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.resources.spi.ClassFileInfoException;

public class WeldLogger_$logger
extends DelegatingBasicLogger
implements WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WeldLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String failedToSetupWeldContexts = "WFLYWELD0001: Failed to setup Weld contexts";
    private static final String failedToTearDownWeldContexts = "WFLYWELD0002: Failed to tear down Weld contexts";
    private static final String processingWeldDeployment = "WFLYWELD0003: Processing weld deployment %s";
    private static final String couldNotFindBeanManagerForDeployment = "WFLYWELD0005: Could not find BeanManager for deployment %s";
    private static final String startingServicesForCDIDeployment = "WFLYWELD0006: Starting Services for CDI deployment: %s";
    private static final String couldNotLoadPortableExceptionClass = "WFLYWELD0007: Could not load portable extension class %s";
    private static final String injectionTypeNotValue = "WFLYWELD0008: @Resource injection of type %s is not supported for non-ejb components. Injection point: %s";
    private static final String startingWeldService = "WFLYWELD0009: Starting weld service for deployment %s";
    private static final String stoppingWeldService = "WFLYWELD0010: Stopping weld service for deployment %s";
    private static final String beansXmlValidationWarning = "WFLYWELD0011: Warning while parsing %s:%s %s";
    private static final String beansXmlValidationError = "WFLYWELD0012: Warning while parsing %s:%s %s";
    private static final String cdiAnnotationsButNotBeanArchive = "WFLYWELD0013: Deployment %s contains CDI annotations but no bean archive was found (no beans.xml or class with bean defining annotations was present).";
    private static final String exceptionClearingThreadState = "WFLYWELD0014: Exception tearing down thread state";
    private static final String couldNotReadEntries = "WFLYWELD0016: Could not read entries";
    private static final String doNotUnderstandProtocol = "WFLYWELD0017: URL scanner does not understand the URL protocol %s, CDI beans will not be scanned.";
    private static final String duplicateBeansXml = "WFLYWELD0018: Found both WEB-INF/beans.xml and WEB-INF/classes/META-INF/beans.xml. It is not portable to use both locations at the same time. Weld is going to use the former location for this deployment.";
    private static final String couldNotGetBeansXmlAsURL = "WFLYWELD0019: Could get beans.xml file as URL when processing file: %s";
    private static final String couldNotLoadInterceptorClass = "WFLYWELD0020: Could not load interceptor class : %s";
    private static final String extensionDoesNotImplementExtension = "WFLYWELD0021: Service %s didn't implement the javax.enterprise.inject.spi.Extension interface";
    private static final String viewNotFoundOnEJB = "WFLYWELD0022: View of type %s not found on EJB %s";
    private static final String unknownInterceptorClassForCDIInjection = "WFLYWELD0030: Unknown interceptor class for CDI injection %s";
    private static final String parameterCannotBeNull = "WFLYWELD0031: %s cannot be null";
    private static final String injectionPointNotAJavabean = "WFLYWELD0032: Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) %s";
    private static final String annotationNotFound = "WFLYWELD0033: %s annotation not found on %s";
    private static final String ejbNotResolved = "WFLYWELD0034: Could not resolve @EJB injection for %s on %s";
    private static final String moreThanOneEjbResolved = "WFLYWELD0035: Resolved more than one EJB for @EJB injection of %s on %s. Found %s";
    private static final String couldNotDetermineUnderlyingType = "WFLYWELD0036: Could not determine bean class from injection point type of %s";
    private static final String couldNotFindPersistenceUnit = "WFLYWELD0037: Error injecting persistence unit into CDI managed bean. Can't find a persistence unit named '%s' in deployment %s for injection point %s";
    private static final String securityNotEnabled = "WFLYWELD0038: Could not inject SecurityManager, security is not enabled";
    private static final String singletonNotSet = "WFLYWELD0039: Singleton not set for %s. This means that you are trying to access a weld deployment with a Thread Context ClassLoader that is not associated with the deployment.";
    private static final String alreadyRunning = "WFLYWELD0040: %s is already running";
    private static final String notStarted = "WFLYWELD0041: %s is not started";
    private static final String beanDeploymentNotFound = "WFLYWELD0043: BeanDeploymentArchive with id %s not found in deployment";
    private static final String couldNotFindResource1 = "WFLYWELD0044: Error injecting resource into CDI managed bean. Can't find a resource named %s";
    private static final String cannotDetermineResourceName = "WFLYWELD0045: Cannot determine resource name. Both jndiName and mappedName are null";
    private static final String cannotInject = "WFLYWELD0046: Cannot inject injection point %s";
    private static final String cannotUseAtRuntime = "WFLYWELD0047: %s cannot be used at runtime";
    private static final String rejectAttributesMustBeTrue = "WFLYWELD0048: These attributes must be 'true' for use with CDI 1.0 '%s'";
    private static final String couldNotFindResource2 = "WFLYWELD0049: Error injecting resource into CDI managed bean. Can't find a resource named %s defined on %s";
    private static final String beanArchiveDiscovered = "Discovered %s";
    private static final String nameNotFoundInIndex = "WFLYWELD0050: %s was not found in composite index";
    private static final String unableToLoadAnnotation = "Unable to load annotation %s";
    private static final String cannotLoadClass = "WFLYWELD0051: Cannot load %s";
    private static final String loadingProxiesUsingDeploymentClassLoader = "WFLYWELD0052: Using deployment classloader to load proxy classes for module %s. Package-private access will not work. To fix this the module should declare dependencies on %s";
    private static final String componentInterceptorSupportNotAvailable = "WFLYWELD0053: Component interceptor support not available for: %s";

    public WeldLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void failedToSetupWeldContexts(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.failedToSetupWeldContexts$str(), new Object[0]);
    }

    protected String failedToSetupWeldContexts$str() {
        return failedToSetupWeldContexts;
    }

    @Override
    public final void failedToTearDownWeldContexts(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.failedToTearDownWeldContexts$str(), new Object[0]);
    }

    protected String failedToTearDownWeldContexts$str() {
        return failedToTearDownWeldContexts;
    }

    @Override
    public final void processingWeldDeployment(String deployment) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.processingWeldDeployment$str(), (Object)deployment);
    }

    protected String processingWeldDeployment$str() {
        return processingWeldDeployment;
    }

    @Override
    public final void couldNotFindBeanManagerForDeployment(String beanManager) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.couldNotFindBeanManagerForDeployment$str(), (Object)beanManager);
    }

    protected String couldNotFindBeanManagerForDeployment$str() {
        return couldNotFindBeanManagerForDeployment;
    }

    @Override
    public final void startingServicesForCDIDeployment(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingServicesForCDIDeployment$str(), (Object)deploymentName);
    }

    protected String startingServicesForCDIDeployment$str() {
        return startingServicesForCDIDeployment;
    }

    @Override
    public final void couldNotLoadPortableExceptionClass(String className, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.WARN, throwable, this.couldNotLoadPortableExceptionClass$str(), (Object)className);
    }

    protected String couldNotLoadPortableExceptionClass$str() {
        return couldNotLoadPortableExceptionClass;
    }

    @Override
    public final void injectionTypeNotValue(String type, Member injectionPoint) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.injectionTypeNotValue$str(), (Object)type, (Object)injectionPoint);
    }

    protected String injectionTypeNotValue$str() {
        return injectionTypeNotValue;
    }

    @Override
    public final void startingWeldService(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingWeldService$str(), (Object)deploymentName);
    }

    protected String startingWeldService$str() {
        return startingWeldService;
    }

    @Override
    public final void stoppingWeldService(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingWeldService$str(), (Object)deploymentName);
    }

    protected String stoppingWeldService$str() {
        return stoppingWeldService;
    }

    @Override
    public final void beansXmlValidationWarning(URL file, int line, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.beansXmlValidationWarning$str(), (Object)file, (Object)line, (Object)message);
    }

    protected String beansXmlValidationWarning$str() {
        return beansXmlValidationWarning;
    }

    @Override
    public final void beansXmlValidationError(URL file, int line, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.beansXmlValidationError$str(), (Object)file, (Object)line, (Object)message);
    }

    protected String beansXmlValidationError$str() {
        return beansXmlValidationError;
    }

    @Override
    public final void cdiAnnotationsButNotBeanArchive(String deploymentUnit) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cdiAnnotationsButNotBeanArchive$str(), (Object)deploymentUnit);
    }

    protected String cdiAnnotationsButNotBeanArchive$str() {
        return cdiAnnotationsButNotBeanArchive;
    }

    @Override
    public final void exceptionClearingThreadState(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.exceptionClearingThreadState$str(), new Object[0]);
    }

    protected String exceptionClearingThreadState$str() {
        return exceptionClearingThreadState;
    }

    @Override
    public final void couldNotReadEntries(IOException ioe) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ioe, this.couldNotReadEntries$str(), new Object[0]);
    }

    protected String couldNotReadEntries$str() {
        return couldNotReadEntries;
    }

    @Override
    public final void doNotUnderstandProtocol(URL url) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.doNotUnderstandProtocol$str(), (Object)url);
    }

    protected String doNotUnderstandProtocol$str() {
        return doNotUnderstandProtocol;
    }

    @Override
    public final void duplicateBeansXml() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.duplicateBeansXml$str(), new Object[0]);
    }

    protected String duplicateBeansXml$str() {
        return duplicateBeansXml;
    }

    protected String couldNotGetBeansXmlAsURL$str() {
        return couldNotGetBeansXmlAsURL;
    }

    @Override
    public final DeploymentUnitProcessingException couldNotGetBeansXmlAsURL(String beansXml, Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotGetBeansXmlAsURL$str(), beansXml), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotLoadInterceptorClass$str() {
        return couldNotLoadInterceptorClass;
    }

    @Override
    public final DeploymentUnitProcessingException couldNotLoadInterceptorClass(String interceptorClass, Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotLoadInterceptorClass$str(), interceptorClass), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extensionDoesNotImplementExtension$str() {
        return extensionDoesNotImplementExtension;
    }

    @Override
    public final DeploymentUnitProcessingException extensionDoesNotImplementExtension(Class<?> clazz) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.extensionDoesNotImplementExtension$str(), clazz));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String viewNotFoundOnEJB$str() {
        return viewNotFoundOnEJB;
    }

    @Override
    public final IllegalArgumentException viewNotFoundOnEJB(String viewType, String ejb) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.viewNotFoundOnEJB$str(), viewType, ejb));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownInterceptorClassForCDIInjection$str() {
        return unknownInterceptorClassForCDIInjection;
    }

    @Override
    public final IllegalArgumentException unknownInterceptorClassForCDIInjection(Class<?> interceptorClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownInterceptorClassForCDIInjection$str(), interceptorClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parameterCannotBeNull$str() {
        return parameterCannotBeNull;
    }

    @Override
    public final IllegalArgumentException parameterCannotBeNull(String param) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parameterCannotBeNull$str(), param));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String injectionPointNotAJavabean$str() {
        return injectionPointNotAJavabean;
    }

    @Override
    public final IllegalArgumentException injectionPointNotAJavabean(Method method) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.injectionPointNotAJavabean$str(), method));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String annotationNotFound$str() {
        return annotationNotFound;
    }

    @Override
    public final IllegalArgumentException annotationNotFound(Class<? extends Annotation> type, Member member) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.annotationNotFound$str(), type, member));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ejbNotResolved$str() {
        return ejbNotResolved;
    }

    @Override
    public final IllegalStateException ejbNotResolved(Object ejb, Member member) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ejbNotResolved$str(), ejb, member));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String moreThanOneEjbResolved$str() {
        return moreThanOneEjbResolved;
    }

    @Override
    public final IllegalStateException moreThanOneEjbResolved(Object ejb, Member member, Set<ViewDescription> viewService) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.moreThanOneEjbResolved$str(), ejb, member, viewService));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotDetermineUnderlyingType$str() {
        return couldNotDetermineUnderlyingType;
    }

    @Override
    public final IllegalArgumentException couldNotDetermineUnderlyingType(Type type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotDetermineUnderlyingType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotFindPersistenceUnit$str() {
        return couldNotFindPersistenceUnit;
    }

    @Override
    public final IllegalArgumentException couldNotFindPersistenceUnit(String unitName, String deployment, Member injectionPoint) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotFindPersistenceUnit$str(), unitName, deployment, injectionPoint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String securityNotEnabled$str() {
        return securityNotEnabled;
    }

    @Override
    public final IllegalStateException securityNotEnabled() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.securityNotEnabled$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String singletonNotSet$str() {
        return singletonNotSet;
    }

    @Override
    public final IllegalStateException singletonNotSet(ClassLoader classLoader) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.singletonNotSet$str(), classLoader));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyRunning$str() {
        return alreadyRunning;
    }

    @Override
    public final IllegalStateException alreadyRunning(String object) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.alreadyRunning$str(), object));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notStarted$str() {
        return notStarted;
    }

    @Override
    public final IllegalStateException notStarted(String object) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notStarted$str(), object));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String beanDeploymentNotFound$str() {
        return beanDeploymentNotFound;
    }

    @Override
    public final IllegalArgumentException beanDeploymentNotFound(String beanDeploymentId) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.beanDeploymentNotFound$str(), beanDeploymentId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotFindResource1$str() {
        return couldNotFindResource1;
    }

    @Override
    public final IllegalArgumentException couldNotFindResource(String resourceName, Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotFindResource1$str(), resourceName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDetermineResourceName$str() {
        return cannotDetermineResourceName;
    }

    @Override
    public final IllegalArgumentException cannotDetermineResourceName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotDetermineResourceName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInject$str() {
        return cannotInject;
    }

    @Override
    public final IllegalArgumentException cannotInject(InjectionPoint ip) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotInject$str(), ip));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotUseAtRuntime$str() {
        return cannotUseAtRuntime;
    }

    @Override
    public final IllegalStateException cannotUseAtRuntime(String description) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotUseAtRuntime$str(), description));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rejectAttributesMustBeTrue$str() {
        return rejectAttributesMustBeTrue;
    }

    @Override
    public final String rejectAttributesMustBeTrue(Set<String> keySet) {
        return String.format(this.getLoggingLocale(), this.rejectAttributesMustBeTrue$str(), keySet);
    }

    protected String couldNotFindResource2$str() {
        return couldNotFindResource2;
    }

    @Override
    public final IllegalArgumentException couldNotFindResource(String resourceName, String member, Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotFindResource2$str(), resourceName, member), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void beanArchiveDiscovered(BeanDeploymentArchive bda) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.beanArchiveDiscovered$str(), (Object)bda);
    }

    protected String beanArchiveDiscovered$str() {
        return beanArchiveDiscovered;
    }

    protected String nameNotFoundInIndex$str() {
        return nameNotFoundInIndex;
    }

    @Override
    public final ClassFileInfoException nameNotFoundInIndex(String name) {
        ClassFileInfoException result = new ClassFileInfoException(String.format(this.getLoggingLocale(), this.nameNotFoundInIndex$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unableToLoadAnnotation(String annotationClassName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.unableToLoadAnnotation$str(), (Object)annotationClassName);
    }

    protected String unableToLoadAnnotation$str() {
        return unableToLoadAnnotation;
    }

    protected String cannotLoadClass$str() {
        return cannotLoadClass;
    }

    @Override
    public final ClassFileInfoException cannotLoadClass(String name, Throwable throwable) {
        ClassFileInfoException result = new ClassFileInfoException(String.format(this.getLoggingLocale(), this.cannotLoadClass$str(), name), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void loadingProxiesUsingDeploymentClassLoader(ModuleIdentifier moduleIdentifier, String dependencies) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.loadingProxiesUsingDeploymentClassLoader$str(), (Object)moduleIdentifier, (Object)dependencies);
    }

    protected String loadingProxiesUsingDeploymentClassLoader$str() {
        return loadingProxiesUsingDeploymentClassLoader;
    }

    protected String componentInterceptorSupportNotAvailable$str() {
        return componentInterceptorSupportNotAvailable;
    }

    @Override
    public final IllegalStateException componentInterceptorSupportNotAvailable(Object componentClass) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.componentInterceptorSupportNotAvailable$str(), componentClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

