/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class TransientCacheEntry
extends AbstractInternalCacheEntry {
    protected Object value;
    protected long maxIdle = -1L;
    protected long lastUsed;

    public TransientCacheEntry(Object key, Object value, long maxIdle, long lastUsed) {
        super(key);
        this.value = value;
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object setValue(Object value) {
        this.value = value;
        return this.value;
    }

    @Override
    public final void touch() {
        this.touch(System.currentTimeMillis());
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public final void reincarnate() {
    }

    @Override
    public void reincarnate(long now) {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.maxIdle, this.lastUsed, now);
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        return this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
    }

    @Override
    public final long getMaxIdle() {
        return this.maxIdle;
    }

    public InternalCacheValue toInternalCacheValue() {
        return new TransientCacheValue(this.value, this.maxIdle, this.lastUsed);
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().maxIdle(this.maxIdle, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientCacheEntry that = (TransientCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.lastUsed != that.lastUsed) {
            return false;
        }
        return this.maxIdle == that.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        return result;
    }

    @Override
    public TransientCacheEntry clone() {
        return (TransientCacheEntry)super.clone();
    }

    @Override
    public String toString() {
        return "TransientCacheEntry{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientCacheEntry> {
        public void writeObject(ObjectOutput output, TransientCacheEntry tce) throws IOException {
            output.writeObject(tce.key);
            output.writeObject(tce.value);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)tce.lastUsed);
            output.writeLong(tce.maxIdle);
        }

        public TransientCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            Long maxIdle = input.readLong();
            return new TransientCacheEntry(k, v, maxIdle, lastUsed);
        }

        public Integer getId() {
            return 12;
        }

        public Set<Class<? extends TransientCacheEntry>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{TransientCacheEntry.class});
        }
    }
}

