/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityActions;

public class MapToBeanConverter {
    public static final String BEAN_ID_PREFIX = "##";
    public static final String DOT = ".";
    private final Map<String, String> map;
    private final Map<String, Object> builtObjectsMap;

    public MapToBeanConverter(Map<String, String> map) {
        this.map = map;
        this.builtObjectsMap = new HashMap<String, Object>();
    }

    public Object get(String key) throws Exception {
        if (key == null || !key.startsWith(BEAN_ID_PREFIX)) {
            throw new IllegalArgumentException("Provided key does not start with ##: " + key);
        }
        Object result = this.builtObjectsMap.get(key);
        if (result == null) {
            result = this.build(key);
            this.builtObjectsMap.put(key, result);
        }
        return result;
    }

    protected Object build(String key) throws Exception {
        Object bean = this.newInstance(this.map.get(key));
        Map<String, String> attributes = this.attributesByBeanRef(key);
        if (!attributes.isEmpty()) {
            Iterator<Map.Entry<String, String>> iterator = attributes.entrySet().iterator();
            while (iterator.hasNext()) {
                String v;
                Map.Entry<String, String> e;
                BeanUtils.setProperty((Object)bean, (String)e.getKey(), (Object)((v = (e = iterator.next()).getValue()).startsWith(BEAN_ID_PREFIX) ? this.get(v) : v));
            }
        }
        return bean;
    }

    protected Object newInstance(String className) throws Exception {
        DelegateClassLoader loader = SecurityActions.createDelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), SecurityActions.getContextClassLoader());
        Class<?> clazz = SecurityActions.loadClass((ClassLoader)loader, className);
        return clazz.newInstance();
    }

    protected Map<String, String> attributesByBeanRef(String beanRef) {
        HashMap<String, String> result = null;
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            String k = e.getKey();
            if (!k.startsWith(beanRef) || !k.startsWith(DOT, beanRef.length())) continue;
            if (result == null) {
                result = new HashMap<String, String>();
            }
            result.put(k.substring(beanRef.length() + DOT.length()), e.getValue());
        }
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }
}

