/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawScramDigestPassword;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public interface ScramDigestPassword
extends OneWayPassword {
    public static final String ALGORITHM_SCRAM_SHA_1 = "scram-sha-1";
    public static final String ALGORITHM_SCRAM_SHA_256 = "scram-sha-256";
    public static final String ALGORITHM_SCRAM_SHA_384 = "scram-sha-384";
    public static final String ALGORITHM_SCRAM_SHA_512 = "scram-sha-512";
    public static final int DEFAULT_SALT_SIZE = 12;
    public static final int DEFAULT_ITERATION_COUNT = 20000;

    public byte[] getDigest();

    public byte[] getSalt();

    public int getIterationCount();

    @Override
    default public IteratedSaltedPasswordAlgorithmSpec getParameterSpec() {
        return new IteratedSaltedPasswordAlgorithmSpec(this.getIterationCount(), this.getSalt());
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam((String)"parameterSpec", (Object)parameterSpec);
        if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
            IteratedSaltedPasswordAlgorithmSpec spec = (IteratedSaltedPasswordAlgorithmSpec)parameterSpec;
            return this.getIterationCount() <= spec.getIterationCount() && Arrays.equals(this.getSalt(), spec.getSalt());
        }
        if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
            return Arrays.equals(this.getSalt(), ((SaltedPasswordAlgorithmSpec)parameterSpec).getSalt());
        }
        if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
            return this.getIterationCount() <= ((IteratedPasswordAlgorithmSpec)parameterSpec).getIterationCount();
        }
        return false;
    }

    @Override
    public ScramDigestPassword clone();

    public static ScramDigestPassword createRaw(String algorithm, byte[] digest, byte[] salt, int iterationCount) {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        Assert.checkNotNullParam((String)"digest", (Object)digest);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        return new RawScramDigestPassword(algorithm, (byte[])digest.clone(), (byte[])salt.clone(), iterationCount);
    }
}

