/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.security.remoting.RemoteConnection;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.remoting3.Connection;
import org.wildfly.security.manager.WildFlySecurityManager;

final class SecurityActions {
    private SecurityActions() {
    }

    static void remotingContextSetConnection(Connection connection) {
        SecurityActions.remotingContextAssociationActions().setConnection(connection);
    }

    static void remotingContextSetConnection(RemoteConnection connection) {
        SecurityActions.remoteContextAssociationActions().setConnection(connection);
    }

    static void remotingContextClear() {
        SecurityActions.remotingContextAssociationActions().clear();
    }

    private static RemotingContextAssociationActions remotingContextAssociationActions() {
        return !WildFlySecurityManager.isChecking() ? RemotingContextAssociationActions.NON_PRIVILEGED : RemotingContextAssociationActions.PRIVILEGED;
    }

    private static RemoteContextAssociationActions remoteContextAssociationActions() {
        return !WildFlySecurityManager.isChecking() ? RemoteContextAssociationActions.NON_PRIVILEGED : RemoteContextAssociationActions.PRIVILEGED;
    }

    private static interface RemoteContextAssociationActions {
        public static final RemoteContextAssociationActions NON_PRIVILEGED = new RemoteContextAssociationActions(){

            @Override
            public void setConnection(RemoteConnection connection) {
                RemotingContext.setConnection((RemoteConnection)connection);
            }

            @Override
            public void clear() {
                RemotingContext.clear();
            }
        };
        public static final RemoteContextAssociationActions PRIVILEGED = new RemoteContextAssociationActions(){
            private PrivilegedAction<Void> CLEAR_ACTION = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    NON_PRIVILEGED.clear();
                    return null;
                }
            };

            @Override
            public void setConnection(final RemoteConnection connection) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.setConnection(connection);
                        return null;
                    }
                });
            }

            @Override
            public void clear() {
                AccessController.doPrivileged(this.CLEAR_ACTION);
            }
        };

        public void setConnection(RemoteConnection var1);

        public void clear();
    }

    private static interface RemotingContextAssociationActions {
        public static final RemotingContextAssociationActions NON_PRIVILEGED = new RemotingContextAssociationActions(){

            @Override
            public void setConnection(Connection connection) {
                RemotingContext.setConnection((Connection)connection);
            }

            @Override
            public void clear() {
                RemotingContext.clear();
            }
        };
        public static final RemotingContextAssociationActions PRIVILEGED = new RemotingContextAssociationActions(){
            private PrivilegedAction<Void> CLEAR_ACTION = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    NON_PRIVILEGED.clear();
                    return null;
                }
            };

            @Override
            public void setConnection(final Connection connection) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.setConnection(connection);
                        return null;
                    }
                });
            }

            @Override
            public void clear() {
                AccessController.doPrivileged(this.CLEAR_ACTION);
            }
        };

        public void setConnection(Connection var1);

        public void clear();
    }
}

