/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent.jdk8backported;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.infinispan.commons.util.concurrent.jdk8backported.BoundedEquivalentConcurrentHashMapV8;
import org.infinispan.commons.util.concurrent.jdk8backported.EvictionEntry;
import org.infinispan.commons.util.concurrent.jdk8backported.EvictionPolicy;
import org.infinispan.commons.util.concurrent.jdk8backported.LIRSNode;
import org.infinispan.commons.util.concurrent.jdk8backported.SizeAndEvicting;
import org.infinispan.commons.util.concurrent.jdk8backported.StrippedConcurrentLinkedDeque;

final class LIRSEvictionPolicy<K, V>
implements EvictionPolicy<K, V> {
    private static final float L_LIRS = 0.95f;
    final BoundedEquivalentConcurrentHashMapV8<K, V> map;
    final StrippedConcurrentLinkedDeque<LIRSNode<K, V>> stack = new StrippedConcurrentLinkedDeque();
    final StrippedConcurrentLinkedDeque<LIRSNode<K, V>> queue = new StrippedConcurrentLinkedDeque();
    private volatile long maximumHotSize;
    private volatile long maximumSize;
    private final AtomicLong hotSize = new AtomicLong();
    private final AtomicLong hotDemotion = new AtomicLong();
    private final AtomicReference<SizeAndEvicting> currentSize = new AtomicReference<SizeAndEvicting>(new SizeAndEvicting(0L, 0L));
    final ThreadLocal<Collection<LIRSNode<K, V>>> nodesToEvictTL = new ThreadLocal();

    public LIRSEvictionPolicy(BoundedEquivalentConcurrentHashMapV8<K, V> map, long maxSize) {
        this.map = map;
        this.maximumSize = maxSize;
        this.maximumHotSize = LIRSEvictionPolicy.calculateLIRSize(maxSize);
    }

    private static long calculateLIRSize(long maximumSize) {
        long result = (long)(0.95f * (float)maximumSize);
        return result == maximumSize ? maximumSize - 1L : result;
    }

    @Override
    public BoundedEquivalentConcurrentHashMapV8.Node<K, V> createNewEntry(K key, int hash, BoundedEquivalentConcurrentHashMapV8.Node<K, V> next, V value, EvictionEntry<K, V> evictionEntry) {
        BoundedEquivalentConcurrentHashMapV8.Node<K, V> node = new BoundedEquivalentConcurrentHashMapV8.Node<K, V>(hash, this.map.nodeEq, key, value, next);
        if (evictionEntry == null) {
            node.lazySetEviction(new LIRSNode(key));
        } else {
            node.lazySetEviction(evictionEntry);
        }
        return node;
    }

    @Override
    public BoundedEquivalentConcurrentHashMapV8.TreeNode<K, V> createNewEntry(K key, int hash, BoundedEquivalentConcurrentHashMapV8.TreeNode<K, V> next, BoundedEquivalentConcurrentHashMapV8.TreeNode<K, V> parent, V value, EvictionEntry<K, V> evictionEntry) {
        BoundedEquivalentConcurrentHashMapV8.TreeNode treeNode;
        if (evictionEntry == null) {
            treeNode = new BoundedEquivalentConcurrentHashMapV8.TreeNode(hash, this.map.nodeEq, key, value, next, parent, null);
            treeNode.lazySetEviction(new LIRSNode(key));
        } else {
            treeNode = new BoundedEquivalentConcurrentHashMapV8.TreeNode(hash, this.map.nodeEq, key, value, next, parent, evictionEntry);
        }
        return treeNode;
    }

    boolean addToLIRIfNotFullHot(LIRSNode<K, V> lirsNode, boolean incrementSize) {
        long currentHotSize;
        while ((currentHotSize = this.hotSize.get()) < this.maximumHotSize) {
            if (!this.hotSize.compareAndSet(currentHotSize, currentHotSize + 1L)) continue;
            if (incrementSize) {
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, 1L, 0L);
            }
            StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>> stackNode = new StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>>(lirsNode);
            lirsNode.setStackNode(stackNode);
            lirsNode.setState(Recency.LIR_RESIDENT);
            this.stack.linkLast(stackNode);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryMiss(BoundedEquivalentConcurrentHashMapV8.Node<K, V> e, V value) {
        boolean skipIncrement;
        LIRSNode lirsNode;
        long pruneLIR = 0L;
        boolean evictHIR = false;
        LIRSNode lIRSNode = lirsNode = (LIRSNode)e.eviction;
        synchronized (lIRSNode) {
            skipIncrement = lirsNode.created;
            lirsNode.created = true;
            Recency recency = lirsNode.state;
            if (recency == null) {
                if (skipIncrement) {
                    throw new IllegalStateException("Created should always be false for anewly created evictio node!");
                }
                if (this.addToLIRIfNotFullHot(lirsNode, true)) {
                    return;
                }
                long hotDifference = this.hotSize.get() - this.maximumHotSize;
                if (hotDifference > 0L) {
                    pruneLIR = hotDifference;
                }
                lirsNode.setState(Recency.HIR_RESIDENT);
                StrippedConcurrentLinkedDeque.DequeNode stackNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                lirsNode.setStackNode(stackNode);
                this.stack.linkLast(stackNode);
                StrippedConcurrentLinkedDeque.DequeNode queueNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                lirsNode.setQueueNode(queueNode);
                this.queue.linkLast(queueNode);
            } else if (skipIncrement) {
                switch (recency) {
                    case HIR_NONRESIDENT: {
                        e.val = value;
                        if (this.addToLIRIfNotFullHot(lirsNode, true)) {
                            return;
                        }
                        this.promoteHIRToLIR(lirsNode);
                        pruneLIR = 1L;
                        skipIncrement = false;
                        break;
                    }
                    case EVICTING: {
                        e.val = value;
                        evictHIR = true;
                        lirsNode.setState(Recency.HIR_RESIDENT);
                        StrippedConcurrentLinkedDeque.DequeNode stackNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                        lirsNode.setStackNode(stackNode);
                        this.stack.linkLast(stackNode);
                        StrippedConcurrentLinkedDeque.DequeNode queueNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                        lirsNode.setQueueNode(queueNode);
                        this.queue.linkLast(queueNode);
                        break;
                    }
                    case REMOVED: 
                    case EVICTED: {
                        throw new IllegalStateException("Cannot have a miss on a key and then get a node in " + (Object)((Object)recency));
                    }
                }
            }
        }
        if (pruneLIR > 0L) {
            this.hotDemotion.addAndGet(pruneLIR);
        }
        if (!skipIncrement || evictHIR) {
            BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, 1L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void demoteLowestLIR() {
        boolean pruned = false;
        while (!pruned) {
            LIRSNode removedLIR;
            Object[] LIRDetails = this.pruneIncludingLIR();
            if (LIRDetails == null) {
                return;
            }
            StrippedConcurrentLinkedDeque.DequeNode removedDequeNode = (StrippedConcurrentLinkedDeque.DequeNode)LIRDetails[0];
            LIRSNode lIRSNode = removedLIR = (LIRSNode)LIRDetails[1];
            synchronized (lIRSNode) {
                if (removedDequeNode != removedLIR.stackNode) {
                    continue;
                }
                if (removedLIR.state != Recency.REMOVED) {
                    removedLIR.setState(Recency.HIR_RESIDENT);
                    removedLIR.setStackNode(null);
                    StrippedConcurrentLinkedDeque.DequeNode queueNode = new StrippedConcurrentLinkedDeque.DequeNode(removedLIR);
                    removedLIR.setQueueNode(queueNode);
                    this.queue.linkLast(queueNode);
                    pruned = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] pruneIncludingLIR() {
        LIRSNode removedLIR = null;
        Object[] nodeDetails = new Object[2];
        block8: while (true) {
            if (!this.stack.pollFirstNode(nodeDetails)) {
                long hot;
                do {
                    if ((hot = this.hotSize.get()) >= 0L) continue block8;
                } while (!this.hotSize.compareAndSet(hot, hot + 1L));
                return null;
            }
            StrippedConcurrentLinkedDeque.DequeNode removedStackNode = (StrippedConcurrentLinkedDeque.DequeNode)nodeDetails[0];
            LIRSNode lIRSNode = removedLIR = (LIRSNode)nodeDetails[1];
            synchronized (lIRSNode) {
                if (removedStackNode != removedLIR.stackNode) {
                    continue;
                }
                switch (removedLIR.state) {
                    case LIR_RESIDENT: {
                        return nodeDetails;
                    }
                    case HIR_NONRESIDENT: {
                        removedLIR.setState(Recency.EVICTING);
                        Collection<LIRSNode<K, V>> nodesToEvict = this.nodesToEvictTL.get();
                        if (nodesToEvict == null) {
                            nodesToEvict = new ArrayList<LIRSNode<K, V>>();
                            this.nodesToEvictTL.set(nodesToEvict);
                        }
                        nodesToEvict.add(removedLIR);
                    }
                    case HIR_RESIDENT: {
                        removedLIR.setStackNode(null);
                        break;
                    }
                }
            }
        }
    }

    void promoteHIRToLIR(LIRSNode<K, V> lirsNode) {
        StrippedConcurrentLinkedDeque.DequeNode queueNode;
        StrippedConcurrentLinkedDeque.DequeNode stackNode = lirsNode.stackNode;
        if (stackNode != null) {
            LIRSNode item = (LIRSNode)stackNode.item;
            if (item != null && stackNode.casItem(item, null)) {
                this.stack.unlink(stackNode);
            }
            lirsNode.setStackNode(null);
        }
        if ((queueNode = lirsNode.queueNode) != null) {
            LIRSNode item = (LIRSNode)queueNode.item;
            if (item != null && queueNode.casItem(item, null)) {
                this.queue.unlink(queueNode);
            }
            lirsNode.setQueueNode(null);
        }
        lirsNode.setState(Recency.LIR_RESIDENT);
        stackNode = new StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>>(lirsNode);
        lirsNode.setStackNode(stackNode);
        this.stack.linkLast(stackNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryHitRead(BoundedEquivalentConcurrentHashMapV8.Node<K, V> e, V value) {
        LIRSNode lirsNode;
        boolean reAttempt = false;
        LIRSNode lIRSNode = lirsNode = (LIRSNode)e.eviction;
        synchronized (lIRSNode) {
            Recency recency = lirsNode.state;
            if (recency == Recency.HIR_NONRESIDENT || recency == Recency.EVICTING) {
                reAttempt = true;
            } else {
                this.onEntryHitWrite(e, value);
            }
        }
        if (reAttempt) {
            int i;
            BoundedEquivalentConcurrentHashMapV8.Node f;
            int n;
            int hash = BoundedEquivalentConcurrentHashMapV8.spread(this.map.keyEq.hashCode(lirsNode.getKey()));
            BoundedEquivalentConcurrentHashMapV8.Node<K, V>[] tab = this.map.table;
            while (tab != null && (n = tab.length) != 0 && (f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i = n - 1 & hash)) != null) {
                if (f.hash == -1) {
                    tab = this.map.helpTransfer(tab, f);
                    continue;
                }
                BoundedEquivalentConcurrentHashMapV8.Node node = f;
                synchronized (node) {
                    if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                        LIRSNode lIRSNode2 = lirsNode;
                        synchronized (lIRSNode2) {
                            this.onEntryHitWrite(e, value);
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryHitWrite(BoundedEquivalentConcurrentHashMapV8.Node<K, V> e, V value) {
        LIRSNode lirsNode;
        boolean demoteLIR = false;
        boolean evictHIR = false;
        LIRSNode lIRSNode = lirsNode = (LIRSNode)e.eviction;
        synchronized (lIRSNode) {
            Recency recency = lirsNode.state;
            if (recency == null) {
                if (this.addToLIRIfNotFullHot(lirsNode, false)) {
                    return;
                }
                recency = Recency.LIR_RESIDENT;
                lirsNode.setState(recency);
                demoteLIR = true;
            }
            switch (recency) {
                case LIR_RESIDENT: {
                    LIRSNode item;
                    StrippedConcurrentLinkedDeque.DequeNode stackNode = lirsNode.stackNode;
                    if (stackNode != null && (item = (LIRSNode)stackNode.item) != null && stackNode.casItem(item, null)) {
                        this.stack.unlink(stackNode);
                    }
                    StrippedConcurrentLinkedDeque.DequeNode newStackNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                    lirsNode.setStackNode(newStackNode);
                    this.stack.linkLast(newStackNode);
                    break;
                }
                case HIR_NONRESIDENT: {
                    if (e.val == BoundedEquivalentConcurrentHashMapV8.NULL_VALUE) {
                        e.val = value;
                        this.map.addCount(1L, -1);
                    }
                    if (this.addToLIRIfNotFullHot(lirsNode, true)) {
                        return;
                    }
                    this.promoteHIRToLIR(lirsNode);
                    evictHIR = true;
                    demoteLIR = true;
                    break;
                }
                case EVICTED: {
                    break;
                }
                case EVICTING: {
                    evictHIR = true;
                    lirsNode.setState(Recency.HIR_RESIDENT);
                    if (e.val == BoundedEquivalentConcurrentHashMapV8.NULL_VALUE) {
                        e.val = value;
                        this.map.addCount(1L, -1);
                    }
                }
                case HIR_RESIDENT: {
                    LIRSNode item;
                    if (lirsNode.stackNode != null) {
                        this.promoteHIRToLIR(lirsNode);
                        demoteLIR = true;
                        break;
                    }
                    if (lirsNode.queueNode != null && (item = (LIRSNode)lirsNode.queueNode.item) != null && lirsNode.queueNode.casItem(item, null)) {
                        this.queue.unlink(lirsNode.queueNode);
                    }
                    StrippedConcurrentLinkedDeque.DequeNode newStackNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                    lirsNode.setStackNode(newStackNode);
                    this.stack.linkLast(newStackNode);
                    StrippedConcurrentLinkedDeque.DequeNode newQueueNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                    lirsNode.setQueueNode(newQueueNode);
                    this.queue.linkLast(newQueueNode);
                    break;
                }
            }
        }
        if (demoteLIR) {
            this.hotDemotion.incrementAndGet();
        }
        if (evictHIR) {
            BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, 1L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryRemove(BoundedEquivalentConcurrentHashMapV8.Node<K, V> e) {
        LIRSNode lirsNode;
        LIRSNode lIRSNode = lirsNode = (LIRSNode)e.eviction;
        synchronized (lIRSNode) {
            switch (lirsNode.state) {
                case LIR_RESIDENT: {
                    this.hotSize.decrementAndGet();
                }
                case HIR_RESIDENT: {
                    BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, -1L, 0L);
                }
                case HIR_NONRESIDENT: 
                case EVICTING: {
                    lirsNode.setState(Recency.REMOVED);
                    break;
                }
            }
            StrippedConcurrentLinkedDeque.DequeNode queueNode = lirsNode.queueNode;
            if (queueNode != null) {
                LIRSNode item = (LIRSNode)queueNode.item;
                if (item != null && queueNode.casItem(item, null)) {
                    this.queue.unlink(queueNode);
                }
                lirsNode.setQueueNode(null);
            }
            lirsNode.setQueueNode(null);
            StrippedConcurrentLinkedDeque.DequeNode stackNode = lirsNode.stackNode;
            if (stackNode != null) {
                LIRSNode item = (LIRSNode)stackNode.item;
                if (item != null && stackNode.casItem(item, null)) {
                    this.stack.unlink(stackNode);
                }
                lirsNode.setStackNode(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BoundedEquivalentConcurrentHashMapV8.Node<K, V>> findIfEntriesNeedEvicting() {
        int evictCount;
        block36: {
            block35: {
                long longEvictCount;
                long evict;
                long size;
                SizeAndEvicting sizeEvict;
                long hotDemotions;
                while ((hotDemotions = this.hotDemotion.get()) > 0L && !this.hotDemotion.compareAndSet(hotDemotions, 0L)) {
                }
                for (long i = 0L; i < hotDemotions; ++i) {
                    this.demoteLowestLIR();
                }
                do {
                    sizeEvict = this.currentSize.get();
                    size = sizeEvict.size;
                    evict = sizeEvict.evicting;
                    longEvictCount = size - evict - this.maximumSize;
                    if (longEvictCount <= 0L) break block35;
                } while (!this.currentSize.compareAndSet(sizeEvict, new SizeAndEvicting(size, evict + (long)(evictCount = (int)longEvictCount & Integer.MAX_VALUE))));
                break block36;
            }
            evictCount = 0;
        }
        Collection<LIRSNode<K, V>> tlEvicted = this.nodesToEvictTL.get();
        if (tlEvicted == null) {
            tlEvicted = Collections.emptyList();
        } else {
            this.nodesToEvictTL.remove();
        }
        if (evictCount != 0 || !tlEvicted.isEmpty()) {
            LIRSNode[] queueContents = new LIRSNode[evictCount + tlEvicted.size()];
            Iterator<LIRSNode<K, V>> tlIterator = tlEvicted.iterator();
            int offset = 0;
            while (tlIterator.hasNext()) {
                queueContents[evictCount + offset] = tlIterator.next();
                ++offset;
            }
            int evictedValues = evictCount;
            int decEvict = evictCount;
            Object[] hirDetails = new Object[2];
            block17: for (int i = 0; i < evictCount; ++i) {
                boolean foundNode = false;
                while (!foundNode) {
                    LIRSNode removedHIR;
                    if (!this.queue.pollFirstNode(hirDetails)) {
                        SizeAndEvicting newSizeEvict;
                        SizeAndEvicting sizeEvict = this.currentSize.get();
                        if (sizeEvict.size - sizeEvict.evicting < this.maximumSize && this.currentSize.compareAndSet(sizeEvict, newSizeEvict = new SizeAndEvicting(sizeEvict.size, sizeEvict.evicting - 1L))) {
                            --evictedValues;
                            --decEvict;
                            continue block17;
                        }
                        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                        continue;
                    }
                    StrippedConcurrentLinkedDeque.DequeNode removedDequeNode = (StrippedConcurrentLinkedDeque.DequeNode)hirDetails[0];
                    LIRSNode lIRSNode = removedHIR = (LIRSNode)hirDetails[1];
                    synchronized (lIRSNode) {
                        if (removedHIR.queueNode != removedDequeNode) {
                            continue;
                        }
                        removedHIR.setQueueNode(null);
                        switch (removedHIR.state) {
                            case HIR_RESIDENT: {
                                if (removedHIR.stackNode != null) {
                                    removedHIR.setState(Recency.HIR_NONRESIDENT);
                                    queueContents[i] = removedHIR;
                                } else {
                                    removedHIR.setState(Recency.EVICTING);
                                    queueContents[i] = removedHIR;
                                }
                                foundNode = true;
                                break;
                            }
                            case REMOVED: {
                                --evictedValues;
                                foundNode = true;
                                break;
                            }
                        }
                    }
                }
            }
            BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, -evictedValues, -decEvict);
            ArrayList<BoundedEquivalentConcurrentHashMapV8.Node<K, V>> removedNodes = new ArrayList<BoundedEquivalentConcurrentHashMapV8.Node<K, V>>(queueContents.length);
            for (int j = 0; j < queueContents.length; ++j) {
                int i;
                BoundedEquivalentConcurrentHashMapV8.Node f;
                int n;
                LIRSNode evict = queueContents[j];
                if (evict == null || evict.state != Recency.EVICTING && evict.state != Recency.HIR_NONRESIDENT) continue;
                int hash = BoundedEquivalentConcurrentHashMapV8.spread(this.map.keyEq.hashCode(evict.getKey()));
                BoundedEquivalentConcurrentHashMapV8.Node<K, V>[] tab = this.map.table;
                while (tab != null && (n = tab.length) != 0 && (f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i = n - 1 & hash)) != null) {
                    if (f.hash == -1) {
                        tab = this.map.helpTransfer(tab, f);
                        continue;
                    }
                    BoundedEquivalentConcurrentHashMapV8.Node node = f;
                    synchronized (node) {
                        if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                            LIRSNode lIRSNode = evict;
                            synchronized (lIRSNode) {
                                if (evict.state == Recency.EVICTING) {
                                    evict.setState(Recency.EVICTED);
                                    Object prevValue = this.map.replaceNode(evict.getKey(), null, null, true);
                                    removedNodes.add(new BoundedEquivalentConcurrentHashMapV8.Node(-1, null, evict.getKey(), prevValue, null));
                                } else if (evict.state == Recency.HIR_NONRESIDENT) {
                                    BoundedEquivalentConcurrentHashMapV8.Node node2 = f.find(hash, evict.getKey());
                                    Object prevValue = node2.val;
                                    if (prevValue != BoundedEquivalentConcurrentHashMapV8.NULL_VALUE) {
                                        node2.val = BoundedEquivalentConcurrentHashMapV8.NULL_VALUE;
                                        this.map.addCount(-1L, -1);
                                        BoundedEquivalentConcurrentHashMapV8.Node nonResidentNode = new BoundedEquivalentConcurrentHashMapV8.Node(-1, null, evict.getKey(), prevValue, null);
                                        removedNodes.add(nonResidentNode);
                                        this.map.notifyListenerOfRemoval(nonResidentNode, true);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return removedNodes;
        }
        return Collections.emptySet();
    }

    @Override
    public void onResize(long oldSize, long newSize) {
    }

    @Override
    public void resize(long newSize) {
        this.maximumSize = newSize;
        this.maximumHotSize = LIRSEvictionPolicy.calculateLIRSize(this.maximumSize);
    }

    static enum Recency {
        HIR_RESIDENT,
        LIR_RESIDENT,
        HIR_NONRESIDENT,
        EVICTING,
        EVICTED,
        REMOVED;

    }
}

