/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent.jdk8backported;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commons.util.concurrent.jdk8backported.BoundedEquivalentConcurrentHashMapV8;
import org.infinispan.commons.util.concurrent.jdk8backported.EntrySizeCalculator;
import org.infinispan.commons.util.concurrent.jdk8backported.EvictionEntry;
import org.infinispan.commons.util.concurrent.jdk8backported.EvictionPolicy;
import org.infinispan.commons.util.concurrent.jdk8backported.LRUNode;
import org.infinispan.commons.util.concurrent.jdk8backported.SizeAndEvicting;
import org.infinispan.commons.util.concurrent.jdk8backported.StrippedConcurrentLinkedDeque;
import org.infinispan.commons.util.concurrent.jdk8backported.Unsafe;

class LRUEvictionPolicy<K, V>
implements EvictionPolicy<K, V> {
    final BoundedEquivalentConcurrentHashMapV8<K, V> map;
    final StrippedConcurrentLinkedDeque<BoundedEquivalentConcurrentHashMapV8.Node<K, V>> deque = new StrippedConcurrentLinkedDeque();
    volatile long maxSize;
    final AtomicReference<SizeAndEvicting> currentSize = new AtomicReference<SizeAndEvicting>(new SizeAndEvicting(0L, 0L));
    final EntrySizeCalculator<? super K, ? super V> sizeCalculator;
    final boolean countingMemory;
    static final long NODE_ARRAY_BASE_OFFSET = Unsafe.getUnsafe().arrayBaseOffset(BoundedEquivalentConcurrentHashMapV8.Node[].class);
    static final long NODE_ARRAY_OFFSET = Unsafe.getUnsafe().arrayIndexScale(BoundedEquivalentConcurrentHashMapV8.Node[].class);

    public LRUEvictionPolicy(BoundedEquivalentConcurrentHashMapV8<K, V> map, long maxSize, EntrySizeCalculator<? super K, ? super V> sizeCalculator, boolean countingMemory) {
        this.map = map;
        this.maxSize = maxSize;
        this.sizeCalculator = sizeCalculator;
        this.countingMemory = countingMemory;
        if (countingMemory) {
            sun.misc.Unsafe unsafe = Unsafe.getUnsafe();
            long evictionPolicySize = sun.misc.Unsafe.ADDRESS_SIZE + sun.misc.Unsafe.ARRAY_OBJECT_INDEX_SCALE;
            evictionPolicySize += (long)(sun.misc.Unsafe.ARRAY_OBJECT_INDEX_SCALE * 4);
            evictionPolicySize += 9L;
            long mapSize = sun.misc.Unsafe.ADDRESS_SIZE + sun.misc.Unsafe.ARRAY_OBJECT_INDEX_SCALE;
            mapSize += NODE_ARRAY_BASE_OFFSET * 2L;
            mapSize += 28L;
            mapSize += (long)unsafe.arrayBaseOffset(BoundedEquivalentConcurrentHashMapV8.CounterCell[].class);
            BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, BoundedEquivalentConcurrentHashMapV8.roundUpToNearest8(evictionPolicySize) + BoundedEquivalentConcurrentHashMapV8.roundUpToNearest8(mapSize += (long)(sun.misc.Unsafe.ADDRESS_SIZE * 8)), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryHitRead(BoundedEquivalentConcurrentHashMapV8.Node<K, V> e, V value) {
        LRUNode eviction;
        LRUNode lRUNode = eviction = (LRUNode)e.eviction;
        synchronized (lRUNode) {
            BoundedEquivalentConcurrentHashMapV8.Node oldItem;
            if (eviction.queueNode != null && !eviction.removed && (oldItem = (BoundedEquivalentConcurrentHashMapV8.Node)eviction.queueNode.item) != null && eviction.queueNode.casItem(oldItem, null)) {
                this.deque.unlink(eviction.queueNode);
                StrippedConcurrentLinkedDeque.DequeNode<BoundedEquivalentConcurrentHashMapV8.Node<K, V>> queueNode = new StrippedConcurrentLinkedDeque.DequeNode<BoundedEquivalentConcurrentHashMapV8.Node<K, V>>(e);
                eviction.queueNode = queueNode;
                this.deque.linkLast(queueNode);
            }
        }
    }

    @Override
    public void onEntryHitWrite(BoundedEquivalentConcurrentHashMapV8.Node<K, V> e, V value) {
        this.onEntryHitRead(e, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryMiss(BoundedEquivalentConcurrentHashMapV8.Node<K, V> e, V value) {
        LRUNode eviction;
        LRUNode lRUNode = eviction = (LRUNode)e.eviction;
        synchronized (lRUNode) {
            if (!eviction.removed) {
                StrippedConcurrentLinkedDeque.DequeNode<BoundedEquivalentConcurrentHashMapV8.Node<K, V>> queueNode = new StrippedConcurrentLinkedDeque.DequeNode<BoundedEquivalentConcurrentHashMapV8.Node<K, V>>(e);
                eviction.queueNode = queueNode;
                this.deque.linkLast(queueNode);
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, this.sizeCalculator.calculateSize(e.key, value), 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryRemove(BoundedEquivalentConcurrentHashMapV8.Node<K, V> e) {
        LRUNode eviction;
        LRUNode lRUNode = eviction = (LRUNode)e.eviction;
        synchronized (lRUNode) {
            if (eviction.queueNode != null) {
                BoundedEquivalentConcurrentHashMapV8.Node item = (BoundedEquivalentConcurrentHashMapV8.Node)eviction.queueNode.item;
                if (item != null && eviction.queueNode.casItem(item, null)) {
                    this.deque.unlink(eviction.queueNode);
                }
                eviction.queueNode = null;
            }
            if (!eviction.removed) {
                eviction.removed = true;
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, -this.sizeCalculator.calculateSize(e.key, e.val), 0L);
            }
        }
    }

    @Override
    public BoundedEquivalentConcurrentHashMapV8.Node<K, V> createNewEntry(K key, int hash, BoundedEquivalentConcurrentHashMapV8.Node<K, V> next, V value, EvictionEntry<K, V> evictionEntry) {
        BoundedEquivalentConcurrentHashMapV8.Node<K, V> node = new BoundedEquivalentConcurrentHashMapV8.Node<K, V>(hash, this.map.nodeEq, key, value, next);
        if (evictionEntry == null) {
            node.lazySetEviction(new LRUNode(node));
        } else {
            node.lazySetEviction(evictionEntry);
        }
        return node;
    }

    @Override
    public BoundedEquivalentConcurrentHashMapV8.TreeNode<K, V> createNewEntry(K key, int hash, BoundedEquivalentConcurrentHashMapV8.TreeNode<K, V> next, BoundedEquivalentConcurrentHashMapV8.TreeNode<K, V> parent, V value, EvictionEntry<K, V> evictionEntry) {
        BoundedEquivalentConcurrentHashMapV8.TreeNode treeNode;
        if (evictionEntry == null) {
            treeNode = new BoundedEquivalentConcurrentHashMapV8.TreeNode(hash, this.map.nodeEq, key, value, next, parent, null);
            treeNode.lazySetEviction(new LRUNode(treeNode));
        } else {
            treeNode = new BoundedEquivalentConcurrentHashMapV8.TreeNode(hash, this.map.nodeEq, key, value, next, parent, evictionEntry);
        }
        return treeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BoundedEquivalentConcurrentHashMapV8.Node<K, V>> findIfEntriesNeedEvicting() {
        SizeAndEvicting newSize;
        long evicting;
        SizeAndEvicting existingSize;
        long size;
        long extra;
        do {
            existingSize = this.currentSize.get();
        } while ((extra = (size = existingSize.size) - (evicting = existingSize.evicting) - this.maxSize) > 0L && !this.currentSize.compareAndSet(existingSize, newSize = new SizeAndEvicting(size, evicting + extra)));
        List<BoundedEquivalentConcurrentHashMapV8.Node<K, V>> evictedEntries = null;
        if (extra > 0L) {
            evictedEntries = new ArrayList<BoundedEquivalentConcurrentHashMapV8.Node<K, V>>((int)extra & Integer.MAX_VALUE);
            long decCreate = 0L;
            while (decCreate < extra) {
                BoundedEquivalentConcurrentHashMapV8.Node<K, V> node = this.deque.pollFirst();
                boolean removed = false;
                if (node != null) {
                    LRUNode lruNode;
                    LRUNode lRUNode = lruNode = (LRUNode)node.eviction;
                    synchronized (lRUNode) {
                        if (!lruNode.removed) {
                            lruNode.removed = true;
                            removed = true;
                        }
                    }
                }
                if (!removed) break;
                Object value = this.map.replaceNode(node.key, null, null, true);
                if (value == null) continue;
                evictedEntries.add(node);
                decCreate += this.sizeCalculator.calculateSize(node.key, value);
            }
            BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, -decCreate, -extra);
        } else {
            evictedEntries = Collections.emptyList();
        }
        return evictedEntries;
    }

    @Override
    public void onResize(long oldSize, long newSize) {
        if (this.countingMemory && newSize > oldSize) {
            BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, (newSize - oldSize) * NODE_ARRAY_OFFSET, 0L);
        }
    }

    @Override
    public void resize(long newSize) {
        this.maxSize = newSize;
    }
}

