/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

public final class GreaterEqualFilterSpec
extends FilterSpec {
    private final String attribute;
    private final AttributeValue value;

    GreaterEqualFilterSpec(String attribute, AttributeValue value) {
        this.attribute = attribute;
        this.value = value;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        AttributeValue other = attributes.get(this.attribute);
        return this.value.compareTo(other) >= 0;
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        Collection<AttributeValue> collection = attributes.get(attributes);
        if (collection != null) {
            for (AttributeValue value : collection) {
                if (this.value.compareTo(value) < 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mayMatch(Collection<String> attributeNames) {
        return attributeNames.contains(this.attribute);
    }

    @Override
    public boolean mayNotMatch(Collection<String> attributeNames) {
        return true;
    }

    @Override
    public <P, R, E extends Exception> R accept(FilterSpec.Visitor<P, R, E> visitor, P parameter) throws E {
        return visitor.handle(this, parameter);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(');
        FilterSpec.escapeTo(this.attribute, builder);
        builder.append('>');
        builder.append('=');
        builder.append(this.value);
        builder.append(')');
    }
}

