/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.function.Consumer;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class InfinispanSessionManagerFactoryBuilder<C extends Marshallability>
implements CapabilityServiceBuilder<SessionManagerFactory<TransactionBatch>>,
InfinispanSessionManagerFactoryConfiguration<C> {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final SessionManagerFactoryConfiguration<C> configuration;
    private final String containerName;
    private final CapabilityServiceBuilder<?> configurationBuilder;
    private final CapabilityServiceBuilder<?> cacheBuilder;
    private volatile ValueDependency<NodeFactory> nodeFactory;
    private volatile ValueDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile ValueDependency<CommandDispatcherFactory> dispatcherFactory;

    public InfinispanSessionManagerFactoryBuilder(SessionManagerFactoryConfiguration<C> configuration) {
        this.configuration = configuration;
        ServiceName baseServiceName = ServiceName.JBOSS.append(new String[]{"infinispan"});
        String configCacheName = this.configuration.getCacheName();
        ServiceName configServiceName = ServiceName.parse((String)(configCacheName != null ? configCacheName : DEFAULT_CACHE_CONTAINER));
        if (!baseServiceName.isParentOf(configServiceName)) {
            configServiceName = baseServiceName.append(configServiceName);
        }
        this.containerName = (configServiceName.length() > 3 ? configServiceName.getParent() : configServiceName).getSimpleName();
        String templateCacheName = configServiceName.length() > 3 ? configServiceName.getSimpleName() : null;
        String cacheName = this.configuration.getDeploymentName();
        Consumer<ConfigurationBuilder> configurator = builder -> {
            EvictionConfiguration eviction;
            ExpirationConfiguration expiration = builder.expiration().create();
            if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                builder.expiration().lifespan(-1L).maxIdle(-1L);
                InfinispanWebLogger.ROOT_LOGGER.expirationDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(this.containerName, templateCacheName));
            }
            if ((eviction = builder.eviction().create()).strategy().isEnabled()) {
                builder.eviction().size(-1L).strategy(EvictionStrategy.MANUAL);
                InfinispanWebLogger.ROOT_LOGGER.evictionDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(this.containerName, templateCacheName));
            }
        };
        this.configurationBuilder = new TemplateConfigurationBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(this.containerName, cacheName)), this.containerName, cacheName, templateCacheName, configurator);
        this.cacheBuilder = new CacheBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(this.containerName, cacheName)), this.containerName, cacheName);
    }

    public ServiceName getServiceName() {
        return ServiceName.JBOSS.append(new String[]{"clustering", DEFAULT_CACHE_CONTAINER, this.configuration.getDeploymentName()});
    }

    public Builder<SessionManagerFactory<TransactionBatch>> configure(CapabilityServiceSupport support) {
        this.configurationBuilder.configure(support);
        this.cacheBuilder.configure(support);
        this.affinityFactory = new InjectedValueDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, this.containerName), KeyAffinityServiceFactory.class);
        this.dispatcherFactory = new InjectedValueDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, this.containerName), CommandDispatcherFactory.class);
        this.nodeFactory = new InjectedValueDependency(ClusteringCacheRequirement.NODE_FACTORY.getServiceName(support, this.containerName, this.configuration.getServerName()), NodeFactory.class);
        return this;
    }

    public ServiceBuilder<SessionManagerFactory<TransactionBatch>> build(ServiceTarget target) {
        this.configurationBuilder.build(target).install();
        this.cacheBuilder.build(target).install();
        Value value = () -> new InfinispanSessionManagerFactory(this);
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService(value)).addDependency(this.cacheBuilder.getServiceName(), Cache.class, this.cache).setInitialMode(ServiceController.Mode.ON_DEMAND);
        Stream.of(this.nodeFactory, this.affinityFactory, this.dispatcherFactory).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public SessionManagerFactoryConfiguration<C> getSessionManagerFactoryConfiguration() {
        return this.configuration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.getValue();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.getValue();
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.nodeFactory.getValue();
    }
}

