/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.CoordinateHelper;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public class DistanceCollector
implements Collector {
    private final Point center;
    private final SpatialResultsCollector distances;
    private final String latitudeField;
    private final String longitudeField;

    public DistanceCollector(Coordinates centerCoordinates, int hitsCount, String fieldname) {
        this.center = Point.fromCoordinates(centerCoordinates);
        this.distances = new SpatialResultsCollector(hitsCount);
        this.latitudeField = SpatialHelper.formatLatitude(fieldname);
        this.longitudeField = SpatialHelper.formatLongitude(fieldname);
    }

    public double getDistance(int index) {
        return this.distances.get(index, this.center);
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new DistanceLeafCollector(context);
    }

    public boolean needsScores() {
        return false;
    }

    private class DistanceLeafCollector
    implements LeafCollector {
        private final int docBase;
        private final NumericDocValues latitudeValues;
        private final NumericDocValues longitudeValues;

        DistanceLeafCollector(LeafReaderContext context) throws IOException {
            LeafReader atomicReader = context.reader();
            this.latitudeValues = atomicReader.getNumericDocValues(DistanceCollector.this.latitudeField);
            this.longitudeValues = atomicReader.getNumericDocValues(DistanceCollector.this.longitudeField);
            this.docBase = context.docBase;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            int absolute = this.docBase + doc;
            double lat = CoordinateHelper.coordinate(this.latitudeValues, doc);
            double lon = CoordinateHelper.coordinate(this.longitudeValues, doc);
            DistanceCollector.this.distances.put(absolute, lat, lon);
        }
    }

    private static class SpatialResultsCollector {
        final ArrayList<HitEntry> orderedEntries;
        int currentIterator = 0;

        private SpatialResultsCollector(int size) {
            this.orderedEntries = new ArrayList(size);
        }

        public double get(int index, Point center) {
            HitEntry currentEntry;
            int startingPoint = this.currentIterator;
            while (this.currentIterator < this.orderedEntries.size() && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == index) {
                    return currentEntry.getDistance(center);
                }
                ++this.currentIterator;
            }
            this.currentIterator = 0;
            while (this.currentIterator < startingPoint && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == index) {
                    return currentEntry.getDistance(center);
                }
                ++this.currentIterator;
            }
            throw new SearchException("Unexpected index: this documentId was not collected");
        }

        void put(int documentId, double latitude, double longitude) {
            this.orderedEntries.add(new HitEntry(documentId, latitude, longitude));
        }
    }

    private static class HitEntry {
        int documentId;
        double latitude;
        double longitude;

        private HitEntry(int documentId, double latitude, double longitude) {
            this.documentId = documentId;
            this.latitude = latitude;
            this.longitude = longitude;
        }

        double getDistance(Point center) {
            return center.getDistanceTo(this.latitude, this.longitude);
        }
    }
}

