/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.msc;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;

public class ServiceContainerHelper {
    private static final Map<ServiceController.State, Map<ServiceController.Mode, ServiceController.Mode>> modeToggle = new EnumMap<ServiceController.State, Map<ServiceController.Mode, ServiceController.Mode>>(ServiceController.State.class);

    public static <T> T findValue(ServiceRegistry registry, ServiceName name) {
        ServiceController<T> service = ServiceContainerHelper.findService(registry, name);
        return (T)(service != null && service.getState() == ServiceController.State.UP ? service.getValue() : null);
    }

    public static <T> ServiceController<T> findService(ServiceRegistry registry, ServiceName name) {
        return registry.getService(name);
    }

    public static <T> ServiceController<T> getService(ServiceRegistry registry, ServiceName name) {
        return registry.getRequiredService(name);
    }

    public static <T> T getValue(ServiceController<T> controller) throws StartException {
        ServiceContainerHelper.start(controller);
        return (T)controller.getValue();
    }

    public static <T> void start(ServiceController<T> controller) throws StartException {
        ServiceContainerHelper.transition(controller, ServiceController.State.UP);
        StartException exception = controller.getStartException();
        if (exception != null) {
            throw exception;
        }
    }

    public static <T> void stop(ServiceController<T> controller) {
        ServiceContainerHelper.transition(controller, ServiceController.State.DOWN);
    }

    public static <T> void remove(ServiceController<T> controller) {
        ServiceContainerHelper.transition(controller, ServiceController.State.REMOVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void transition(ServiceController<T> targetController, ServiceController.State targetState) {
        if (targetController.getState() == targetState) {
            return;
        }
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(targetController);
        try {
            ServiceController.Mode targetMode = modeToggle.get(targetState).get(targetController.getMode());
            if (targetMode != null) {
                targetController.setMode(targetMode);
            }
            monitor.awaitStability();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            monitor.removeController(targetController);
        }
    }

    private ServiceContainerHelper() {
    }

    static {
        EnumMap<ServiceController.Mode, ServiceController.Mode> map = new EnumMap<ServiceController.Mode, ServiceController.Mode>(ServiceController.Mode.class);
        map.put(ServiceController.Mode.NEVER, ServiceController.Mode.ACTIVE);
        map.put(ServiceController.Mode.ON_DEMAND, ServiceController.Mode.PASSIVE);
        modeToggle.put(ServiceController.State.UP, map);
        map = new EnumMap(ServiceController.Mode.class);
        map.put(ServiceController.Mode.ACTIVE, ServiceController.Mode.NEVER);
        map.put(ServiceController.Mode.PASSIVE, ServiceController.Mode.ON_DEMAND);
        modeToggle.put(ServiceController.State.DOWN, map);
        map = new EnumMap(ServiceController.Mode.class);
        for (ServiceController.Mode mode : EnumSet.complementOf(EnumSet.of(ServiceController.Mode.REMOVE))) {
            map.put(mode, ServiceController.Mode.REMOVE);
        }
        modeToggle.put(ServiceController.State.REMOVED, map);
    }
}

