/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.UndertowOptions;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.undertow.AbstractHandlerDefinition;
import org.wildfly.extension.undertow.PredicateValidator;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FailoverStrategy;
import org.wildfly.extension.undertow.filters.FilterService;
import org.wildfly.extension.undertow.filters.ModClusterBalancerDefinition;
import org.wildfly.extension.undertow.filters.ModClusterResource;
import org.wildfly.extension.undertow.filters.ModClusterService;
import org.xnio.Option;

public class ModClusterDefinition
extends AbstractHandlerDefinition {
    static final RuntimeCapability<Void> MOD_CLUSTER_FILTER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.mod_cluster-filter", (boolean)true, FilterService.class).build();
    public static final AttributeDefinition MANAGEMENT_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-socket-binding", ModelType.STRING).setAllowExpression(true)).setRequired(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference("org.wildfly.network.socket-binding")).setRestartAllServices()).build();
    public static final AttributeDefinition ADVERTISE_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-socket-binding", ModelType.STRING).setAllowExpression(true)).setRequired(false)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference("org.wildfly.network.socket-binding")).setRestartAllServices()).build();
    public static final AttributeDefinition SECURITY_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-key", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setRestartAllServices()).build();
    public static final AttributeDefinition ADVERTISE_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-protocol", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setDefaultValue(new ModelNode("http"))).setRestartAllServices()).build();
    public static final AttributeDefinition ADVERTISE_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-path", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setDefaultValue(new ModelNode("/"))).setRestartAllServices()).build();
    public static final AttributeDefinition ADVERTISE_FREQUENCY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-frequency", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setDefaultValue(new ModelNode(10000))).setRestartAllServices()).build();
    public static final AttributeDefinition FAILOVER_STRATEGY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("failover-strategy", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)new EnumValidator(FailoverStrategy.class, true, true))).setRestartAllServices()).setDefaultValue(new ModelNode(FailoverStrategy.LOAD_BALANCED.name()))).build();
    public static final AttributeDefinition HEALTH_CHECK_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("health-check-interval", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setDefaultValue(new ModelNode(10000))).setRestartAllServices()).build();
    public static final AttributeDefinition BROKEN_NODE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("broken-node-timeout", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setDefaultValue(new ModelNode(60000))).setRestartAllServices()).build();
    public static final AttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setDefaultValue(new ModelNode("default"))).setCapabilityReference("org.wildfly.io.worker")).setRestartAllServices()).build();
    public static final AttributeDefinition MAX_REQUEST_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-request-time", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setDefaultValue(new ModelNode(-1))).setRestartAllServices()).build();
    public static final AttributeDefinition MANAGEMENT_ACCESS_PREDICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-access-predicate", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)PredicateValidator.INSTANCE)).build();
    public static final AttributeDefinition CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connections-per-thread", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(40))).setRestartAllServices()).build();
    public static final AttributeDefinition CACHED_CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cached-connections-per-thread", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(40))).setRestartAllServices()).build();
    public static final AttributeDefinition CONNECTION_IDLE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-idle-timeout", ModelType.INT).setRequired(false)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.SECONDS)).setDefaultValue(new ModelNode(60))).setRestartAllServices()).build();
    public static final AttributeDefinition REQUEST_QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-queue-size", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(1000))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setAlternatives(new String[]{"security-realm"})).setCapabilityReference("org.wildfly.security.ssl-context")).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF})).build();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING).setAlternatives(new String[]{"ssl-context"})).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF})).setDeprecated(ModelVersion.create((int)4, (int)0, (int)0))).build();
    public static final SimpleAttributeDefinition USE_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-alias", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ENABLE_HTTP2 = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-http2", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MAX_AJP_PACKET_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-ajp-packet-size", ModelType.INT).setRequired(false)).setRestartAllServices()).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowExpression(true)).setDefaultValue(new ModelNode(8192))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_ENABLE_PUSH = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-enable-push", (Option)UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    public static final OptionAttributeDefinition HTTP2_HEADER_TABLE_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-header-table-size", (Option)UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(4096))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_INITIAL_WINDOW_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-initial-window-size", (Option)UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(65535))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_MAX_CONCURRENT_STREAMS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-concurrent-streams", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_MAX_FRAME_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-frame-size", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(16384))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_MAX_HEADER_LIST_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-header-list-size", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_HEADER_LIST_SIZE).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final AttributeDefinition MAX_RETRIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-retries", ModelType.INT).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(new ModelNode(1L))).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(MANAGEMENT_SOCKET_BINDING, ADVERTISE_SOCKET_BINDING, SECURITY_KEY, ADVERTISE_PROTOCOL, ADVERTISE_PATH, ADVERTISE_FREQUENCY, FAILOVER_STRATEGY, HEALTH_CHECK_INTERVAL, BROKEN_NODE_TIMEOUT, WORKER, MAX_REQUEST_TIME, MANAGEMENT_ACCESS_PREDICATE, CONNECTIONS_PER_THREAD, CACHED_CONNECTIONS_PER_THREAD, CONNECTION_IDLE_TIMEOUT, REQUEST_QUEUE_SIZE, SECURITY_REALM, SSL_CONTEXT, USE_ALIAS, ENABLE_HTTP2, MAX_AJP_PACKET_SIZE, HTTP2_MAX_HEADER_LIST_SIZE, HTTP2_MAX_FRAME_SIZE, HTTP2_MAX_CONCURRENT_STREAMS, HTTP2_INITIAL_WINDOW_SIZE, HTTP2_HEADER_TABLE_SIZE, HTTP2_ENABLE_PUSH, MAX_RETRIES));
    public static final ModClusterDefinition INSTANCE = new ModClusterDefinition();

    private ModClusterDefinition() {
        super(new PersistentResourceDefinition.Parameters(PathElement.pathElement((String)"mod-cluster"), (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "mod-cluster")).setAddHandler((OperationStepHandler)new ModClusterAdd()).setRemoveHandler((OperationStepHandler)new ServiceRemoveStepHandler(UndertowService.FILTER, (AbstractAddStepHandler)new ModClusterAdd())).setCapabilities(new RuntimeCapability[]{MOD_CLUSTER_FILTER_CAPABILITY}));
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public Class<? extends HttpHandler> getHandlerClass() {
        return ProxyHandler.class;
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, ModelNode model, HttpHandler next) {
        throw new IllegalStateException();
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)ModClusterBalancerDefinition.INSTANCE);
    }

    static class ModClusterAdd
    extends AbstractAddStepHandler {
        ModClusterAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            ModClusterService.install(name, context.getCapabilityServiceTarget(), model, context);
        }

        protected Resource createResource(OperationContext context, ModelNode operation) {
            if (context.isDefaultRequiresRuntime()) {
                Resource delegate = Resource.Factory.create();
                ModClusterResource result = new ModClusterResource(delegate, context.getCurrentAddressValue());
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)result);
                return result;
            }
            return super.createResource(context, operation);
        }
    }
}

