/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.core.management.client;

import java.util.Map;
import org.wildfly.extension.core.management.client.Process;

public interface ProcessStateListenerInitParameters {
    public Map<String, String> getInitProperties();

    public Process.RunningMode getRunningMode();

    public Process.Type getProcessType();

    public static class Builder {
        private Map<String, String> initProperties;
        private Process.Type processType;
        private Process.RunningMode runningMode;

        public Builder setInitProperties(Map<String, String> initProperties) {
            this.initProperties = initProperties;
            return this;
        }

        public Builder setProcessType(Process.Type processType) {
            this.processType = processType;
            return this;
        }

        public Builder setRunningMode(Process.RunningMode runningMode) {
            this.runningMode = runningMode;
            return this;
        }

        public ProcessStateListenerInitParameters build() {
            return new ProcessStateListenerInitParametersImpl(this);
        }
    }

    public static class ProcessStateListenerInitParametersImpl
    implements ProcessStateListenerInitParameters {
        private final Map<String, String> initProperties;
        private final Process.Type processType;
        private final Process.RunningMode runningMode;

        private ProcessStateListenerInitParametersImpl(Builder builder) {
            this.initProperties = builder.initProperties;
            this.processType = builder.processType;
            this.runningMode = builder.runningMode;
        }

        @Override
        public Map<String, String> getInitProperties() {
            return this.initProperties;
        }

        @Override
        public Process.Type getProcessType() {
            return this.processType;
        }

        @Override
        public Process.RunningMode getRunningMode() {
            return this.runningMode;
        }
    }
}

