/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class ServerPathManagerService
extends PathManagerService {
    public static ServiceController<?> addService(ServiceTarget serviceTarget, ServerPathManagerService service, ServerEnvironment serverEnvironment) {
        ServiceBuilder serviceBuilder = serviceTarget.addService(AbstractControllerService.PATH_MANAGER_CAPABILITY.getCapabilityServiceName(), (Service)service).addAliases(new ServiceName[]{SERVICE_NAME});
        ServerPathManagerService.addAbsolutePath(service, serviceTarget, "jboss.home.dir", serverEnvironment.getHomeDir());
        ServerPathManagerService.addAbsolutePath(service, serviceTarget, "jboss.server.base.dir", serverEnvironment.getServerBaseDir());
        ServerPathManagerService.addAbsolutePath(service, serviceTarget, "jboss.server.config.dir", serverEnvironment.getServerConfigurationDir());
        ServerPathManagerService.addAbsolutePath(service, serviceTarget, "jboss.server.data.dir", serverEnvironment.getServerDataDir());
        ServerPathManagerService.addAbsolutePath(service, serviceTarget, "jboss.server.log.dir", serverEnvironment.getServerLogDir());
        ServerPathManagerService.addAbsolutePath(service, serviceTarget, "jboss.server.temp.dir", serverEnvironment.getServerTempDir());
        ServerPathManagerService.addAbsolutePath(service, serviceTarget, "jboss.controller.temp.dir", serverEnvironment.getControllerTempDir());
        service.addHardcodedAbsolutePath(serviceTarget, "user.dir", System.getProperty("user.dir"));
        service.addHardcodedAbsolutePath(serviceTarget, "user.home", System.getProperty("user.home"));
        service.addHardcodedAbsolutePath(serviceTarget, "java.home", System.getProperty("java.home"));
        if (serverEnvironment.getLaunchType() == ServerEnvironment.LaunchType.DOMAIN) {
            if (serverEnvironment.getDomainBaseDir() != null) {
                service.addHardcodedAbsolutePath(serviceTarget, "jboss.domain.base.dir", serverEnvironment.getDomainBaseDir().getAbsolutePath());
            }
            if (serverEnvironment.getDomainConfigurationDir() != null) {
                service.addHardcodedAbsolutePath(serviceTarget, "jboss.domain.config.dir", serverEnvironment.getDomainConfigurationDir().getAbsolutePath());
            }
        }
        return serviceBuilder.install();
    }

    public static void registerDomainServerPathCapabilities(CapabilityRegistry capabilityRegistry) {
        ServerPathManagerService.registerServerPathCapability(capabilityRegistry, "jboss.server.base.dir");
        ServerPathManagerService.registerServerPathCapability(capabilityRegistry, "jboss.server.config.dir");
        ServerPathManagerService.registerServerPathCapability(capabilityRegistry, "jboss.server.data.dir");
        ServerPathManagerService.registerServerPathCapability(capabilityRegistry, "jboss.server.log.dir");
        ServerPathManagerService.registerServerPathCapability(capabilityRegistry, "jboss.server.temp.dir");
    }

    private static void registerServerPathCapability(CapabilityRegistry capabilityRegistry, String path) {
        capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability(path), CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
    }

    public ServerPathManagerService(CapabilityRegistry capabilityRegistry) {
        super((RuntimeCapabilityRegistry)capabilityRegistry);
    }

    private static void addAbsolutePath(ServerPathManagerService service, ServiceTarget serviceTarget, String name, File path) {
        if (path == null) {
            return;
        }
        service.addHardcodedAbsolutePath(serviceTarget, name, path.getAbsolutePath());
    }
}

