/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.mail.extension.Attribute;
import org.jboss.as.mail.extension.Element;
import org.jboss.as.mail.extension.MailExtension;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class MailSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    MailSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{MailExtension.SUBSYSTEM_PATH});
        list.add(Util.createAddOperation((PathAddress)address));
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: 
                case MAIL_1_1: 
                case MAIL_1_2: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MAIL_SESSION: {
                            this.parseMailSession(reader, list, address);
                            continue block6;
                        }
                    }
                    reader.handleAny(list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMailSession(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parent) throws XMLStreamException {
        String jndiName = null;
        ModelNode operation = new ModelNode();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            if (attr == Attribute.JNDI_NAME) {
                jndiName = value;
                MailSessionDefinition.JNDI_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attr == Attribute.DEBUG) {
                MailSessionDefinition.DEBUG.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attr != Attribute.FROM) continue;
            MailSessionDefinition.FROM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
        }
        if (jndiName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.JNDI_NAME));
        }
        PathAddress address = parent.append("mail-session", jndiName);
        operation.get("address").set(address.toModelNode());
        operation.get("operation").set("add");
        list.add(operation);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: 
                case MAIL_1_1: 
                case MAIL_1_2: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SMTP_SERVER: {
                            this.parseServerConfig(reader, "smtp", address, list);
                            continue block10;
                        }
                        case POP3_SERVER: {
                            this.parseServerConfig(reader, "pop3", address, list);
                            continue block10;
                        }
                        case IMAP_SERVER: {
                            this.parseServerConfig(reader, "imap", address, list);
                            continue block10;
                        }
                        case CUSTOM_SERVER: {
                            this.parseCustomServerConfig(reader, address, list);
                            continue block10;
                        }
                    }
                    reader.handleAny(list);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerConfig(XMLExtendedStreamReader reader, String name, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = parent.append("server", name);
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        list.add(operation);
        String socketBindingRef = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            if (attr == Attribute.OUTBOUND_SOCKET_BINDING_REF) {
                socketBindingRef = value;
                MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attr == Attribute.SSL) {
                MailServerDefinition.SSL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attr == Attribute.TLS) {
                MailServerDefinition.TLS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        if (socketBindingRef == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.OUTBOUND_SOCKET_BINDING_REF));
        }
        this.parseLogin(reader, operation);
    }

    private void parseCustomServerConfig(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation((PathAddress)parent);
        list.add(operation);
        String name = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            if (attr == Attribute.OUTBOUND_SOCKET_BINDING_REF) {
                MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF_OPTIONAL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attr == Attribute.SSL) {
                MailServerDefinition.SSL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attr == Attribute.TLS) {
                MailServerDefinition.TLS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                continue;
            }
            if (attr == Attribute.NAME) {
                name = value;
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN: {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String att = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (att.equals(Attribute.USERNAME.getLocalName())) {
                            MailServerDefinition.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            continue;
                        }
                        if (!att.equals(Attribute.PASSWORD.getLocalName())) continue;
                        MailServerDefinition.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block5;
                }
                case PROPERTY: {
                    String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{org.jboss.as.controller.parsing.Attribute.NAME.getLocalName(), org.jboss.as.controller.parsing.Attribute.VALUE.getLocalName()});
                    MailServerDefinition.PROPERTIES.parseAndAddParameterElement(array[0], array[1], operation, reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        PathAddress address = parent.append("custom", name);
        operation.get("address").set(address.toModelNode());
    }

    private void parseLogin(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN: {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String att = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (att.equals(Attribute.USERNAME.getLocalName())) {
                            MailServerDefinition.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            continue;
                        }
                        if (!att.equals(Attribute.PASSWORD.getLocalName())) continue;
                        MailServerDefinition.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                }
            }
        }
    }
}

