/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb.client.EJBLocator;
import org.wildfly.common.Assert;

public interface DiscoveredURISelector {
    public static final DiscoveredURISelector FIRST = (eligibleUris, locator) -> (URI)eligibleUris.iterator().next();
    public static final DiscoveredURISelector RANDOM = (eligibleUris, locator) -> (URI)eligibleUris.get(ThreadLocalRandom.current().nextInt(eligibleUris.size()));
    public static final DiscoveredURISelector ROUND_ROBIN = new DiscoveredURISelector(){
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public URI selectNode(List<URI> eligibleUris, EJBLocator<?> locator) {
            int length = eligibleUris.size();
            assert (length > 0);
            return eligibleUris.get(Math.floorMod(this.counter.getAndIncrement(), length));
        }
    };

    public URI selectNode(List<URI> var1, EJBLocator<?> var2);

    public static DiscoveredURISelector favorite(Collection<URI> favorites, DiscoveredURISelector fallback) {
        Assert.checkNotNullParam("favorites", favorites);
        Assert.checkNotNullParam("fallback", fallback);
        return (eligibleUris, locator) -> {
            for (URI favorite : favorites) {
                if (!eligibleUris.contains(favorite)) continue;
                return favorite;
            }
            return fallback.selectNode(eligibleUris, locator);
        };
    }
}

