/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.time.Instant;
import org.wildfly.common.Assert;
import org.wildfly.discovery.ServiceRegistration;

public class AggregateServiceRegistration
implements ServiceRegistration {
    private final ServiceRegistration[] registrations;

    protected AggregateServiceRegistration(ServiceRegistration ... registrations) {
        Assert.checkNotNullParam("registrations", registrations);
        this.registrations = registrations;
    }

    @Override
    public void close() {
        for (ServiceRegistration registration : this.registrations) {
            if (registration == null) continue;
            registration.close();
        }
    }

    @Override
    public void deactivate() {
        for (ServiceRegistration registration : this.registrations) {
            if (registration == null) continue;
            registration.deactivate();
        }
    }

    @Override
    public void activate() {
        for (ServiceRegistration registration : this.registrations) {
            if (registration == null) continue;
            registration.activate();
        }
    }

    @Override
    public void hintDeactivateAt(Instant instant) {
        for (ServiceRegistration registration : this.registrations) {
            if (registration == null) continue;
            registration.hintDeactivateAt(instant);
        }
    }
}

