/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.AutoCreatedQueueManager;
import org.apache.activemq.artemis.core.server.QueueDeleter;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;

public class AutoCreatedQueueManagerImpl
implements AutoCreatedQueueManager {
    private final SimpleString queueName;
    private final QueueDeleter deleter;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (AutoCreatedQueueManagerImpl.this.deleter != null) {
                    AutoCreatedQueueManagerImpl.this.deleter.delete(AutoCreatedQueueManagerImpl.this.queueName);
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedQueue(e, AutoCreatedQueueManagerImpl.this.queueName);
            }
        }
    };
    private final ReferenceCounterUtil referenceCounterUtil = new ReferenceCounterUtil(this.runnable);

    public AutoCreatedQueueManagerImpl(QueueDeleter deleter, SimpleString queueName) {
        this.deleter = deleter;
        this.queueName = queueName;
    }

    public int increment() {
        return this.referenceCounterUtil.increment();
    }

    public int decrement() {
        return this.referenceCounterUtil.decrement();
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

