/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Console;
import java.util.Arrays;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.vault.VaultInteraction;
import org.jboss.as.security.vault.VaultSession;

public class VaultInteractiveSession {
    private String salt;
    private String keystoreURL;
    private String encDir;
    private String keystoreAlias;
    private int iterationCount = 0;
    private VaultSession vaultNISession = null;

    public void start() {
        Console console = System.console();
        if (console == null) {
            System.err.println(SecurityLogger.ROOT_LOGGER.noConsole());
            System.exit(1);
        }
        while (this.encDir == null || this.encDir.length() == 0) {
            this.encDir = console.readLine(SecurityLogger.ROOT_LOGGER.enterEncryptionDirectory() + " ", new Object[0]);
        }
        while (this.keystoreURL == null || this.keystoreURL.length() == 0) {
            this.keystoreURL = console.readLine(SecurityLogger.ROOT_LOGGER.enterKeyStoreURL() + " ", new Object[0]);
        }
        char[] keystorePasswd = VaultInteractiveSession.getSensitiveValue(SecurityLogger.ROOT_LOGGER.enterKeyStorePassword(), SecurityLogger.ROOT_LOGGER.enterKeyStorePasswordAgain());
        try {
            while (this.salt == null || this.salt.length() != 8) {
                this.salt = console.readLine(SecurityLogger.ROOT_LOGGER.enterSalt() + " ", new Object[0]);
            }
            String ic = console.readLine(SecurityLogger.ROOT_LOGGER.enterIterationCount() + " ", new Object[0]);
            this.iterationCount = Integer.parseInt(ic);
            this.vaultNISession = new VaultSession(this.keystoreURL, new String(keystorePasswd), this.encDir, this.salt, this.iterationCount, true);
            while (this.keystoreAlias == null || this.keystoreAlias.length() == 0) {
                this.keystoreAlias = console.readLine(SecurityLogger.ROOT_LOGGER.enterKeyStoreAlias() + " ", new Object[0]);
            }
            System.out.println(SecurityLogger.ROOT_LOGGER.initializingVault());
            this.vaultNISession.startVaultSession(this.keystoreAlias);
            this.vaultNISession.vaultConfigurationDisplay();
            System.out.println(SecurityLogger.ROOT_LOGGER.vaultInitialized());
            System.out.println(SecurityLogger.ROOT_LOGGER.handshakeComplete());
            VaultInteraction vaultInteraction = new VaultInteraction(this.vaultNISession);
            vaultInteraction.start();
        }
        catch (Exception e) {
            System.out.println(SecurityLogger.ROOT_LOGGER.exceptionEncountered());
            e.printStackTrace(System.err);
        }
    }

    public static char[] getSensitiveValue(String passwordPrompt, String confirmationPrompt) {
        char[] passwd;
        while (true) {
            char[] passwd1;
            Console console;
            boolean noMatch;
            if (passwordPrompt == null) {
                passwordPrompt = SecurityLogger.ROOT_LOGGER.enterYourPassword();
            }
            if (confirmationPrompt == null) {
                confirmationPrompt = SecurityLogger.ROOT_LOGGER.enterYourPasswordAgain();
            }
            boolean bl = noMatch = !Arrays.equals(passwd = (console = System.console()).readPassword(passwordPrompt + " ", new Object[0]), passwd1 = console.readPassword(confirmationPrompt + " ", new Object[0]));
            if (!noMatch) break;
            System.out.println(SecurityLogger.ROOT_LOGGER.passwordsDoNotMatch());
        }
        System.out.println(SecurityLogger.ROOT_LOGGER.passwordsMatch());
        return passwd;
    }
}

