/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.jms.client.JMSMessageListenerWrapper;

public final class ActiveMQMessageConsumer
implements QueueReceiver,
TopicSubscriber {
    private final ConnectionFactoryOptions options;
    private final ClientConsumer consumer;
    private MessageListener listener;
    private MessageHandler coreListener;
    private final ActiveMQConnection connection;
    private final ActiveMQSession session;
    private final int ackMode;
    private final boolean noLocal;
    private final ActiveMQDestination destination;
    private final String selector;
    private final SimpleString autoDeleteQueueName;

    protected ActiveMQMessageConsumer(ConnectionFactoryOptions options, ActiveMQConnection connection, ActiveMQSession session, ClientConsumer consumer, boolean noLocal, ActiveMQDestination destination, String selector, SimpleString autoDeleteQueueName) throws JMSException {
        this.options = options;
        this.connection = connection;
        this.session = session;
        this.consumer = consumer;
        this.ackMode = session.getAcknowledgeMode();
        this.noLocal = noLocal;
        this.destination = destination;
        this.selector = selector;
        this.autoDeleteQueueName = autoDeleteQueueName;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.listener = listener;
        this.coreListener = listener == null ? null : new JMSMessageListenerWrapper(this.options, this.connection, this.session, this.consumer, listener, this.ackMode);
        try {
            this.consumer.setMessageHandler(this.coreListener);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public Message receive() throws JMSException {
        return this.getMessage(0L, false);
    }

    public Message receive(long timeout) throws JMSException {
        return this.getMessage(timeout, false);
    }

    public Message receiveNoWait() throws JMSException {
        return this.getMessage(0L, true);
    }

    public void close() throws JMSException {
        try {
            this.consumer.close();
            if (this.autoDeleteQueueName != null) {
                this.session.deleteQueue(this.autoDeleteQueueName);
            }
            this.session.removeConsumer(this);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public Queue getQueue() throws JMSException {
        this.checkClosed();
        return (Queue)this.destination;
    }

    public Topic getTopic() throws JMSException {
        this.checkClosed();
        return (Topic)this.destination;
    }

    public boolean getNoLocal() throws JMSException {
        this.checkClosed();
        return this.noLocal;
    }

    public String toString() {
        return "ActiveMQMessageConsumer[" + this.consumer + "]";
    }

    public boolean isClosed() {
        return this.consumer.isClosed();
    }

    private void checkClosed() throws JMSException {
        if (this.consumer.isClosed() || this.session.getCoreSession().isClosed()) {
            throw new IllegalStateException("Consumer is closed");
        }
    }

    private ActiveMQMessage getMessage(long timeout, boolean noWait) throws JMSException {
        try {
            ClientMessage coreMessage = noWait ? this.consumer.receiveImmediate() : this.consumer.receive(timeout);
            ActiveMQMessage jmsMsg = null;
            if (coreMessage != null) {
                ClientSession coreSession = this.session.getCoreSession();
                boolean needSession = this.ackMode == 2 || this.ackMode == 101 || coreMessage.getType() == 2;
                jmsMsg = ActiveMQMessage.createMessage(coreMessage, (ClientSession)(needSession ? coreSession : null), this.options);
                try {
                    jmsMsg.doBeforeReceive();
                }
                catch (IndexOutOfBoundsException ioob) {
                    ((ClientSessionInternal)this.session.getCoreSession()).markRollbackOnly();
                    IndexOutOfBoundsException newIOOB = new IndexOutOfBoundsException(ioob.getMessage() + "@" + jmsMsg.getCoreMessage());
                    newIOOB.initCause(ioob);
                    ActiveMQClientLogger.LOGGER.warn((Object)newIOOB.getMessage(), (Throwable)newIOOB);
                    throw ioob;
                }
                if (this.session.getAcknowledgeMode() == 101) {
                    jmsMsg.setIndividualAcknowledge();
                } else {
                    coreMessage.acknowledge();
                }
            }
            return jmsMsg;
        }
        catch (ActiveMQException e) {
            ((ClientSessionInternal)this.session.getCoreSession()).markRollbackOnly();
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
        catch (ActiveMQInterruptedException e) {
            ((ClientSessionInternal)this.session.getCoreSession()).markRollbackOnly();
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }
}

