/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Collections;
import java.util.Map;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.registry.Registry;

public class LocalRegistry<K, V>
implements Registry<K, V> {
    private final Group group;
    private final Runnable closeTask;
    private volatile Map.Entry<K, V> entry;

    public LocalRegistry(Group group, Map.Entry<K, V> entry, Runnable closeTask) {
        this.group = group;
        this.closeTask = closeTask;
        this.entry = entry;
    }

    public Group getGroup() {
        return this.group;
    }

    public void addListener(Registry.Listener<K, V> listener) {
    }

    public void removeListener(Registry.Listener<K, V> listener) {
    }

    public Map<K, V> getEntries() {
        Map.Entry<K, V> entry = this.entry;
        return entry != null ? Collections.singletonMap(entry.getKey(), entry.getValue()) : Collections.emptyMap();
    }

    public Map.Entry<K, V> getEntry(Node node) {
        return this.entry;
    }

    public void close() {
        this.entry = null;
        this.closeTask.run();
    }
}

