/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2014, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.wildfly.clustering.server.group;

import java.util.Collection;
import java.util.stream.Collectors;

import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.wildfly.clustering.group.Node;

/**
 * Infinispan cache-based {@link NodeFactory}.
 * @author Paul Ferraro
 */
public class CacheNodeFactory implements InfinispanNodeFactory {

    private final JGroupsNodeFactory factory;

    public CacheNodeFactory(JGroupsNodeFactory factory) {
        this.factory = factory;
    }

    @Override
    public Node createNode(Address address) {
        return this.factory.createNode(toJGroupsAddress(address));
    }

    @Override
    public void invalidate(Collection<Address> addresses) {
        if (!addresses.isEmpty()) {
            this.factory.invalidate(addresses.stream().map((Address address) -> toJGroupsAddress(address)).filter((org.jgroups.Address address) -> address != null).collect(Collectors.toList()));
        }
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address == null) return null;
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress) address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }
}
