/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.Serializable;
import java.util.List;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;

public final class BroadcastGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = 2335634694112319124L;
    private String name = null;
    private long broadcastPeriod = ActiveMQDefaultConfiguration.getDefaultBroadcastPeriod();
    private BroadcastEndpointFactory endpointFactory = null;
    private List<String> connectorInfos = null;

    public String getName() {
        return this.name;
    }

    public long getBroadcastPeriod() {
        return this.broadcastPeriod;
    }

    public List<String> getConnectorInfos() {
        return this.connectorInfos;
    }

    public BroadcastGroupConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public BroadcastGroupConfiguration setBroadcastPeriod(long broadcastPeriod) {
        this.broadcastPeriod = broadcastPeriod;
        return this;
    }

    public BroadcastGroupConfiguration setConnectorInfos(List<String> connectorInfos) {
        this.connectorInfos = connectorInfos;
        return this;
    }

    public BroadcastEndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public BroadcastGroupConfiguration setEndpointFactory(BroadcastEndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.broadcastPeriod ^ this.broadcastPeriod >>> 32);
        result = 31 * result + (this.connectorInfos == null ? 0 : this.connectorInfos.hashCode());
        result = 31 * result + (this.endpointFactory == null ? 0 : this.endpointFactory.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BroadcastGroupConfiguration other = (BroadcastGroupConfiguration)obj;
        if (this.broadcastPeriod != other.broadcastPeriod) {
            return false;
        }
        if (this.connectorInfos == null ? other.connectorInfos != null : !this.connectorInfos.equals(other.connectorInfos)) {
            return false;
        }
        if (this.endpointFactory == null ? other.endpointFactory != null : !this.endpointFactory.equals(other.endpointFactory)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

