/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.html_basic.ScriptStyleBaseRenderer;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class StylesheetRenderer
extends ScriptStyleBaseRenderer {
    @Override
    protected void startElement(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("style", component);
        writer.writeAttribute("type", (Object)"text/css", "type");
    }

    @Override
    protected void endElement(ResponseWriter writer) throws IOException {
        writer.endElement("style");
    }

    @Override
    protected String verifyTarget(String toVerify) {
        return "head";
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String msg;
        Map attributes = component.getAttributes();
        Map contextMap = context.getAttributes();
        String name = (String)attributes.get("name");
        String library = (String)attributes.get("library");
        String key = name + library;
        String media = (String)attributes.get("media");
        if (null == name) {
            return;
        }
        if (contextMap.containsKey(key)) {
            return;
        }
        contextMap.put(key, Boolean.TRUE);
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("link", component);
        writer.writeAttribute("type", (Object)"text/css", "type");
        writer.writeAttribute("rel", (Object)"stylesheet", "rel");
        String resourceUrl = "RES_NOT_FOUND";
        WebConfiguration webConfig = WebConfiguration.getInstance();
        if (library == null && name.startsWith(webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory)) && context.isProjectStage(ProjectStage.Development)) {
            msg = "Illegal path, direct contract references are not allowed: " + name;
            context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            resource = null;
        }
        if (resource != null) {
            resourceUrl = context.getExternalContext().encodeResourceURL(resource.getRequestPath());
        } else if (context.isProjectStage(ProjectStage.Development)) {
            msg = "Unable to find resource " + (library == null ? "" : library + ", ") + name;
            context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
        }
        writer.writeURIAttribute("href", (Object)resourceUrl, "href");
        if (media != null) {
            writer.writeAttribute("media", (Object)media, "media");
        }
        writer.endElement("link");
        super.encodeEnd(context, component);
    }
}

