/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.protocol.MulticastProtocol;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.SingletonProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class MulticastProtocolConfigurationBuilder<P extends Protocol>
extends ProtocolConfigurationBuilder<P> {
    private volatile ValueDependency<TransportConfiguration> transport;

    public MulticastProtocolConfigurationBuilder(PathAddress address) {
        super(address);
    }

    @Override
    public ServiceBuilder<ProtocolConfiguration<P>> build(ServiceTarget target) {
        return this.transport.register(super.build(target));
    }

    @Override
    public Builder<ProtocolConfiguration<P>> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.transport = new InjectedValueDependency((ServiceNameProvider)new SingletonProtocolServiceNameProvider(context.getCurrentAddress().getParent(), TransportResourceDefinition.WILDCARD_PATH), TransportConfiguration.class);
        return super.configure(context, model);
    }

    @Override
    public void accept(P protocol) {
        TransportConfiguration transport = (TransportConfiguration)this.transport.getValue();
        ((MulticastProtocol)protocol).setMulticast(transport.getSocketBinding().getMulticastAddress() != null);
    }
}

