/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class TableBuilder
extends ComponentBuilder<TableManipulationConfiguration> {
    private final Attribute prefixAttribute;
    private final Map<TableResourceDefinition.ColumnAttribute, Map.Entry<String, String>> columns = new EnumMap<TableResourceDefinition.ColumnAttribute, Map.Entry<String, String>>(TableResourceDefinition.ColumnAttribute.class);
    private volatile int batchSize;
    private volatile int fetchSize;
    private volatile String prefix;

    public TableBuilder(Attribute prefixAttribute, CacheComponent component, PathAddress cacheAddress) {
        super(component, cacheAddress);
        this.prefixAttribute = prefixAttribute;
    }

    public Builder<TableManipulationConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        for (TableResourceDefinition.ColumnAttribute column : EnumSet.allOf(TableResourceDefinition.ColumnAttribute.class)) {
            ModelNode columnModel = column.resolveModelAttribute((ExpressionResolver)context, model);
            String name = column.getColumnName().resolveModelAttribute((ExpressionResolver)context, columnModel).asString();
            String type = column.getColumnType().resolveModelAttribute((ExpressionResolver)context, columnModel).asString();
            this.columns.put(column, new AbstractMap.SimpleImmutableEntry<String, String>(name, type));
        }
        this.batchSize = TableResourceDefinition.Attribute.BATCH_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.fetchSize = TableResourceDefinition.Attribute.FETCH_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.prefix = this.prefixAttribute.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return this;
    }

    public TableManipulationConfiguration getValue() {
        return ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).table().idColumnName(this.columns.get((Object)TableResourceDefinition.ColumnAttribute.ID).getKey())).idColumnType(this.columns.get((Object)TableResourceDefinition.ColumnAttribute.ID).getValue())).dataColumnName(this.columns.get((Object)TableResourceDefinition.ColumnAttribute.DATA).getKey())).dataColumnType(this.columns.get((Object)TableResourceDefinition.ColumnAttribute.DATA).getValue())).timestampColumnName(this.columns.get((Object)TableResourceDefinition.ColumnAttribute.TIMESTAMP).getKey())).timestampColumnType(this.columns.get((Object)TableResourceDefinition.ColumnAttribute.TIMESTAMP).getValue())).batchSize(this.batchSize)).fetchSize(this.fetchSize)).tableNamePrefix(this.prefix)).create();
    }
}

