/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import org.jboss.as.cli.embedded.Contexts;
import org.jboss.as.cli.embedded.EmbeddedLogContext;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.wildfly.security.manager.WildFlySecurityManager;

class EnvironmentRestorer {
    private final String jbossHome = WildFlySecurityManager.getPropertyPrivileged("jboss.home.dir", null);
    private final String bootLog = WildFlySecurityManager.getPropertyPrivileged("org.jboss.boot.log.file", null);
    private final Contexts defaultContexts = new Contexts(LogContext.getLogContext(), StdioContext.getStdioContext());
    private boolean logContextSelectorRestored;

    EnvironmentRestorer() {
    }

    Contexts getDefaultContexts() {
        return this.defaultContexts;
    }

    synchronized void restoreLogContextSelector() {
        if (!this.logContextSelectorRestored) {
            final LogContext logContext = this.defaultContexts.getLogContext();
            if (logContext == LogContext.getSystemLogContext()) {
                LogContext.setLogContextSelector(LogContext.DEFAULT_LOG_CONTEXT_SELECTOR);
            } else {
                LogContext.setLogContextSelector(new LogContextSelector(){

                    @Override
                    public LogContext getLogContext() {
                        return logContext;
                    }
                });
            }
            EmbeddedLogContext.clearLogContext();
            this.logContextSelectorRestored = true;
        }
    }

    void restoreEnvironment() {
        if (this.jbossHome == null) {
            WildFlySecurityManager.clearPropertyPrivileged("jboss.home.dir");
        } else {
            WildFlySecurityManager.setPropertyPrivileged("jboss.home.dir", this.jbossHome);
        }
        if (this.bootLog == null) {
            WildFlySecurityManager.clearPropertyPrivileged("org.jboss.boot.log.file");
        } else {
            WildFlySecurityManager.setPropertyPrivileged("org.jboss.boot.log.file", this.bootLog);
        }
        StdioContext.setStdioContextSelector(new SimpleStdioContextSelector(this.defaultContexts.getStdioContext()));
        this.restoreLogContextSelector();
    }
}

