/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.persistence;

import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.wildfly.clustering.infinispan.spi.persistence.IndexedKeyFormatMapper;
import org.wildfly.clustering.infinispan.spi.persistence.KeyFormat;
import org.wildfly.clustering.infinispan.spi.persistence.SimpleKeyFormat;

public class DynamicKeyFormatMapper
extends IndexedKeyFormatMapper {
    public DynamicKeyFormatMapper(ClassLoader loader) {
        super(DynamicKeyFormatMapper.load(loader));
    }

    private static List<KeyFormat<?>> load(ClassLoader loader) {
        LinkedList keyFormats = new LinkedList();
        keyFormats.add(new SimpleKeyFormat<String>(String.class, Function.identity()));
        keyFormats.add(new SimpleKeyFormat<Byte>(Byte.class, Byte::valueOf));
        keyFormats.add(new SimpleKeyFormat<Short>(Short.class, Short::valueOf));
        keyFormats.add(new SimpleKeyFormat<Integer>(Integer.class, Integer::valueOf));
        keyFormats.add(new SimpleKeyFormat<Long>(Long.class, Long::valueOf));
        keyFormats.add(new SimpleKeyFormat<UUID>(UUID.class, UUID::fromString));
        StreamSupport.stream(ServiceLoader.load(KeyFormat.class, loader).spliterator(), false).forEach(keyFormat -> keyFormats.add((KeyFormat<?>)keyFormat));
        return keyFormats;
    }
}

