/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TP;
import org.jgroups.util.AsciiString;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class SHARED_LOOPBACK
extends TP {
    protected PhysicalAddress physical_addr;
    @ManagedAttribute(description="The current view", writable=false)
    protected volatile View view;
    protected volatile boolean is_server = false;
    protected volatile boolean is_coord = false;
    private static final ConcurrentMap<AsciiString, Map<Address, SHARED_LOOPBACK>> routing_table = new ConcurrentHashMap<AsciiString, Map<Address, SHARED_LOOPBACK>>();

    @Override
    public boolean supportsMulticasting() {
        return true;
    }

    public View getView() {
        return this.view;
    }

    public boolean isServer() {
        return this.is_server;
    }

    public boolean isCoord() {
        return this.is_coord;
    }

    @Override
    public String toString() {
        return "SHARED_LOOPBACK(local address: " + this.local_addr + ')';
    }

    @ManagedOperation(description="Dumps the contents of the routing table")
    public static String dumpRoutingTable() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : routing_table.entrySet()) {
            AsciiString cluster_name = (AsciiString)entry.getKey();
            Set mbrs = ((Map)entry.getValue()).keySet();
            sb.append(cluster_name).append(": ").append(mbrs).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void sendMulticast(AsciiString cluster_name, byte[] data, int offset, int length) throws Exception {
        Map dests = (Map)routing_table.get(this.cluster_name);
        if (dests == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("no destination found for " + this.cluster_name);
            }
            return;
        }
        for (Map.Entry entry : dests.entrySet()) {
            Address dest = (Address)entry.getKey();
            SHARED_LOOPBACK target = (SHARED_LOOPBACK)entry.getValue();
            if (this.local_addr != null && this.local_addr.equals(dest)) continue;
            try {
                target.receive(this.local_addr, data, offset, length);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailedSendingMessageTo") + dest, t);
            }
        }
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this.sendToSingleMember(dest, data, offset, length);
    }

    @Override
    protected void sendToSingleMember(Address dest, byte[] buf, int offset, int length) throws Exception {
        Map dests = (Map)routing_table.get(this.cluster_name);
        if (dests == null) {
            this.log.trace("no destination found for " + this.cluster_name);
            return;
        }
        SHARED_LOOPBACK target = (SHARED_LOOPBACK)dests.get(dest);
        if (target == null) {
            this.log.trace("destination address " + dest + " not found");
            return;
        }
        target.receive(this.local_addr, buf, offset, length);
    }

    public static List<PingData> getDiscoveryResponsesFor(String cluster_name) {
        if (cluster_name == null) {
            return null;
        }
        Map mbrs = (Map)routing_table.get(new AsciiString(cluster_name));
        ArrayList<PingData> rsps = new ArrayList<PingData>(mbrs != null ? mbrs.size() : 0);
        if (mbrs != null) {
            for (Map.Entry entry : mbrs.entrySet()) {
                Address addr = (Address)entry.getKey();
                SHARED_LOOPBACK slp = (SHARED_LOOPBACK)entry.getValue();
                PingData data = new PingData(addr, slp.isServer(), UUID.get(addr), null).coord(slp.isCoord());
                rsps.add(data);
            }
        }
        return rsps;
    }

    @Override
    public String getInfo() {
        return this.toString();
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.physical_addr;
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                SHARED_LOOPBACK.register(this.cluster_name, this.local_addr, this);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 6: 
            case 15: {
                this.view = (View)evt.getArg();
                Address[] mbrs = ((View)evt.getArg()).getMembersRaw();
                this.is_coord = this.local_addr != null && mbrs != null && mbrs.length > 0 && this.local_addr.equals(mbrs[0]);
                break;
            }
            case 109: {
                return SHARED_LOOPBACK.getDiscoveryResponsesFor((String)evt.getArg());
            }
        }
        return retval;
    }

    @Override
    public void stop() {
        super.stop();
        this.is_coord = false;
        this.is_server = false;
        SHARED_LOOPBACK.unregister(this.cluster_name, this.local_addr);
    }

    @Override
    public void destroy() {
        super.destroy();
        SHARED_LOOPBACK.unregister(this.cluster_name, this.local_addr);
    }

    protected static void register(AsciiString channel_name, Address local_addr, SHARED_LOOPBACK shared_loopback) {
        Map tmp;
        Map<Address, SHARED_LOOPBACK> map = (ConcurrentHashMap<Address, SHARED_LOOPBACK>)routing_table.get(channel_name);
        if (map == null && (tmp = (Map)routing_table.putIfAbsent(channel_name, map = new ConcurrentHashMap<Address, SHARED_LOOPBACK>())) != null) {
            map = tmp;
        }
        map.put(local_addr, shared_loopback);
    }

    protected static void unregister(AsciiString channel_name, Address local_addr) {
        Map map;
        Map map2 = map = channel_name != null ? (Map)routing_table.get(channel_name) : null;
        if (map != null) {
            map.remove(local_addr);
            if (map.isEmpty()) {
                routing_table.remove(channel_name);
            }
        }
    }
}

