/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.SuspectedException;
import org.jgroups.UnreachableException;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.util.Rsp;

public class UnicastRequest<T>
extends Request {
    protected final Rsp<T> result;
    protected final Address target;
    protected int num_received = 0;

    public UnicastRequest(RequestCorrelator corr, Address target, RequestOptions options) {
        super(corr, options);
        this.target = target;
        this.result = new Rsp(target);
    }

    @Override
    protected void sendRequest(Message request_msg) throws Exception {
        try {
            this.corr.sendUnicastRequest(this.target, request_msg, this.options.getMode() == ResponseMode.GET_NONE ? null : this);
        }
        catch (Exception ex) {
            if (this.corr != null && this.req_id > 0L) {
                this.corr.done(this.req_id);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender, boolean is_exception) {
        RspFilter rsp_filter = this.options.getRspFilter();
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            if (!this.result.wasReceived()) {
                ++this.num_received;
                if (rsp_filter == null || rsp_filter.isAcceptable(response_value, sender)) {
                    if (is_exception && response_value instanceof Throwable) {
                        this.result.setException((Throwable)response_value);
                    } else {
                        this.result.setValue(response_value);
                    }
                }
            }
            boolean bl = this.done = this.responsesComplete() || rsp_filter != null && !rsp_filter.needMoreResponses();
            if (this.done && this.corr != null && this.req_id > 0L) {
                this.corr.done(this.req_id);
            }
            this.checkCompletion(this);
        }
        finally {
            this.cond.signal(true);
            this.lock.unlock();
        }
    }

    public boolean responseReceived() {
        return this.num_received >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null || !suspected_member.equals(this.target)) {
            return;
        }
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            if (this.result != null && !this.result.wasReceived()) {
                this.result.setSuspected();
            }
            this.done = true;
            if (this.corr != null && this.req_id > 0L) {
                this.corr.done(this.req_id);
            }
            this.cond.signal(true);
            this.checkCompletion(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void siteUnreachable(String site) {
        if (!(this.target instanceof SiteAddress)) {
            return;
        }
        if (!((SiteAddress)this.target).getSite().equals(site)) {
            return;
        }
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            if (this.result != null && !this.result.wasUnreachable()) {
                this.result.setUnreachable();
            }
            this.done = true;
            if (this.corr != null && this.req_id > 0L) {
                this.corr.done(this.req_id);
            }
            this.cond.signal(true);
            this.checkCompletion(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View view) {
        if (view == null) {
            return;
        }
        this.lock.lock();
        try {
            if (!(this.target instanceof SiteAddress) && !view.containsMember(this.target)) {
                this.result.setSuspected();
                this.done = true;
                if (this.corr != null && this.req_id > 0L) {
                    this.corr.done(this.req_id);
                }
                this.cond.signal(true);
                this.checkCompletion(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportClosed() {
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            if (this.result != null && !this.result.wasReceived()) {
                this.result.setException(new IllegalStateException("transport was closed"));
            }
            this.done = true;
            if (this.corr != null && this.req_id > 0L) {
                this.corr.done(this.req_id);
            }
            this.cond.signal(true);
            this.checkCompletion(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Rsp<T> getResult() {
        return this.result;
    }

    public T getValue() throws ExecutionException {
        if (this.result.wasSuspected()) {
            throw new ExecutionException(new SuspectedException(this.target));
        }
        if (this.result.hasException()) {
            throw new ExecutionException(this.result.getException());
        }
        if (this.result.wasUnreachable()) {
            throw new ExecutionException(new UnreachableException(this.target));
        }
        if (!this.result.wasReceived()) {
            throw new ExecutionException(new TimeoutException("timeout sending message to " + this.target));
        }
        return this.result.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            this.waitForResults(0L);
            T t = this.getValue();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean ok;
        this.lock.lock();
        try {
            ok = this.waitForResults(unit.toMillis(timeout));
        }
        finally {
            this.lock.unlock();
        }
        if (!ok) {
            throw new TimeoutException();
        }
        return this.getValue();
    }

    @Override
    public String toString() {
        return String.format("%s, target=%s", super.toString(), this.target);
    }

    @Override
    protected boolean responsesComplete() {
        return this.done || this.options.getMode() == ResponseMode.GET_NONE || this.result.wasReceived() || this.result.wasSuspected() || this.result.wasUnreachable() || this.num_received >= 1;
    }
}

