/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperMessages;

public class JasperLoader
extends URLClassLoader {
    private final PermissionCollection permissionCollection;
    private final ClassLoader parent;
    private final SecurityManager securityManager;
    private final CodeSource codeSource;
    private final AccessControlContext acc;

    public JasperLoader(URL[] urls, ClassLoader parent, PermissionCollection permissionCollection, CodeSource codeSource) {
        super(urls, parent);
        this.permissionCollection = permissionCollection;
        this.parent = parent;
        this.codeSource = codeSource;
        this.securityManager = System.getSecurityManager();
        this.acc = AccessController.getContext();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int dot;
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.securityManager != null && (dot = name.lastIndexOf(46)) >= 0) {
            try {
                if (!"org.apache.jasper.runtime".equalsIgnoreCase(name.substring(0, dot))) {
                    this.securityManager.checkPackageAccess(name.substring(0, dot));
                }
            }
            catch (SecurityException se) {
                throw new ClassNotFoundException(JasperMessages.MESSAGES.securityExceptionLoadingClass(name), se);
            }
        }
        if (!name.startsWith(Constants.JSP_PACKAGE_NAME + '.')) {
            clazz = this.parent.loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return this.findClass(name);
    }

    @Override
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    URL res = JasperLoader.this.findResource(path);
                    if (res != null) {
                        try {
                            byte[] bytes = JasperLoader.this.getBytes(res);
                            return JasperLoader.this.defineClass(name, bytes, 0, bytes.length, JasperLoader.this.codeSource);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    private byte[] getBytes(URL resource) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (InputStream stream = resource.openStream();){
            int bytesRead;
            byte[] chunk = new byte[4096];
            while ((bytesRead = stream.read(chunk)) > 0) {
                outputStream.write(chunk, 0, bytesRead);
            }
        }
        return outputStream.toByteArray();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        InputStream is = this.parent.getResourceAsStream(name);
        if (is == null && (url = this.findResource(name)) != null) {
            try {
                is = url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return is;
    }

    @Override
    public final PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionCollection;
    }
}

