/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.FacetEncodingType;
import org.hibernate.search.annotations.Facets;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Latitude;
import org.hibernate.search.annotations.Longitude;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.SortableFields;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.Spatials;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.bridge.ContainerBridge;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.DefaultStringBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.builtin.time.impl.NumericTimeBridge;
import org.hibernate.search.bridge.impl.BridgeFactory;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.AnnotationProcessingHelper;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.impl.nullencoding.KeywordBasedNullCodec;
import org.hibernate.search.engine.impl.nullencoding.NotEncodingCodec;
import org.hibernate.search.engine.impl.nullencoding.NullMarkerCodec;
import org.hibernate.search.engine.impl.nullencoding.NumericNullEncodersHelper;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadata;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadataBuilder;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.FieldMetadataBuilderImpl;
import org.hibernate.search.engine.metadata.impl.MetadataProvider;
import org.hibernate.search.engine.metadata.impl.NumericFieldsConfiguration;
import org.hibernate.search.engine.metadata.impl.ParseContext;
import org.hibernate.search.engine.metadata.impl.PathsContext;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AnnotationMetadataProvider
implements MetadataProvider {
    private static final Log log = LoggerFactory.make();
    private static final org.hibernate.search.bridge.StringBridge NULL_EMBEDDED_STRING_BRIDGE = DefaultStringBridge.INSTANCE;
    private static final String UNKNOWN_MAPPED_BY_ROLE = "";
    private static final String EMPTY_PREFIX = "";
    private final ReflectionManager reflectionManager;
    private final ConfigContext configContext;
    private final BridgeFactory bridgeFactory;

    public AnnotationMetadataProvider(ReflectionManager reflectionManager, ConfigContext configContext) {
        this.reflectionManager = reflectionManager;
        this.configContext = configContext;
        this.bridgeFactory = new BridgeFactory(configContext.getServiceManager());
    }

    @Override
    public TypeMetadata getTypeMetadataFor(Class<?> clazz) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        TypeMetadata.Builder typeMetadataBuilder = new TypeMetadata.Builder(clazz, this.configContext).boost(this.getBoost(xClass)).boostStrategy(AnnotationProcessingHelper.getDynamicBoost((XAnnotatedElement)xClass)).analyzer(this.configContext.getDefaultAnalyzer());
        ParseContext parseContext = new ParseContext();
        parseContext.processingClass(xClass);
        parseContext.setCurrentClass(xClass);
        this.inizializePackageLevelAnnotations(this.packageInfo(clazz), this.configContext);
        this.initializeClass(typeMetadataBuilder, true, "", parseContext, this.configContext, false, null);
        return typeMetadataBuilder.build();
    }

    private XPackage packageInfo(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        try {
            return this.reflectionManager.packageForName(packageName);
        }
        catch (ClassNotFoundException | ClassLoadingException e) {
            log.debugf("package-info not found for package '%s'", packageName, clazz);
            return null;
        }
    }

    @Override
    public boolean containsSearchMetadata(Class<?> clazz) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        return ReflectionHelper.containsSearchAnnotations(xClass);
    }

    private void checkDocumentId(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, NumericFieldsConfiguration numericFields, boolean isRoot, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        Annotation idAnnotation = this.getIdAnnotation(member, typeMetadataBuilder, configContext);
        if (idAnnotation == null) {
            return;
        }
        String unprefixedAttributeName = this.getIdAttributeName(member, idAnnotation);
        String path = prefix + unprefixedAttributeName;
        if (isRoot) {
            this.createIdPropertyMetadata(member, typeMetadataBuilder, numericFields, configContext, parseContext, idAnnotation, path, unprefixedAttributeName);
        } else if (parseContext.includeEmbeddedObjectId() || pathsContext != null && pathsContext.containsPath(path)) {
            this.createPropertyMetadataForEmbeddedId(member, typeMetadataBuilder, propertyMetadataBuilder, numericFields, configContext, unprefixedAttributeName, path);
        }
        if (pathsContext != null) {
            pathsContext.markEncounteredPath(path);
        }
    }

    private void createPropertyMetadataForEmbeddedId(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, NumericFieldsConfiguration numericFields, ConfigContext configContext, String unprefixedFieldName, String fieldName) {
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.YES);
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
        FieldBridge fieldBridge = this.bridgeFactory.buildFieldBridge((XMember)member, true, numericFields.isNumericField(unprefixedFieldName), this.reflectionManager, configContext.getServiceManager());
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(fieldName, Store.YES, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, null)).fieldBridge(fieldBridge).idInEmbedded().build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        org.apache.lucene.analysis.Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((Analyzer)member.getAnnotation(Analyzer.class), configContext);
        if (analyzer == null) {
            analyzer = typeMetadataBuilder.getAnalyzer();
        }
        if (analyzer == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
        typeMetadataBuilder.addToScopedAnalyzer(fieldName, analyzer, index);
    }

    private void createIdPropertyMetadata(XProperty member, TypeMetadata.Builder typeMetadataBuilder, NumericFieldsConfiguration numericFields, ConfigContext configContext, ParseContext parseContext, Annotation idAnnotation, String path, String unprefixedAttributeName) {
        FieldBridge idBridge;
        NumericField numericFieldAnnotation;
        if (parseContext.isExplicitDocumentId()) {
            if (idAnnotation instanceof DocumentId) {
                throw log.duplicateDocumentIdFound(typeMetadataBuilder.getIndexedType().getName());
            }
            return;
        }
        if (idAnnotation instanceof DocumentId) {
            parseContext.setExplicitDocumentId(true);
        }
        if ((numericFieldAnnotation = numericFields.getNumericFieldAnnotation(unprefixedAttributeName)) != null && numericFieldAnnotation.forField().isEmpty() && (member.isAnnotationPresent(Field.class) || member.isAnnotationPresent(Fields.class))) {
            numericFieldAnnotation = null;
        }
        if (!((idBridge = this.bridgeFactory.buildFieldBridge((XMember)member, true, numericFieldAnnotation != null, this.reflectionManager, configContext.getServiceManager())) instanceof TwoWayFieldBridge)) {
            throw new SearchException("Bridge for document id does not implement TwoWayFieldBridge: " + member.getName());
        }
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
        DocumentFieldMetadata.Builder idMetadataBuilder = new DocumentFieldMetadata.Builder(path, Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, termVector).id().boost(AnnotationProcessingHelper.getBoost(member, null)).fieldBridge(idBridge);
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = this.determineNumericFieldEncoding(idBridge);
        if (numericEncodingType != NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN) {
            idMetadataBuilder.numeric();
            idMetadataBuilder.numericEncodingType(numericEncodingType);
        }
        DocumentFieldMetadata fieldMetadata = idMetadataBuilder.build();
        PropertyMetadata.Builder propertyMetadataBuilder = new PropertyMetadata.Builder(member);
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        this.checkForSortableField(member, typeMetadataBuilder, propertyMetadataBuilder, "", true, null, parseContext);
        this.checkForSortableFields(member, typeMetadataBuilder, propertyMetadataBuilder, "", true, null, parseContext);
        PropertyMetadata idPropertyMetadata = propertyMetadataBuilder.build();
        typeMetadataBuilder.idProperty(idPropertyMetadata);
    }

    private Annotation getIdAnnotation(XProperty member, TypeMetadata.Builder typeMetadataBuilder, ConfigContext context) {
        Annotation idAnnotation = null;
        DocumentId documentIdAnnotation = (DocumentId)member.getAnnotation(DocumentId.class);
        if (documentIdAnnotation != null) {
            idAnnotation = documentIdAnnotation;
        }
        if (context.isJpaPresent()) {
            Annotation jpaId;
            try {
                Class jpaIdClass = ClassLoaderHelper.classForName("javax.persistence.Id", this.configContext.getServiceManager());
                jpaId = member.getAnnotation(jpaIdClass);
            }
            catch (ClassLoadingException e) {
                throw new SearchException("Unable to load @Id.class even though it should be present ?!");
            }
            if (jpaId != null) {
                typeMetadataBuilder.jpaProperty(member);
                if (documentIdAnnotation == null) {
                    log.debug("Found JPA id and using it as document id");
                    idAnnotation = jpaId;
                }
            }
        }
        return idAnnotation;
    }

    private void initializeProvidedIdMetadata(ProvidedId providedId, XClass clazz, TypeMetadata.Builder typeMetadataBuilder) {
        String providedIdFieldName;
        TwoWayFieldBridge providedIdFieldBridge;
        if (providedId != null) {
            providedIdFieldBridge = this.bridgeFactory.extractTwoWayType(providedId.bridge(), clazz, this.reflectionManager);
            providedIdFieldName = providedId.name();
        } else {
            providedIdFieldBridge = new TwoWayString2FieldBridgeAdaptor(StringBridge.INSTANCE);
            providedIdFieldName = "providedId";
        }
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(providedIdFieldName, Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO).fieldBridge(providedIdFieldBridge).boost(Float.valueOf(1.0f)).build();
        PropertyMetadata propertyMetadata = new PropertyMetadata.Builder(null).addDocumentField(fieldMetadata).build();
        typeMetadataBuilder.idProperty(propertyMetadata);
    }

    private String getIdAttributeName(XProperty member, Annotation idAnnotation) {
        String name = null;
        try {
            Method m = idAnnotation.getClass().getMethod("name", new Class[0]);
            name = (String)m.invoke((Object)idAnnotation, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ReflectionHelper.getAttributeName((XMember)member, name);
    }

    private float getBoost(XClass element) {
        float boost = 1.0f;
        if (element == null) {
            return boost;
        }
        Boost boostAnnotation = (Boost)element.getAnnotation(Boost.class);
        if (boostAnnotation != null) {
            boost = boostAnnotation.value();
        }
        return boost;
    }

    private void initializeClass(TypeMetadata.Builder typeMetadataBuilder, boolean isRoot, String prefix, ParseContext parseContext, ConfigContext configContext, boolean disableOptimizationsArg, PathsContext pathsContext) {
        List<XClass> hierarchy = ReflectionHelper.createXClassHierarchy(parseContext.getCurrentClass());
        ProvidedId explicitProvidedIdAnnotation = null;
        XClass providedIdHostingClass = null;
        for (XClass currentClass : hierarchy) {
            if (currentClass.getAnnotation(ProvidedId.class) != null) {
                explicitProvidedIdAnnotation = (ProvidedId)currentClass.getAnnotation(ProvidedId.class);
                providedIdHostingClass = currentClass;
            }
            parseContext.setCurrentClass(currentClass);
            this.initializeClassLevelAnnotations(typeMetadataBuilder, prefix, configContext, parseContext);
            this.initializeClassBridgeInstances(typeMetadataBuilder, prefix, configContext, currentClass);
        }
        boolean isProvidedId = false;
        if (explicitProvidedIdAnnotation != null || configContext.isProvidedIdImplicit()) {
            this.initializeProvidedIdMetadata(explicitProvidedIdAnnotation, providedIdHostingClass, typeMetadataBuilder);
            isProvidedId = true;
        }
        boolean disableOptimizations = disableOptimizationsArg || !this.stateInspectionOptimizationsEnabled(typeMetadataBuilder);
        for (XClass currentClass : hierarchy) {
            parseContext.setCurrentClass(currentClass);
            List methods = currentClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMemberLevelAnnotations(prefix, method, typeMetadataBuilder, disableOptimizations, isRoot, isProvidedId, configContext, pathsContext, parseContext);
            }
            List fields = currentClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMemberLevelAnnotations(prefix, field, typeMetadataBuilder, disableOptimizations, isRoot, isProvidedId, configContext, pathsContext, parseContext);
            }
            for (String unqualifiedCollectionRole : parseContext.getCollectedUnqualifiedCollectionRoles()) {
                typeMetadataBuilder.addCollectionRole(StringHelper.qualify(parseContext.getCurrentClass().getName(), unqualifiedCollectionRole));
            }
        }
    }

    private void inizializePackageLevelAnnotations(XPackage xPackage, ConfigContext configContext) {
        if (xPackage != null) {
            this.checkForAnalyzerDefs((XAnnotatedElement)xPackage, configContext);
            this.checkForFullTextFilterDefs((XAnnotatedElement)xPackage, configContext);
        }
    }

    private void initializeClassLevelAnnotations(TypeMetadata.Builder typeMetadataBuilder, String prefix, ConfigContext configContext, ParseContext parseContext) {
        Spatials spatialsAnnotation;
        Spatial spatialAnnotation;
        ClassBridge classBridgeAnnotation;
        XClass clazz = parseContext.getCurrentClass();
        org.apache.lucene.analysis.Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((Analyzer)clazz.getAnnotation(Analyzer.class), configContext);
        if (analyzer != null) {
            typeMetadataBuilder.analyzer(analyzer);
        }
        this.checkForAnalyzerDefs((XAnnotatedElement)clazz, configContext);
        this.checkForFullTextFilterDefs((XAnnotatedElement)clazz, configContext);
        ClassBridges classBridgesAnnotation = (ClassBridges)clazz.getAnnotation(ClassBridges.class);
        if (classBridgesAnnotation != null) {
            ClassBridge[] classBridges;
            for (ClassBridge cb : classBridges = classBridgesAnnotation.value()) {
                this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, cb, clazz, configContext);
            }
        }
        if ((classBridgeAnnotation = (ClassBridge)clazz.getAnnotation(ClassBridge.class)) != null) {
            this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, classBridgeAnnotation, clazz, configContext);
        }
        if ((spatialAnnotation = (Spatial)clazz.getAnnotation(Spatial.class)) != null) {
            this.bindSpatialAnnotation(spatialAnnotation, prefix, typeMetadataBuilder, parseContext);
        }
        if ((spatialsAnnotation = (Spatials)clazz.getAnnotation(Spatials.class)) != null) {
            Spatial[] spatials;
            for (Spatial innerSpatialAnnotation : spatials = spatialsAnnotation.value()) {
                this.bindSpatialAnnotation(innerSpatialAnnotation, prefix, typeMetadataBuilder, parseContext);
            }
        }
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)clazz, typeMetadataBuilder, configContext);
    }

    private void initializeClassBridgeInstances(TypeMetadata.Builder typeMetadataBuilder, String prefix, ConfigContext configContext, XClass clazz) {
        Map<FieldBridge, ClassBridge> classBridgeInstances = configContext.getClassBridgeInstances(this.reflectionManager.toClass(clazz));
        for (Map.Entry<FieldBridge, ClassBridge> classBridge : classBridgeInstances.entrySet()) {
            FieldBridge instance = classBridge.getKey();
            ClassBridge configuration = classBridge.getValue();
            this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, configuration, instance, configContext);
        }
    }

    private void bindClassBridgeAnnotation(String prefix, TypeMetadata.Builder typeMetadataBuilder, ClassBridge classBridgeAnnotation, XClass clazz, ConfigContext configContext) {
        FieldBridge fieldBridge = this.bridgeFactory.extractType(classBridgeAnnotation, this.reflectionManager.toClass(clazz));
        this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, classBridgeAnnotation, fieldBridge, configContext);
    }

    private void bindClassBridgeAnnotation(String prefix, TypeMetadata.Builder typeMetadataBuilder, ClassBridge classBridgeAnnotation, FieldBridge fieldBridge, ConfigContext configContext) {
        this.bridgeFactory.injectParameters(classBridgeAnnotation, fieldBridge);
        String fieldName = prefix + classBridgeAnnotation.name();
        Store store = classBridgeAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(classBridgeAnnotation.index(), classBridgeAnnotation.analyze(), classBridgeAnnotation.norms());
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(classBridgeAnnotation.termVector());
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(fieldName, store, index, termVector).boost(Float.valueOf(classBridgeAnnotation.boost().value())).fieldBridge(fieldBridge).build();
        typeMetadataBuilder.addClassBridgeField(fieldMetadata);
        if (fieldBridge instanceof MetadataProvidingFieldBridge) {
            MetadataProvidingFieldBridge metadataProvidingFieldBridge = (MetadataProvidingFieldBridge)fieldBridge;
            typeMetadataBuilder.addClassBridgeSortableFields(this.getSortableFieldNames(fieldName, metadataProvidingFieldBridge));
        }
        org.apache.lucene.analysis.Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer(classBridgeAnnotation.analyzer(), configContext);
        typeMetadataBuilder.addToScopedAnalyzer(fieldName, analyzer, index);
    }

    private void bindSpatialAnnotation(Spatial spatialAnnotation, String prefix, XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, ParseContext parseContext) {
        if (parseContext.isSpatialNameUsed(spatialAnnotation.name())) {
            throw log.cannotHaveTwoSpatialsWithDefaultOrSameName(member.getType().getName());
        }
        parseContext.markSpatialNameAsUsed(spatialAnnotation.name());
        String fieldName = prefix + ReflectionHelper.getAttributeName((XMember)member, spatialAnnotation.name());
        Store store = spatialAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.NO);
        Field.TermVector termVector = Field.TermVector.NO;
        FieldBridge fieldBridge = this.bridgeFactory.buildFieldBridge((XMember)member, false, false, this.reflectionManager, this.configContext.getServiceManager());
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(fieldName, store, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, spatialAnnotation)).fieldBridge(fieldBridge).spatial().build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        if (member.isCollection()) {
            parseContext.collectUnqualifiedCollectionRole(member.getName());
        }
    }

    private void bindSpatialAnnotation(Spatial spatialAnnotation, String prefix, TypeMetadata.Builder typeMetadataBuilder, ParseContext parseContext) {
        org.apache.lucene.analysis.Analyzer analyzer;
        String fieldName = !spatialAnnotation.name().isEmpty() ? prefix + spatialAnnotation.name() : "_hibernate_default_coordinates";
        if (parseContext.isSpatialNameUsed(spatialAnnotation.name())) {
            throw log.cannotHaveTwoSpatialsWithDefaultOrSameName(parseContext.getCurrentClass().getName());
        }
        parseContext.markSpatialNameAsUsed(spatialAnnotation.name());
        Store store = spatialAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.NO);
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
        FieldBridge spatialBridge = this.determineSpatialFieldBridge(spatialAnnotation, parseContext);
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(fieldName, store, index, termVector).boost(Float.valueOf(spatialAnnotation.boost().value())).fieldBridge(spatialBridge).spatial().build();
        typeMetadataBuilder.addClassBridgeField(fieldMetadata);
        if (spatialBridge instanceof MetadataProvidingFieldBridge) {
            MetadataProvidingFieldBridge metadataProvidingFieldBridge = (MetadataProvidingFieldBridge)spatialBridge;
            typeMetadataBuilder.addClassBridgeSortableFields(this.getSortableFieldNames(fieldName, metadataProvidingFieldBridge));
        }
        if ((analyzer = typeMetadataBuilder.getAnalyzer()) == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
    }

    private FieldBridge determineSpatialFieldBridge(Spatial spatialAnnotation, ParseContext parseContext) {
        FieldBridge spatialBridge;
        XClass clazz = parseContext.getCurrentClass();
        if (this.reflectionManager.toXClass(Coordinates.class).isAssignableFrom(clazz)) {
            spatialBridge = this.bridgeFactory.buildSpatialBridge(spatialAnnotation, clazz, null, null);
        } else {
            String latitudeField = null;
            String longitudeField = null;
            List fieldList = clazz.getDeclaredProperties("field");
            for (XProperty property : fieldList) {
                if (property.isAnnotationPresent(Latitude.class) && ((Latitude)property.getAnnotation(Latitude.class)).of().equals(spatialAnnotation.name())) {
                    if (latitudeField != null) {
                        throw log.ambiguousLatitudeDefinition(clazz.getName(), latitudeField, property.getName());
                    }
                    latitudeField = property.getName();
                }
                if (!property.isAnnotationPresent(Longitude.class) || !((Longitude)property.getAnnotation(Longitude.class)).of().equals(spatialAnnotation.name())) continue;
                if (longitudeField != null) {
                    throw log.ambiguousLongitudeDefinition(clazz.getName(), longitudeField, property.getName());
                }
                longitudeField = property.getName();
            }
            List propertyList = clazz.getDeclaredProperties("property");
            for (XProperty property : propertyList) {
                if (property.isAnnotationPresent(Latitude.class) && ((Latitude)property.getAnnotation(Latitude.class)).of().equals(spatialAnnotation.name())) {
                    if (latitudeField != null) {
                        throw log.ambiguousLatitudeDefinition(clazz.getName(), latitudeField, property.getName());
                    }
                    latitudeField = property.getName();
                }
                if (!property.isAnnotationPresent(Longitude.class) || !((Longitude)property.getAnnotation(Longitude.class)).of().equals(spatialAnnotation.name())) continue;
                if (longitudeField != null) {
                    throw log.ambiguousLongitudeDefinition(clazz.getName(), longitudeField, property.getName());
                }
                longitudeField = property.getName();
            }
            spatialBridge = latitudeField != null && longitudeField != null ? this.bridgeFactory.buildSpatialBridge(spatialAnnotation, clazz, latitudeField, longitudeField) : null;
        }
        if (spatialBridge == null) {
            throw log.cannotFindCoordinatesNorLatLongForSpatial(spatialAnnotation.name().isEmpty() ? "default" : spatialAnnotation.name(), clazz.getName());
        }
        return spatialBridge;
    }

    private void bindSortableFieldAnnotation(SortableField sortableFieldAnnotation, String prefix, XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, boolean isIdProperty, ParseContext parseContext) {
        String sortedFieldName = prefix + ReflectionHelper.getAttributeName((XMember)member, sortableFieldAnnotation.forField());
        String idFieldName = null;
        if (isIdProperty) {
            idFieldName = propertyMetadataBuilder.getFieldMetadata().iterator().next().getFieldName();
            if (!sortedFieldName.equals(idFieldName)) {
                return;
            }
        } else {
            if (typeMetadataBuilder.getIdPropertyMetadata() != null) {
                idFieldName = typeMetadataBuilder.getIdPropertyMetadata().getFieldMetadataSet().iterator().next().getFieldName();
            }
            if (sortedFieldName.equals(idFieldName)) {
                return;
            }
        }
        if (!sortedFieldName.equals(idFieldName) && !this.containsField(propertyMetadataBuilder, sortedFieldName)) {
            if (parseContext.getLevel() != 0) {
                return;
            }
            throw log.sortableFieldRefersToUndefinedField(typeMetadataBuilder.getIndexedType(), propertyMetadataBuilder.getPropertyAccessor().getName(), sortedFieldName);
        }
        SortableFieldMetadata fieldMetadata = new SortableFieldMetadata.Builder().fieldName(sortedFieldName).build();
        propertyMetadataBuilder.addSortableField(fieldMetadata);
    }

    private boolean containsField(PropertyMetadata.Builder propertyMetadataBuilder, String fieldName) {
        for (DocumentFieldMetadata field : propertyMetadataBuilder.getFieldMetadata()) {
            if (!field.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private void initializeMemberLevelAnnotations(String prefix, XProperty member, TypeMetadata.Builder typeMetadataBuilder, boolean disableOptimizations, boolean isRoot, boolean isProvidedId, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        PropertyMetadata.Builder propertyMetadataBuilder = new PropertyMetadata.Builder(member).dynamicBoostStrategy(AnnotationProcessingHelper.getDynamicBoost((XAnnotatedElement)member));
        NumericFieldsConfiguration numericFields = this.buildNumericFieldsConfiguration(typeMetadataBuilder.getIndexedType(), member, prefix, pathsContext, parseContext);
        if (!isProvidedId) {
            this.checkDocumentId(member, typeMetadataBuilder, propertyMetadataBuilder, numericFields, isRoot, prefix, configContext, pathsContext, parseContext);
        }
        this.checkForField(member, typeMetadataBuilder, propertyMetadataBuilder, numericFields, prefix, configContext, pathsContext, parseContext);
        this.checkForFields(member, typeMetadataBuilder, propertyMetadataBuilder, numericFields, prefix, configContext, pathsContext, parseContext);
        this.checkForSpatial(member, typeMetadataBuilder, propertyMetadataBuilder, prefix, pathsContext, parseContext);
        this.checkForSpatialsAnnotation(member, typeMetadataBuilder, propertyMetadataBuilder, prefix, pathsContext, parseContext);
        this.checkForSortableField(member, typeMetadataBuilder, propertyMetadataBuilder, prefix, false, pathsContext, parseContext);
        this.checkForSortableFields(member, typeMetadataBuilder, propertyMetadataBuilder, prefix, false, pathsContext, parseContext);
        this.checkForAnalyzerDefs((XAnnotatedElement)member, configContext);
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)member, typeMetadataBuilder, configContext);
        this.checkForIndexedEmbedded(member, prefix, disableOptimizations, typeMetadataBuilder, configContext, pathsContext, parseContext);
        this.checkForContainedIn(member, typeMetadataBuilder, parseContext);
        numericFields.validate();
        PropertyMetadata property = propertyMetadataBuilder.build();
        if (!property.getFieldMetadataSet().isEmpty()) {
            typeMetadataBuilder.addProperty(property);
        }
    }

    private void checkForContainedIn(XProperty member, TypeMetadata.Builder typeMetadataBuilder, ParseContext parseContext) {
        ContainedIn containedInAnnotation = (ContainedIn)member.getAnnotation(ContainedIn.class);
        if (containedInAnnotation == null) {
            return;
        }
        ContainedInMetadata containedInMetadata = this.createContainedInMetadata(member);
        typeMetadataBuilder.addContainedIn(containedInMetadata);
        parseContext.collectUnqualifiedCollectionRole(member.getName());
    }

    private ContainedInMetadata createContainedInMetadata(XProperty member) {
        ContainedInMetadataBuilder containedInMetadataBuilder = new ContainedInMetadataBuilder((XMember)member);
        this.updateContainedInMetadata(containedInMetadataBuilder, member, "field");
        this.updateContainedInMetadata(containedInMetadataBuilder, member, "property");
        return containedInMetadataBuilder.createContainedInMetadata();
    }

    private void updateContainedInMetadata(ContainedInMetadataBuilder containedInMetadataBuilder, XProperty propertyWithContainedIn, String accessType) {
        XClass memberReturnedType = propertyWithContainedIn.getElementClass();
        String mappedBy = this.mappedBy((XMember)propertyWithContainedIn);
        List returnedTypeProperties = memberReturnedType.getDeclaredProperties(accessType);
        for (XProperty property : returnedTypeProperties) {
            if (!this.isCorrespondingIndexedEmbedded(propertyWithContainedIn, mappedBy, property)) continue;
            this.updateContainedInMetadataForProperty(containedInMetadataBuilder, property);
            break;
        }
    }

    private boolean isCorrespondingIndexedEmbedded(XProperty memberWithContainedIn, String mappedBy, XProperty candidateProperty) {
        if (!candidateProperty.isAnnotationPresent(IndexedEmbedded.class)) {
            return false;
        }
        if (mappedBy.equals(candidateProperty.getName())) {
            return true;
        }
        if (mappedBy.isEmpty()) {
            String reverseMappedBy = this.mappedBy((XMember)candidateProperty);
            return reverseMappedBy.equals(memberWithContainedIn.getName());
        }
        return false;
    }

    private void updateContainedInMetadataForProperty(ContainedInMetadataBuilder containedInMetadataBuilder, XProperty property) {
        IndexedEmbedded indexedEmbeddedAnnotation = (IndexedEmbedded)property.getAnnotation(IndexedEmbedded.class);
        containedInMetadataBuilder.maxDepth(indexedEmbeddedAnnotation.depth());
        containedInMetadataBuilder.prefix(this.buildEmbeddedPrefix("", indexedEmbeddedAnnotation, property));
        containedInMetadataBuilder.includePaths(indexedEmbeddedAnnotation.includePaths());
    }

    private String mappedBy(XMember member) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = member.getAnnotations()) {
            String mappedBy = this.mappedBy(annotation);
            if (!StringHelper.isNotEmpty(mappedBy)) continue;
            return mappedBy;
        }
        return "";
    }

    private String mappedBy(Annotation annotation) {
        try {
            Method declaredMethod = annotation.annotationType().getDeclaredMethod("mappedBy", new Class[0]);
            return (String)declaredMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (SecurityException e) {
            return "";
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
    }

    private NumericFieldsConfiguration buildNumericFieldsConfiguration(Class<?> indexedType, XProperty member, String prefix, PathsContext pathsContext, ParseContext parseContext) {
        NumericFields numericFieldsAnnotation;
        HashMap<String, NumericField> fieldsMarkedAsNumeric = new HashMap<String, NumericField>();
        NumericField numericFieldAnnotation = (NumericField)member.getAnnotation(NumericField.class);
        if (numericFieldAnnotation != null && (this.isFieldInPath(numericFieldAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            fieldsMarkedAsNumeric.put(numericFieldAnnotation.forField(), numericFieldAnnotation);
        }
        if ((numericFieldsAnnotation = (NumericFields)member.getAnnotation(NumericFields.class)) != null) {
            for (NumericField numericField : numericFieldsAnnotation.value()) {
                NumericField existing;
                if (!this.isFieldInPath(numericFieldAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached() || (existing = fieldsMarkedAsNumeric.put(numericField.forField(), numericField)) == null) continue;
                throw log.severalNumericFieldAnnotationsForSameField(indexedType, member.getName());
            }
        }
        return new NumericFieldsConfiguration(indexedType, member, fieldsMarkedAsNumeric);
    }

    private void checkForField(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, NumericFieldsConfiguration numericFields, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        Field fieldAnnotation = (Field)member.getAnnotation(Field.class);
        if (fieldAnnotation != null && (this.isFieldInPath(fieldAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            Set<Facet> facetAnnotations = this.findMatchingFacetAnnotations((XMember)member, fieldAnnotation.name());
            this.bindFieldAnnotation(prefix, fieldAnnotation, numericFields, facetAnnotations, typeMetadataBuilder, propertyMetadataBuilder, configContext, parseContext);
        }
    }

    private Set<Facet> findMatchingFacetAnnotations(XMember member, String fieldName) {
        Facet facetAnnotation = (Facet)member.getAnnotation(Facet.class);
        Facets facetsAnnotation = (Facets)member.getAnnotation(Facets.class);
        if (facetAnnotation == null && facetsAnnotation == null) {
            return Collections.emptySet();
        }
        HashSet<Facet> matchingFacetAnnotations = new HashSet<Facet>(1);
        if (facetAnnotation != null && facetAnnotation.forField().equals(fieldName)) {
            matchingFacetAnnotations.add(facetAnnotation);
        }
        if (facetsAnnotation != null) {
            for (Facet annotation : facetsAnnotation.value()) {
                if (annotation == null || !annotation.forField().equals(fieldName)) continue;
                matchingFacetAnnotations.add(annotation);
            }
        }
        return matchingFacetAnnotations;
    }

    private void bindFieldAnnotation(String prefix, Field fieldAnnotation, NumericFieldsConfiguration numericFields, Set<Facet> facetAnnotations, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, ConfigContext configContext, ParseContext parseContext) {
        DocumentFieldMetadata.Builder fieldMetadataBuilder;
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType;
        NullMarkerCodec nullTokenCodec;
        XProperty member = propertyMetadataBuilder.getPropertyAccessor();
        if (this.isPropertyTransient(member, configContext)) {
            typeMetadataBuilder.disableStateInspectionOptimization();
        }
        String unPrefixedFieldName = ReflectionHelper.getAttributeName((XMember)member, fieldAnnotation.name());
        String fieldName = prefix + unPrefixedFieldName;
        Store store = fieldAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(fieldAnnotation.index(), fieldAnnotation.analyze(), fieldAnnotation.norms());
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(fieldAnnotation.termVector());
        NumericField numericFieldAnnotation = numericFields.getNumericFieldAnnotation(unPrefixedFieldName);
        FieldBridge fieldBridge = this.bridgeFactory.buildFieldBridge(fieldAnnotation, (XMember)member, false, numericFieldAnnotation != null, this.reflectionManager, configContext.getServiceManager());
        if (fieldBridge instanceof MetadataProvidingFieldBridge) {
            MetadataProvidingFieldBridge metadataProvidingFieldBridge = (MetadataProvidingFieldBridge)fieldBridge;
            for (String sortableField : this.getSortableFieldNames(fieldName, metadataProvidingFieldBridge)) {
                SortableFieldMetadata sortableFieldMetadata = new SortableFieldMetadata.Builder().fieldName(sortableField).build();
                propertyMetadataBuilder.addSortableField(sortableFieldMetadata);
            }
        }
        if ((nullTokenCodec = this.determineNullMarkerCodec(fieldAnnotation, configContext, numericEncodingType = this.determineNumericFieldEncoding(fieldBridge), fieldName)) != NotEncodingCodec.SINGLETON && fieldBridge instanceof TwoWayFieldBridge) {
            fieldBridge = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)fieldBridge, nullTokenCodec);
        }
        org.apache.lucene.analysis.Analyzer analyzer = this.determineAnalyzer(fieldAnnotation, member, configContext);
        analyzer = typeMetadataBuilder.addToScopedAnalyzer(fieldName, analyzer, index);
        if (this.isNumericField(numericFieldAnnotation, fieldBridge)) {
            fieldMetadataBuilder = new DocumentFieldMetadata.Builder(fieldName, store, Field.Index.NOT_ANALYZED_NO_NORMS, termVector).boost(AnnotationProcessingHelper.getBoost(member, fieldAnnotation)).fieldBridge(fieldBridge).analyzer(analyzer).indexNullAs(nullTokenCodec).numeric().precisionStep(AnnotationProcessingHelper.getPrecisionStep(numericFieldAnnotation)).numericEncodingType(numericEncodingType);
        } else {
            fieldMetadataBuilder = new DocumentFieldMetadata.Builder(fieldName, store, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, fieldAnnotation)).fieldBridge(fieldBridge).analyzer(analyzer).indexNullAs(nullTokenCodec);
            if (fieldBridge instanceof SpatialFieldBridge) {
                fieldMetadataBuilder.spatial();
            }
        }
        for (Facet facetAnnotation : facetAnnotations) {
            if (Analyze.YES.equals((Object)fieldAnnotation.analyze())) {
                throw log.attemptToFacetOnAnalyzedField(fieldName, member.getDeclaringClass().getName());
            }
            String facetName = facetAnnotation.name().isEmpty() ? fieldName : prefix + facetAnnotation.name();
            FacetMetadata.Builder facetMetadataBuilder = new FacetMetadata.Builder(facetName);
            FacetEncodingType facetEncodingType = this.determineFacetEncodingType(member, facetAnnotation);
            facetMetadataBuilder.setFacetEncoding(facetEncodingType);
            fieldMetadataBuilder.addFacetMetadata(facetMetadataBuilder.build());
        }
        DocumentFieldMetadata fieldMetadata = fieldMetadataBuilder.build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        parseContext.collectUnqualifiedCollectionRole(member.getName());
    }

    private FacetEncodingType determineFacetEncodingType(XProperty member, Facet facetAnnotation) {
        FacetEncodingType facetEncodingType = facetAnnotation.encoding();
        if (!facetEncodingType.equals((Object)FacetEncodingType.AUTO)) {
            return facetEncodingType;
        }
        Class indexedType = this.reflectionManager.toClass(member.getElementClass());
        if (ReflectionHelper.isIntegerType(indexedType)) {
            facetEncodingType = FacetEncodingType.LONG;
        } else if (Date.class.isAssignableFrom(indexedType) || Calendar.class.isAssignableFrom(indexedType)) {
            facetEncodingType = FacetEncodingType.LONG;
        } else if (ReflectionHelper.isFloatingPointType(indexedType)) {
            facetEncodingType = FacetEncodingType.DOUBLE;
        } else if (String.class.isAssignableFrom(indexedType)) {
            facetEncodingType = FacetEncodingType.STRING;
        } else {
            throw log.unsupportedFieldTypeForFaceting(indexedType.getName(), member.getDeclaringClass().getName(), member.getName());
        }
        return facetEncodingType;
    }

    private boolean isNumericField(NumericField numericFieldAnnotation, FieldBridge fieldBridge) {
        if (fieldBridge instanceof ContainerBridge) {
            fieldBridge = ((ContainerBridge)((Object)fieldBridge)).getElementBridge();
        }
        if (fieldBridge instanceof NullEncodingTwoWayFieldBridge) {
            fieldBridge = ((NullEncodingTwoWayFieldBridge)fieldBridge).unwrap();
        }
        return numericFieldAnnotation != null || fieldBridge instanceof NumericFieldBridge || fieldBridge instanceof NumericEncodingDateBridge || fieldBridge instanceof NumericTimeBridge;
    }

    private NumericFieldSettingsDescriptor.NumericEncodingType determineNumericFieldEncoding(FieldBridge fieldBridge) {
        if (fieldBridge instanceof ContainerBridge) {
            fieldBridge = ((ContainerBridge)((Object)fieldBridge)).getElementBridge();
        }
        if (fieldBridge instanceof NumericFieldBridge) {
            NumericFieldBridge numericFieldBridge = (NumericFieldBridge)fieldBridge;
            switch (numericFieldBridge) {
                case BYTE_FIELD_BRIDGE: 
                case SHORT_FIELD_BRIDGE: 
                case INT_FIELD_BRIDGE: {
                    return NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
                }
                case LONG_FIELD_BRIDGE: {
                    return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
                }
                case DOUBLE_FIELD_BRIDGE: {
                    return NumericFieldSettingsDescriptor.NumericEncodingType.DOUBLE;
                }
                case FLOAT_FIELD_BRIDGE: {
                    return NumericFieldSettingsDescriptor.NumericEncodingType.FLOAT;
                }
            }
            return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
        }
        if (fieldBridge instanceof NumericEncodingDateBridge) {
            return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
        }
        if (fieldBridge instanceof NumericTimeBridge) {
            return ((NumericTimeBridge)((Object)fieldBridge)).getEncodingType();
        }
        return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
    }

    private NullMarkerCodec determineNullMarkerCodec(Field fieldAnnotation, ConfigContext context, NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType, String fieldName) {
        if (fieldAnnotation == null) {
            return NotEncodingCodec.SINGLETON;
        }
        String indexNullAs = fieldAnnotation.indexNullAs();
        if (indexNullAs.equals("__DO_NOT_INDEX_NULL__")) {
            return NotEncodingCodec.SINGLETON;
        }
        if (indexNullAs.equals("__DEFAULT_NULL_TOKEN__") && numericEncodingType == NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN) {
            return new KeywordBasedNullCodec(context.getDefaultNullToken());
        }
        if (numericEncodingType == NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN) {
            return new KeywordBasedNullCodec(indexNullAs);
        }
        if (indexNullAs.equals("__DEFAULT_NULL_TOKEN__")) {
            return NumericNullEncodersHelper.createNumericNullMarkerCodec(numericEncodingType, context.getDefaultNullToken(), fieldName);
        }
        return NumericNullEncodersHelper.createNumericNullMarkerCodec(numericEncodingType, indexNullAs, fieldName);
    }

    private org.apache.lucene.analysis.Analyzer determineAnalyzer(Field fieldAnnotation, XProperty member, ConfigContext context) {
        org.apache.lucene.analysis.Analyzer analyzer = null;
        if (fieldAnnotation != null) {
            analyzer = AnnotationProcessingHelper.getAnalyzer(fieldAnnotation.analyzer(), context);
        }
        if (analyzer == null) {
            analyzer = AnnotationProcessingHelper.getAnalyzer((Analyzer)member.getAnnotation(Analyzer.class), context);
        }
        return analyzer;
    }

    private boolean isPropertyTransient(XProperty member, ConfigContext context) {
        Annotation transientAnnotation;
        if (!context.isJpaPresent()) {
            return false;
        }
        try {
            Class transientAnnotationClass = ClassLoaderHelper.classForName("javax.persistence.Transient", this.configContext.getServiceManager());
            transientAnnotation = member.getAnnotation(transientAnnotationClass);
        }
        catch (ClassLoadingException e) {
            throw new SearchException("Unable to load @Transient.class even though it should be present ?!");
        }
        return transientAnnotation != null;
    }

    private void checkForSpatialsAnnotation(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, PathsContext pathsContext, ParseContext parseContext) {
        Spatials spatialsAnnotation = (Spatials)member.getAnnotation(Spatials.class);
        if (spatialsAnnotation != null) {
            for (Spatial spatialAnnotation : spatialsAnnotation.value()) {
                if (!this.isFieldInPath(spatialAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached()) continue;
                this.bindSpatialAnnotation(spatialAnnotation, prefix, member, typeMetadataBuilder, propertyMetadataBuilder, parseContext);
            }
        }
    }

    private void checkForSpatial(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, PathsContext pathsContext, ParseContext parseContext) {
        Spatial spatialAnnotation = (Spatial)member.getAnnotation(Spatial.class);
        if (spatialAnnotation != null && (this.isFieldInPath(spatialAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            this.bindSpatialAnnotation(spatialAnnotation, prefix, member, typeMetadataBuilder, propertyMetadataBuilder, parseContext);
        }
    }

    private void checkForSortableField(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, boolean isIdProperty, PathsContext pathsContext, ParseContext parseContext) {
        SortableField sortableFieldAnnotation = (SortableField)member.getAnnotation(SortableField.class);
        if (sortableFieldAnnotation != null && (this.isFieldInPath(sortableFieldAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            this.bindSortableFieldAnnotation(sortableFieldAnnotation, prefix, member, typeMetadataBuilder, propertyMetadataBuilder, isIdProperty, parseContext);
        }
    }

    private void checkForSortableFields(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, boolean isIdProperty, PathsContext pathsContext, ParseContext parseContext) {
        SortableFields sortableFieldsAnnotation = (SortableFields)member.getAnnotation(SortableFields.class);
        if (sortableFieldsAnnotation != null) {
            for (SortableField sortableFieldAnnotation : sortableFieldsAnnotation.value()) {
                if (!this.isFieldInPath(sortableFieldAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached()) continue;
                this.bindSortableFieldAnnotation(sortableFieldAnnotation, prefix, member, typeMetadataBuilder, propertyMetadataBuilder, isIdProperty, parseContext);
            }
        }
    }

    private void checkForAnalyzerDefs(XAnnotatedElement annotatedElement, ConfigContext context) {
        AnalyzerDefs defs = (AnalyzerDefs)annotatedElement.getAnnotation(AnalyzerDefs.class);
        if (defs != null) {
            for (AnalyzerDef def : defs.value()) {
                context.addAnalyzerDef(def, annotatedElement);
            }
        }
        AnalyzerDef def = (AnalyzerDef)annotatedElement.getAnnotation(AnalyzerDef.class);
        context.addAnalyzerDef(def, annotatedElement);
    }

    private void checkForFullTextFilterDefs(XAnnotatedElement annotatedElement, ConfigContext context) {
        FullTextFilterDefs defs = (FullTextFilterDefs)annotatedElement.getAnnotation(FullTextFilterDefs.class);
        if (defs != null) {
            for (FullTextFilterDef def : defs.value()) {
                context.addFullTextFilterDef(def, annotatedElement);
            }
        }
        FullTextFilterDef def = (FullTextFilterDef)annotatedElement.getAnnotation(FullTextFilterDef.class);
        context.addFullTextFilterDef(def, annotatedElement);
    }

    private void checkForAnalyzerDiscriminator(XAnnotatedElement annotatedElement, TypeMetadata.Builder typeMetadataBuilder, ConfigContext context) {
        AnalyzerDiscriminator discriminatorAnnotation = (AnalyzerDiscriminator)annotatedElement.getAnnotation(AnalyzerDiscriminator.class);
        if (discriminatorAnnotation == null) {
            return;
        }
        if (annotatedElement instanceof XProperty && this.isPropertyTransient((XProperty)annotatedElement, context)) {
            typeMetadataBuilder.disableStateInspectionOptimization();
        }
        Class<? extends Discriminator> discriminatorClass = discriminatorAnnotation.impl();
        Discriminator discriminator = ClassLoaderHelper.instanceFromClass(Discriminator.class, discriminatorClass, "analyzer discriminator implementation");
        if (annotatedElement instanceof XMember) {
            typeMetadataBuilder.analyzerDiscriminator(discriminator, (XMember)annotatedElement);
        } else {
            typeMetadataBuilder.analyzerDiscriminator(discriminator, null);
        }
    }

    private void checkForFields(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, NumericFieldsConfiguration numericFields, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        Fields fieldsAnnotation = (Fields)member.getAnnotation(Fields.class);
        if (fieldsAnnotation != null && fieldsAnnotation.value().length > 0) {
            for (Field fieldAnnotation : fieldsAnnotation.value()) {
                if (!this.isFieldInPath(fieldAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached()) continue;
                Set<Facet> facetAnnotations = this.findMatchingFacetAnnotations((XMember)member, fieldAnnotation.name());
                this.bindFieldAnnotation(prefix, fieldAnnotation, numericFields, facetAnnotations, typeMetadataBuilder, propertyMetadataBuilder, configContext, parseContext);
            }
        }
    }

    private boolean isFieldInPath(Annotation fieldAnnotation, XProperty member, PathsContext pathsContext, String prefix) {
        String path;
        if (pathsContext != null && pathsContext.containsPath(path = prefix + this.fieldName(fieldAnnotation, member))) {
            pathsContext.markEncounteredPath(path);
            return true;
        }
        return false;
    }

    private String fieldName(Annotation fieldAnnotation, XProperty member) {
        if (fieldAnnotation == null) {
            return member.getName();
        }
        String fieldName = AnnotationProcessingHelper.getFieldName(fieldAnnotation);
        if (fieldName == null || fieldName.isEmpty()) {
            return member.getName();
        }
        return fieldName;
    }

    private void checkForIndexedEmbedded(XProperty member, String prefix, boolean disableOptimizations, TypeMetadata.Builder typeMetadataBuilder, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        IndexedEmbedded indexedEmbeddedAnnotation = (IndexedEmbedded)member.getAnnotation(IndexedEmbedded.class);
        if (indexedEmbeddedAnnotation == null) {
            return;
        }
        parseContext.collectUnqualifiedCollectionRole(member.getName());
        int oldMaxLevel = parseContext.getMaxLevel();
        int potentialLevel = this.depth(indexedEmbeddedAnnotation) + parseContext.getLevel();
        if (potentialLevel < 0) {
            potentialLevel = Integer.MAX_VALUE;
        }
        if (potentialLevel < oldMaxLevel) {
            parseContext.setMaxLevel(potentialLevel);
        }
        parseContext.incrementLevel();
        XClass elementClass = Void.TYPE == indexedEmbeddedAnnotation.targetElement() ? member.getElementClass() : this.reflectionManager.toXClass(indexedEmbeddedAnnotation.targetElement());
        if (parseContext.getMaxLevel() == Integer.MAX_VALUE && parseContext.hasBeenProcessed(elementClass)) {
            throw log.detectInfiniteTypeLoopInIndexedEmbedded(elementClass.getName(), typeMetadataBuilder.getIndexedType().getName(), this.buildEmbeddedPrefix(prefix, indexedEmbeddedAnnotation, member));
        }
        String localPrefix = this.buildEmbeddedPrefix(prefix, indexedEmbeddedAnnotation, member);
        PathsContext updatedPathsContext = this.updatePaths(localPrefix, pathsContext, indexedEmbeddedAnnotation);
        boolean pathsCreatedAtThisLevel = false;
        if (pathsContext == null && updatedPathsContext != null) {
            pathsCreatedAtThisLevel = true;
        }
        if (!parseContext.isMaxLevelReached() || this.isInPath(localPrefix, updatedPathsContext, indexedEmbeddedAnnotation)) {
            parseContext.processingClass(elementClass);
            EmbeddedTypeMetadata.Builder embeddedTypeMetadataBuilder = new EmbeddedTypeMetadata.Builder(this.reflectionManager.toClass(elementClass), (XMember)member, typeMetadataBuilder.getScopedAnalyzer());
            embeddedTypeMetadataBuilder.boost(AnnotationProcessingHelper.getBoost(member, null).floatValue());
            org.apache.lucene.analysis.Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((Analyzer)member.getAnnotation(Analyzer.class), configContext);
            if (analyzer == null) {
                analyzer = typeMetadataBuilder.getAnalyzer();
            }
            embeddedTypeMetadataBuilder.analyzer(analyzer);
            if (disableOptimizations) {
                typeMetadataBuilder.blacklistForOptimization(elementClass);
            }
            XClass previousClass = parseContext.getCurrentClass();
            parseContext.setCurrentClass(elementClass);
            boolean previousIncludeEmbeddedObjectId = parseContext.includeEmbeddedObjectId();
            parseContext.setIncludeEmbeddedObjectId(indexedEmbeddedAnnotation.includeEmbeddedObjectId());
            this.initializeClass(embeddedTypeMetadataBuilder, false, localPrefix, parseContext, configContext, disableOptimizations, updatedPathsContext);
            parseContext.setCurrentClass(previousClass);
            parseContext.setIncludeEmbeddedObjectId(previousIncludeEmbeddedObjectId);
            String indexNullAs = this.embeddedNullToken(configContext, indexedEmbeddedAnnotation);
            if (indexNullAs != null) {
                NullEncodingFieldBridge fieldBridge = new NullEncodingFieldBridge(NULL_EMBEDDED_STRING_BRIDGE, indexNullAs);
                embeddedTypeMetadataBuilder.indexNullToken(indexNullAs, this.embeddedNullField(localPrefix), fieldBridge);
            }
            EmbeddedTypeMetadata embeddedTypeMetadata = embeddedTypeMetadataBuilder.build();
            for (XClass xClass : embeddedTypeMetadata.getOptimizationBlackList()) {
                typeMetadataBuilder.blacklistForOptimization(xClass);
            }
            typeMetadataBuilder.addEmbeddedType(embeddedTypeMetadata);
            parseContext.removeProcessedClass(elementClass);
        } else if (log.isTraceEnabled()) {
            log.tracef("depth reached, ignoring %s", localPrefix);
        }
        parseContext.decrementLevel();
        parseContext.setMaxLevel(oldMaxLevel);
        if (pathsCreatedAtThisLevel) {
            this.validateAllPathsEncountered(member, updatedPathsContext, indexedEmbeddedAnnotation);
        }
    }

    private int depth(IndexedEmbedded embeddedAnn) {
        if (this.isDepthNotSet(embeddedAnn) && embeddedAnn.includePaths().length > 0) {
            return 0;
        }
        return embeddedAnn.depth();
    }

    private boolean isDepthNotSet(IndexedEmbedded embeddedAnn) {
        return Integer.MAX_VALUE == embeddedAnn.depth();
    }

    private boolean isInPath(String localPrefix, PathsContext pathsContext, IndexedEmbedded embeddedAnn) {
        if (pathsContext != null) {
            boolean defaultPrefix = this.isDefaultPrefix(embeddedAnn);
            Iterator<String> iterator = pathsContext.getEncounteredPaths().iterator();
            while (iterator.hasNext()) {
                String path;
                String app = path = iterator.next();
                if (defaultPrefix) {
                    app = app + ".";
                }
                if (!app.startsWith(localPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    private PathsContext updatePaths(String localPrefix, PathsContext pathsContext, IndexedEmbedded indexedEmbeddedAnnotation) {
        if (pathsContext != null) {
            return pathsContext;
        }
        if (indexedEmbeddedAnnotation.includePaths().length == 0) {
            return null;
        }
        PathsContext newPathsContext = new PathsContext();
        for (String path : indexedEmbeddedAnnotation.includePaths()) {
            newPathsContext.addPath(localPrefix + path);
        }
        return newPathsContext;
    }

    private String buildEmbeddedPrefix(String prefix, IndexedEmbedded indexedEmbeddedAnnotation, XProperty member) {
        String localPrefix = prefix;
        localPrefix = this.isDefaultPrefix(indexedEmbeddedAnnotation) ? localPrefix + member.getName() + '.' : localPrefix + indexedEmbeddedAnnotation.prefix();
        return localPrefix;
    }

    private boolean isDefaultPrefix(IndexedEmbedded indexedEmbeddedAnnotation) {
        return ".".equals(indexedEmbeddedAnnotation.prefix());
    }

    private String embeddedNullField(String localPrefix) {
        if (localPrefix.endsWith(".")) {
            return localPrefix.substring(0, localPrefix.length() - 1);
        }
        return localPrefix;
    }

    private void validateAllPathsEncountered(XProperty member, PathsContext updatedPathsContext, IndexedEmbedded indexedEmbeddedAnnotation) {
        Set<String> unEncounteredPaths = updatedPathsContext.getUnEncounteredPaths();
        if (unEncounteredPaths.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String prefix = indexedEmbeddedAnnotation.prefix();
            for (String path : unEncounteredPaths) {
                sb.append(this.removeLeadingPrefixFromPath(path, prefix));
                sb.append(',');
            }
            String invalidPaths = sb.substring(0, sb.length() - 1);
            throw log.invalidIncludePathConfiguration(member.getName(), member.getDeclaringClass().getName(), invalidPaths);
        }
    }

    private String removeLeadingPrefixFromPath(String path, String prefix) {
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    private String embeddedNullToken(ConfigContext context, IndexedEmbedded indexedEmbeddedAnnotation) {
        String indexNullAs = indexedEmbeddedAnnotation.indexNullAs();
        if ("__DO_NOT_INDEX_NULL__".equals(indexNullAs)) {
            return null;
        }
        if ("__DEFAULT_NULL_TOKEN__".equals(indexNullAs)) {
            return context.getDefaultNullToken();
        }
        return indexNullAs;
    }

    boolean stateInspectionOptimizationsEnabled(TypeMetadata.Builder typeMetadataBuilder) {
        if (!typeMetadataBuilder.isStateInspectionOptimizationsEnabled()) {
            return false;
        }
        if (typeMetadataBuilder.areClassBridgesUsed()) {
            log.tracef("State inspection optimization disabled as entity %s uses class bridges", typeMetadataBuilder.getIndexedType().getName());
            return false;
        }
        BoostStrategy boostStrategy = typeMetadataBuilder.getClassBoostStrategy();
        if (boostStrategy != null && !(boostStrategy instanceof DefaultBoostStrategy)) {
            log.tracef("State inspection optimization disabled as DynamicBoost is enabled on entity %s", typeMetadataBuilder.getIndexedType().getName());
            return false;
        }
        return true;
    }

    private Set<String> getSortableFieldNames(String fieldName, MetadataProvidingFieldBridge metadataProvidingFieldBridge) {
        FieldMetadataBuilderImpl builder = new FieldMetadataBuilderImpl();
        metadataProvidingFieldBridge.configureFieldMetadata(fieldName, builder);
        return builder.getSortableFields();
    }
}

